/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CommonDockStationLayout {
    private String id;
    private boolean root;
    private String factoryId;
    private DockLayoutInfo layout = new DockLayoutInfo();

    public CommonDockStationLayout(String string, boolean bl, String string2, DockLayout<?> dockLayout) {
        if (string2 == null) {
            throw new IllegalArgumentException("factoryId must not be null");
        }
        this.id = string;
        this.root = bl;
        this.factoryId = string2;
        if (dockLayout != null) {
            this.layout.setData(dockLayout);
        }
    }

    public CommonDockStationLayout(String string, boolean bl, String string2, byte[] byArray) {
        if (string2 == null) {
            throw new IllegalArgumentException("factoryId must not be null");
        }
        this.id = string;
        this.root = bl;
        this.factoryId = string2;
        if (byArray != null) {
            this.layout.setData(byArray);
        }
    }

    public CommonDockStationLayout(String string, boolean bl, String string2, XElement xElement) {
        if (string2 == null) {
            throw new IllegalArgumentException("factoryId must not be null");
        }
        this.id = string;
        this.root = bl;
        this.factoryId = string2;
        if (xElement != null) {
            this.layout.setData(xElement);
        }
    }

    public void updateLayout(DockFactory<?, ?, Object> dockFactory, PlaceholderStrategy placeholderStrategy) {
        try {
            Object l = null;
            switch (this.layout.getKind()) {
                case BYTE: {
                    l = dockFactory.read(new DataInputStream(new ByteArrayInputStream(this.layout.getDataByte())), placeholderStrategy);
                    break;
                }
                case XML: {
                    l = dockFactory.read(this.layout.getDataXML(), placeholderStrategy);
                }
            }
            if (l != null) {
                this.layout.setData(new DockLayout<Object>(dockFactory.getID(), l));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public byte[] getLayoutBytes() {
        return this.layout.getDataByte();
    }

    public XElement getLayoutXML() {
        return this.layout.getDataXML();
    }

    public DockLayout<?> getLayout() {
        return this.layout.getDataLayout();
    }
}

