/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStationLayout;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonDockStationPerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;

public class CommonDockStationFactory
implements DockFactory<CommonDockStation<?, ?>, CommonDockStationPerspective, CommonDockStationLayout> {
    public static final String FACTORY_ID = "CommonDockStationFactory";
    private CControl control;
    private CommonSingleDockableFactory singleDockableFactory;
    private FrontendPerspectiveCache cache;

    public CommonDockStationFactory(CControl cControl, FrontendPerspectiveCache frontendPerspectiveCache, CommonSingleDockableFactory commonSingleDockableFactory) {
        if (cControl == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        if (commonSingleDockableFactory == null) {
            throw new IllegalArgumentException("singleDockableFactory must not be null");
        }
        this.control = cControl;
        this.cache = frontendPerspectiveCache;
        this.singleDockableFactory = commonSingleDockableFactory;
    }

    protected CommonDockStation<?, ?> createStation(String string) {
        SingleCDockableFactory singleCDockableFactory = this.singleDockableFactory.getFactory(string);
        if (singleCDockableFactory == null) {
            return null;
        }
        SingleCDockable singleCDockable = singleCDockableFactory.createBackup(string);
        if (singleCDockable == null) {
            return null;
        }
        String string2 = singleCDockable.intern().getFactoryID();
        if (!string2.equals(this.getID())) {
            throw new IllegalArgumentException("Wrong type of dockable for unique id '" + string + "': The backup factory created a dockable which expects a factory of type '" + string2 + "',  but the call was done from a factory of type '" + this.getID() + "'");
        }
        CStation<?> cStation = singleCDockable.asStation();
        if (cStation == null) {
            System.err.println("unique identifier '" + string + "' was supposed to be a CStation, but factory created a dockable");
            return null;
        }
        return cStation.getStation();
    }

    protected void registerStation(CStation<?> cStation, boolean bl) {
        SingleCDockable singleCDockable;
        CDockable cDockable;
        if (this.control.getStation(cStation.getUniqueId()) != cStation) {
            this.control.addStation(cStation, bl);
        }
        if ((cDockable = cStation.asDockable()) != null && cDockable instanceof SingleCDockable && this.control.getSingleDockable((singleCDockable = (SingleCDockable)cDockable).getUniqueId()) != singleCDockable) {
            this.control.addDockable(singleCDockable);
        }
    }

    @Override
    public String getID() {
        return FACTORY_ID;
    }

    @Override
    public CommonDockStationLayout getLayout(CommonDockStation<?, ?> commonDockStation, Map<Dockable, Integer> map) {
        String string = commonDockStation.getConverterID();
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string);
        if (dockFactory == null) {
            return null;
        }
        Object l = dockFactory.getLayout(commonDockStation, map);
        if (l == null) {
            return null;
        }
        CDockable cDockable = commonDockStation.getStation().asDockable();
        String string2 = null;
        if (cDockable instanceof SingleCDockable) {
            string2 = ((SingleCDockable)cDockable).getUniqueId();
        }
        boolean bl = this.control.isRootStation(commonDockStation.getStation());
        return new CommonDockStationLayout(string2, bl, string, new DockLayout(string, l));
    }

    @Override
    public CommonDockStation<?, ?> layout(CommonDockStationLayout commonDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        CommonDockStation<?, ?> commonDockStation = this.createStation(commonDockStationLayout.getId());
        if (commonDockStation == null) {
            return null;
        }
        this.registerStation(commonDockStation.getStation(), commonDockStationLayout.isRoot());
        this.setLayout(commonDockStation, commonDockStationLayout, map, placeholderStrategy);
        return commonDockStation;
    }

    @Override
    public CommonDockStation<?, ?> layout(CommonDockStationLayout commonDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        return this.layout(commonDockStationLayout, (Map<Integer, Dockable>)null, placeholderStrategy);
    }

    @Override
    public void setLayout(CommonDockStation<?, ?> commonDockStation, CommonDockStationLayout commonDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        String string = commonDockStation.getConverterID();
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string);
        if (dockFactory == null) {
            return;
        }
        commonDockStationLayout.updateLayout(dockFactory, placeholderStrategy);
        DockLayout<?> dockLayout = commonDockStationLayout.getLayout();
        if (dockLayout == null) {
            return;
        }
        if (map == null) {
            dockFactory.setLayout(commonDockStation, dockLayout.getData(), placeholderStrategy);
        } else {
            dockFactory.setLayout(commonDockStation, dockLayout.getData(), map, placeholderStrategy);
        }
    }

    @Override
    public void setLayout(CommonDockStation<?, ?> commonDockStation, CommonDockStationLayout commonDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        this.setLayout(commonDockStation, commonDockStationLayout, (Map<Integer, Dockable>)null, placeholderStrategy);
    }

    @Override
    public void estimateLocations(CommonDockStationLayout commonDockStationLayout, LocationEstimationMap locationEstimationMap) {
        String string = null;
        if (commonDockStationLayout != null) {
            string = commonDockStationLayout.getFactoryId();
        }
        if (string == null) {
            return;
        }
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string);
        if (dockFactory == null) {
            return;
        }
        commonDockStationLayout.updateLayout(dockFactory, null);
        DockLayout<?> dockLayout = commonDockStationLayout.getLayout();
        if (dockLayout == null) {
            return;
        }
        dockFactory.estimateLocations(dockLayout.getData(), locationEstimationMap);
    }

    @Override
    public CommonDockStationPerspective layoutPerspective(CommonDockStationLayout commonDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        CommonDockStationPerspective commonDockStationPerspective = null;
        if (this.cache != null) {
            commonDockStationPerspective = (CommonDockStationPerspective)this.cache.get(commonDockStationLayout.getId(), commonDockStationLayout.isRoot());
        }
        if (commonDockStationPerspective == null) {
            return null;
        }
        this.layoutPerspective(commonDockStationPerspective, commonDockStationLayout, map);
        return commonDockStationPerspective;
    }

    @Override
    public void layoutPerspective(CommonDockStationPerspective commonDockStationPerspective, CommonDockStationLayout commonDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        CStationPerspective cStationPerspective = commonDockStationPerspective.getElement().asStation();
        cStationPerspective.setRoot(commonDockStationLayout.isRoot());
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(commonDockStationLayout.getFactoryId());
        if (dockFactory == null) {
            return;
        }
        commonDockStationLayout.updateLayout(dockFactory, null);
        DockLayout<?> dockLayout = commonDockStationLayout.getLayout();
        if (dockLayout == null) {
            return;
        }
        dockFactory.layoutPerspective(commonDockStationPerspective, dockLayout.getData(), map);
    }

    @Override
    public CommonDockStationLayout getPerspectiveLayout(CommonDockStationPerspective commonDockStationPerspective, Map<PerspectiveDockable, Integer> map) {
        String string = commonDockStationPerspective.getConverterID();
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string);
        DockFactory<?, ?, ?> dockFactory2 = dockFactory;
        if (dockFactory2 == null) {
            return null;
        }
        Object l = dockFactory2.getPerspectiveLayout(commonDockStationPerspective, map);
        if (l == null) {
            return null;
        }
        CElementPerspective cElementPerspective = commonDockStationPerspective.getElement();
        CStationPerspective cStationPerspective = cElementPerspective.asStation();
        String string2 = cStationPerspective.getUniqueId();
        return new CommonDockStationLayout(string2, cStationPerspective.isRoot(), string, new DockLayout(string, l));
    }

    @Override
    public void write(CommonDockStationLayout commonDockStationLayout, XElement xElement) {
        Object object;
        String string = commonDockStationLayout.getFactoryId();
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string);
        XElement xElement2 = commonDockStationLayout.getLayoutXML();
        if (xElement2 == null) {
            commonDockStationLayout.updateLayout(dockFactory, null);
            object = commonDockStationLayout.getLayout();
            if (object == null) {
                throw new XException("data are null, but data were just updated");
            }
            xElement2 = new XElement("content");
            dockFactory.write(((DockLayout)object).getData(), xElement2);
        }
        if ((object = commonDockStationLayout.getId()) != null) {
            xElement.addElement("id").setString((String)object);
        }
        xElement.addElement("root").setBoolean(commonDockStationLayout.isRoot());
        xElement2.addString("delegate", string);
        xElement.addElement(xElement2);
    }

    @Override
    public CommonDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        String string = null;
        XElement xElement2 = xElement.getElement("id");
        if (xElement2 != null) {
            string = xElement2.getString();
        }
        boolean bl = xElement.getElement("root").getBoolean();
        XElement xElement3 = xElement.getElement("content");
        if (xElement3 == null) {
            throw new XException("missing content element");
        }
        String string2 = xElement3.getString("delegate");
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string2);
        if (dockFactory == null) {
            return new CommonDockStationLayout(string, bl, string2, xElement3);
        }
        Object l = dockFactory.read(xElement3, placeholderStrategy);
        if (l == null) {
            return null;
        }
        return new CommonDockStationLayout(string, bl, string2, new DockLayout(string2, l));
    }

    @Override
    public void write(CommonDockStationLayout commonDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Object object;
        String string = commonDockStationLayout.getFactoryId();
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string);
        byte[] byArray = commonDockStationLayout.getLayoutBytes();
        if (byArray == null) {
            commonDockStationLayout.updateLayout(dockFactory, null);
            object = commonDockStationLayout.getLayout();
            if (object == null) {
                throw new IOException("data are null, but data were just updated");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            dockFactory.write(((DockLayout)object).getData(), new DataOutputStream(byteArrayOutputStream));
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (byArray == null) {
            throw new IOException("unable to write layout, it could not be converted into byte-array format");
        }
        Version.write(dataOutputStream, Version.VERSION_1_1_1);
        object = commonDockStationLayout.getId();
        if (object == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF((String)object);
        }
        dataOutputStream.writeBoolean(commonDockStationLayout.isRoot());
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    @Override
    public CommonDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version.read(dataInputStream).checkCurrent();
        String string = dataInputStream.readBoolean() ? dataInputStream.readUTF() : null;
        boolean bl = dataInputStream.readBoolean();
        String string2 = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.read(byArray, n2, n - n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n2 += n3;
        }
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(string2);
        if (dockFactory == null) {
            return new CommonDockStationLayout(string, bl, string2, byArray);
        }
        Object l = dockFactory.read(new DataInputStream(new ByteArrayInputStream(byArray)), placeholderStrategy);
        if (l == null) {
            return null;
        }
        return new CommonDockStationLayout(string, bl, string2, new DockLayout(string2, l));
    }
}

