/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import java.awt.Rectangle;

public class CLockedResizeLayoutManager
extends LockedResizeLayoutManager<RequestDimension> {
    private CControl control;

    public CLockedResizeLayoutManager() {
    }

    public CLockedResizeLayoutManager(CControl cControl) {
        this.control = cControl;
    }

    public CLockedResizeLayoutManager(SplitLayoutManager splitLayoutManager) {
        super(splitLayoutManager);
    }

    public void setControl(CControl cControl) {
        this.control = cControl;
    }

    @Override
    public ConflictResolver<RequestDimension> getConflictResolver() {
        if (this.control != null) {
            return this.control.getProperty(CControl.RESIZE_LOCK_CONFLICT_RESOLVER);
        }
        return super.getConflictResolver();
    }

    @Override
    public ResizeRequest getRequest(RequestDimension requestDimension, Leaf leaf) {
        if (requestDimension != null) {
            Rectangle rectangle = leaf.getCurrentBounds();
            double d = (double)requestDimension.getWidth() + 0.001 - (double)rectangle.width;
            double d2 = (double)requestDimension.getHeight() + 0.001 - (double)rectangle.height;
            Root root = leaf.getRoot();
            return new ResizeRequest(d /= root.getWidthFactor(), d2 /= root.getHeightFactor(), requestDimension.isWidthSet() ? 1 : -1, requestDimension.isHeightSet() ? 1 : -1);
        }
        return null;
    }

    @Override
    public RequestDimension prepareResize(Leaf leaf) {
        double d;
        boolean bl = this.isLockedHorizontally(leaf.getDockable());
        boolean bl2 = this.isLockedVertically(leaf.getDockable());
        if (!bl && !bl2) {
            return null;
        }
        RequestDimension requestDimension = new RequestDimension();
        Rectangle rectangle = leaf.getCurrentBounds();
        if (bl && (d = leaf.getWidth()) > 0.0) {
            requestDimension.setWidth(rectangle.width);
        }
        if (bl2 && (d = leaf.getHeight()) > 0.0) {
            requestDimension.setHeight(rectangle.height);
        }
        return requestDimension;
    }

    private boolean isLockedVertically(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            return cDockable.isResizeLockedVertically();
        }
        if (dockable != null && dockable.asDockStation() instanceof StackDockStation) {
            StackDockStation stackDockStation = (StackDockStation)dockable.asDockStation();
            int n = 0;
            int n2 = stackDockStation.getDockableCount();
            while (n < n2) {
                if (this.isLockedVertically(stackDockStation.getDockable(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean isLockedHorizontally(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            return cDockable.isResizeLockedHorizontally();
        }
        if (dockable != null && dockable.asDockStation() instanceof StackDockStation) {
            StackDockStation stackDockStation = (StackDockStation)dockable.asDockStation();
            int n = 0;
            int n2 = stackDockStation.getDockableCount();
            while (n < n2) {
                if (this.isLockedHorizontally(stackDockStation.getDockable(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

