/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.flap.AbstractFlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;

public class CFlapLayoutManager
extends AbstractFlapLayoutManager
implements FlapLayoutManager {
    private DockStationListener stationListener = new DockStationAdapter(){

        @Override
        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(CFlapLayoutManager.this.propertyListener);
            }
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(CFlapLayoutManager.this.propertyListener);
            } else {
                CFlapLayoutManager.this.holds.remove(dockable);
                CFlapLayoutManager.this.sizes.remove(dockable);
            }
        }
    };
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void stickyChanged(CDockable cDockable) {
            DockStation dockStation = cDockable.intern().getDockParent();
            if (dockStation instanceof FlapDockStation) {
                ((FlapDockStation)dockStation).updateHold(cDockable.intern());
            }
        }

        @Override
        public void minimizeSizeChanged(CDockable cDockable) {
            DockStation dockStation = cDockable.intern().getDockParent();
            if (dockStation instanceof FlapDockStation) {
                ((FlapDockStation)dockStation).updateWindowSize(cDockable.intern());
            }
        }

        @Override
        public void stickySwitchableChanged(CDockable cDockable) {
            DockStation dockStation = cDockable.intern().getDockParent();
            if (dockStation instanceof FlapDockStation) {
                CFlapLayoutManager.this.fireHoldSwitchableChanged((FlapDockStation)dockStation, cDockable.intern());
            }
        }
    };
    private Map<Dockable, Boolean> holds = new HashMap<Dockable, Boolean>();
    private Map<Dockable, Integer> sizes = new HashMap<Dockable, Integer>();

    @Override
    public void install(FlapDockStation flapDockStation) {
        flapDockStation.addDockStationListener(this.stationListener);
        int n = 0;
        int n2 = flapDockStation.getDockableCount();
        while (n < n2) {
            this.stationListener.dockableAdded(flapDockStation, flapDockStation.getDockable(n));
            ++n;
        }
    }

    @Override
    public void uninstall(FlapDockStation flapDockStation) {
        flapDockStation.removeDockStationListener(this.stationListener);
        int n = 0;
        int n2 = flapDockStation.getDockableCount();
        while (n < n2) {
            this.stationListener.dockableRemoved(flapDockStation, flapDockStation.getDockable(n));
            ++n;
        }
    }

    @Override
    public int getSize(FlapDockStation flapDockStation, Dockable dockable) {
        FlapDockStation.Direction direction = flapDockStation.getDirection();
        int n = this.getMaxSize(dockable, direction == FlapDockStation.Direction.NORTH || direction == FlapDockStation.Direction.SOUTH);
        if (n < 0) {
            Integer n2 = this.sizes.get(dockable);
            if (n2 != null) {
                return n2;
            }
            return flapDockStation.getDefaultWindowSize();
        }
        return n;
    }

    private int getMaxSize(Dockable dockable, boolean bl) {
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            Dimension dimension = cDockable.getMinimizedSize();
            if (bl) {
                return dimension.height;
            }
            return dimension.width;
        }
        if (dockable instanceof StackDockStation) {
            StackDockStation stackDockStation = (StackDockStation)dockable;
            int n = -1;
            int n2 = 0;
            int n3 = stackDockStation.getDockableCount();
            while (n2 < n3) {
                n = Math.max(n, this.getMaxSize(stackDockStation.getDockable(n2), bl));
                ++n2;
            }
            return n;
        }
        return -1;
    }

    @Override
    public void setSize(FlapDockStation flapDockStation, Dockable dockable, int n) {
        if (dockable instanceof CommonDockable) {
            FlapDockStation.Direction direction = flapDockStation.getDirection();
            boolean bl = direction == FlapDockStation.Direction.NORTH || direction == FlapDockStation.Direction.SOUTH;
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            Dimension dimension = cDockable.getMinimizedSize();
            if (bl) {
                cDockable.setMinimizedSize(new Dimension(dimension.width, n));
            } else {
                cDockable.setMinimizedSize(new Dimension(n, dimension.height));
            }
        } else {
            this.sizes.put(dockable, n);
        }
    }

    @Override
    public boolean isHold(FlapDockStation flapDockStation, Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().isSticky();
        }
        return Boolean.TRUE.equals(this.holds.get(dockable));
    }

    @Override
    public void setHold(FlapDockStation flapDockStation, Dockable dockable, boolean bl) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().setSticky(bl);
        } else {
            this.holds.put(dockable, bl);
        }
    }

    @Override
    public boolean isHoldSwitchable(FlapDockStation flapDockStation, Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().isStickySwitchable();
        }
        return true;
    }
}

