/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.flap.layer.FlapOverrideDropLayer;
import bibliothek.gui.dock.station.flap.layer.FlapSideDropLayer;
import bibliothek.gui.dock.station.flap.layer.WindowDropLayer;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.title.DockTitleRequest;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class CFlapDockStation
extends FlapDockStation
implements CommonDockStation<FlapDockStation, CFlapDockStation> {
    private CommonStationDelegate<CFlapDockStation> delegate;
    private Component expansion;
    private CHoldActionHandler actionHandler = new CHoldActionHandler();

    public CFlapDockStation(Component component, CommonStationDelegate<CFlapDockStation> commonStationDelegate) {
        this.expansion = component;
        this.delegate = commonStationDelegate;
        this.addDockStationListener(new HoldActionHandler());
    }

    @Override
    public String getFactoryID() {
        return "CommonDockStationFactory";
    }

    @Override
    public String getConverterID() {
        return super.getFactoryID();
    }

    public CDockable getDockable() {
        return this.delegate.getDockable();
    }

    public DockActionSource[] getSources() {
        return this.delegate.getSources();
    }

    @Override
    public CStation<CFlapDockStation> getStation() {
        return this.delegate.getStation();
    }

    @Override
    public FlapDockStation getDockStation() {
        return this;
    }

    @Override
    public CFlapDockStation asDockStation() {
        return this;
    }

    @Override
    public CommonDockable asDockable() {
        return null;
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        DockStationDropLayer[] dockStationDropLayerArray = this.getDockableCount() == 0 ? new DockStationDropLayer[4] : new DockStationDropLayer[]{new DefaultDropLayer(this){

            @Override
            public Component getComponent() {
                return CFlapDockStation.this.getComponent();
            }
        }, new FlapOverrideDropLayer(this){

            @Override
            public Component getComponent() {
                return CFlapDockStation.this.getComponent();
            }
        }, new WindowDropLayer(this)};
        if (this.getDockableCount() == 0) {
            dockStationDropLayerArray[3] = new FlapSideDropLayer(this){

                @Override
                public Component getComponent() {
                    return CFlapDockStation.this.getComponent();
                }
            };
        }
        return dockStationDropLayerArray;
    }

    @Override
    protected FlapDockStation.DockableHandle createHandle(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            FlapDockStation.DockableHandle dockableHandle = new FlapDockStation.DockableHandle(dockable, true);
            this.update(dockableHandle, ((CommonDockable)dockable).getDockable());
            return dockableHandle;
        }
        return super.createHandle(dockable);
    }

    private void update(FlapDockStation.DockableHandle dockableHandle, CDockable cDockable) {
        CAction cAction = cDockable.getAction("cdockable.hold");
        if (cAction == null) {
            dockableHandle.resetHoldAction();
        } else {
            dockableHandle.getActions().setHoldAction(cAction.intern());
        }
    }

    @Override
    public Rectangle getExpansionBounds() {
        if (this.expansion == null) {
            return super.getExpansionBounds();
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(this.getComponent(), point, this.expansion);
        return new Rectangle(-point.x, -point.y, this.expansion.getWidth(), this.expansion.getHeight());
    }

    @Override
    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
        if (this.delegate.isTitleDisplayed(dockTitleRequest.getVersion())) {
            super.requestDockTitle(dockTitleRequest);
        } else {
            dockTitleRequest.answer(null);
        }
    }

    private class CHoldActionHandler
    extends CDockableAdapter {
        private CHoldActionHandler() {
        }

        @Override
        public void actionChanged(CDockable cDockable, String string, CAction cAction, CAction cAction2) {
            FlapDockStation.DockableHandle dockableHandle;
            if (string.equals("cdockable.hold") && (dockableHandle = CFlapDockStation.this.getHandle(cDockable.intern())) != null) {
                CFlapDockStation.this.update(dockableHandle, cDockable);
            }
        }
    }

    private class HoldActionHandler
    extends DockStationAdapter {
        private HoldActionHandler() {
        }

        @Override
        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(CFlapDockStation.this.actionHandler);
            }
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(CFlapDockStation.this.actionHandler);
            }
        }
    }
}

