/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.layout;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableLayout;
import bibliothek.gui.dock.common.intern.layout.ReplacementDockFactory;
import bibliothek.gui.dock.frontend.DefaultLayoutChangeStrategy;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CLayoutChangeStrategy
extends DefaultLayoutChangeStrategy {
    private CControl control;
    private static final String REPLACEMENT_FACTORY_ID = PredefinedDockSituation.convertFactoryID("dock.common.replacement_factory");

    public CLayoutChangeStrategy(CControl cControl) {
        this.control = cControl;
    }

    @Override
    protected PredefinedDockSituation createSituation(DockFrontendInternals dockFrontendInternals, boolean bl, boolean bl2) {
        PredefinedDockSituation predefinedDockSituation = super.createSituation(dockFrontendInternals, bl, bl2);
        if (bl2) {
            predefinedDockSituation.add(new ReplacementDockFactory());
        }
        predefinedDockSituation.setPlaceholderStrategy(this.control.getProperty(PlaceholderStrategy.PLACEHOLDER_STRATEGY));
        return predefinedDockSituation;
    }

    @Override
    protected boolean shouldPredefine(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable() instanceof SingleCDockable;
        }
        return true;
    }

    @Override
    protected Set<Dockable> estimateVisible(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            DockFrontend.DockInfo[] dockInfoArray = dockFrontendInternals.getDockables();
            int n = dockInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockFrontend.DockInfo object2 = dockInfoArray[n2];
                Dockable dockable = object2.getDockable();
                if (dockable != null) {
                    hashSet.add(dockable);
                }
                ++n2;
            }
            for (MultipleCDockable multipleCDockable : this.control.getRegister().getMultipleDockables()) {
                hashSet.add(multipleCDockable.intern());
            }
            PredefinedDockSituation predefinedDockSituation = (PredefinedDockSituation)dockSituation;
            Set set = predefinedDockSituation.listVisible(hashSet, dockLayoutComposition);
            this.findVisible(set, dockLayoutComposition);
            return set;
        }
        return null;
    }

    @Override
    protected Collection<Dockable> getClosingDockables(DockFrontendInternals dockFrontendInternals, Set<Dockable> set) {
        Collection<Dockable> collection = super.getClosingDockables(dockFrontendInternals, set);
        for (MultipleCDockable multipleCDockable : this.control.getRegister().getMultipleDockables()) {
            CommonDockable commonDockable = multipleCDockable.intern();
            if (set.contains(commonDockable)) continue;
            collection.add(commonDockable);
        }
        return collection;
    }

    private void findVisible(Set<Dockable> set, DockLayoutComposition dockLayoutComposition) {
        DockLayout<?> object2;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo != null && (object2 = dockLayoutInfo.getDataLayout()) != null && REPLACEMENT_FACTORY_ID.equals(object2.getFactoryID())) {
            CDockable cDockable = (CDockable)object2.getData();
            set.add(cDockable.intern());
        }
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            this.findVisible(set, dockLayoutComposition2);
        }
    }

    protected DockLayoutComposition replaceMultipleDockables(DockFrontendInternals dockFrontendInternals, CSettingAccess cSettingAccess, DockLayoutComposition dockLayoutComposition) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (dockLayoutComposition == null) {
            return null;
        }
        Object object5 = dockLayoutComposition.getLayout();
        if (object5 != null && (object4 = ((DockLayoutInfo)object5).getDataLayout()) != null && (object3 = cSettingAccess.findMatch((DockLayout<?>)object4)) != null) {
            object2 = new DockLayout<Object>(REPLACEMENT_FACTORY_ID, object3);
            object = new DockLayoutInfo((DockLayout<?>)object2);
            ((DockLayoutInfo)object).setLocation(((DockLayoutInfo)object5).getLocation());
            object5 = object;
        }
        object4 = dockLayoutComposition.getChildren();
        object3 = new ArrayList(object4.size());
        object = object4.iterator();
        while (object.hasNext()) {
            object2 = (DockLayoutComposition)object.next();
            object3.add(this.replaceMultipleDockables(dockFrontendInternals, cSettingAccess, (DockLayoutComposition)object2));
        }
        return new DockLayoutComposition((DockLayoutInfo)object5, dockLayoutComposition.getAdjacent(), (List<DockLayoutComposition>)object3, dockLayoutComposition.isIgnoreChildren());
    }

    @Override
    protected DefaultLayoutChangeStrategy.SettingAccess createAccess(DockFrontendInternals dockFrontendInternals, Setting setting) {
        return new CSettingAccess(dockFrontendInternals, setting);
    }

    protected class CSettingAccess
    extends DefaultLayoutChangeStrategy.SettingAccess {
        private DockFrontendInternals frontend;
        private Map<String, DockLayoutComposition> modifiedRoots;
        private Map<String, MultipleCDockableFactory<?, ?>> factories;
        private Map<String, List<MultipleCDockable>> remainingDockables;

        public CSettingAccess(DockFrontendInternals dockFrontendInternals, Setting setting) {
            super(CLayoutChangeStrategy.this, setting);
            this.modifiedRoots = new HashMap<String, DockLayoutComposition>();
            this.frontend = dockFrontendInternals;
            Map<String, MultipleCDockableFactory<?, ?>> map = CLayoutChangeStrategy.this.control.getRegister().getFactories();
            this.factories = new HashMap();
            for (Map.Entry<String, MultipleCDockableFactory<?, ?>> object : map.entrySet()) {
                this.factories.put(PredefinedDockSituation.convertFactoryID(object.getKey()), object.getValue());
            }
            this.remainingDockables = new HashMap<String, List<MultipleCDockable>>();
            block1: for (MultipleCDockable multipleCDockable : CLayoutChangeStrategy.this.control.getRegister().getMultipleDockables()) {
                for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : map.entrySet()) {
                    if (entry.getValue() != multipleCDockable.getFactory()) continue;
                    String string = PredefinedDockSituation.convertFactoryID(entry.getKey());
                    List<MultipleCDockable> list = this.remainingDockables.get(string);
                    if (list == null) {
                        list = new LinkedList<MultipleCDockable>();
                        this.remainingDockables.put(string, list);
                    }
                    list.add(multipleCDockable);
                    continue block1;
                }
            }
        }

        public MultipleCDockable findMatch(DockLayout<?> dockLayout) {
            String string = dockLayout.getFactoryID();
            Object obj = dockLayout.getData();
            if (obj instanceof CommonMultipleDockableLayout) {
                List<MultipleCDockable> list;
                MultipleCDockableLayout multipleCDockableLayout = ((CommonMultipleDockableLayout)obj).getLayout();
                MultipleCDockableFactory<?, ?> multipleCDockableFactory = this.factories.get(string);
                if (multipleCDockableFactory != null && (list = this.remainingDockables.get(string)) != null) {
                    Iterator<MultipleCDockable> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        MultipleCDockable multipleCDockable = iterator.next();
                        if (!multipleCDockableFactory.match(multipleCDockable, multipleCDockableLayout)) continue;
                        iterator.remove();
                        if (list.isEmpty()) {
                            this.remainingDockables.remove(string);
                        }
                        return multipleCDockable;
                    }
                }
            }
            return null;
        }

        @Override
        public DockLayoutComposition getRoot(String string) {
            DockLayoutComposition dockLayoutComposition = this.modifiedRoots.get(string);
            if (dockLayoutComposition == null) {
                dockLayoutComposition = CLayoutChangeStrategy.this.replaceMultipleDockables(this.frontend, this, super.getRoot(string));
                this.modifiedRoots.put(string, dockLayoutComposition);
            }
            return dockLayoutComposition;
        }
    }
}

