/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.layout;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.common.perspective.CControlPerspective;
import bibliothek.gui.dock.frontend.SettingsBlop;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CControlPerspectiveResource
implements ApplicationResource {
    private CControlPerspective control;
    private SettingsBlop settings = new SettingsBlop();

    public CControlPerspectiveResource(CControlPerspective cControlPerspective) {
        if (cControlPerspective == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = cControlPerspective;
    }

    public SettingsBlop getSettings() {
        return this.settings;
    }

    public void setSettings(SettingsBlop settingsBlop) {
        this.settings = settingsBlop;
    }

    private DockFrontend getFrontend() {
        return this.control.getControl().intern();
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        this.getFrontend().writeBlop(this.settings, dataOutputStream);
    }

    @Override
    public void read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        if (Version.VERSION_1_1_1.compareTo(version) > 0) {
            throw new IOException("The perspective API cannot read files which were written before version 1.1.1");
        }
        version.checkCurrent();
        this.settings = this.getFrontend().readBlop(dataInputStream);
    }

    @Override
    public void writeXML(XElement xElement) {
        this.getFrontend().writeBlopXML(this.settings, xElement.addElement("frontend"));
    }

    @Override
    public void readXML(XElement xElement) {
        this.settings = this.getFrontend().readBlopXML(xElement.getElement("frontend"));
    }
}

