/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class TitleColorTransmitter
extends ColorTransmitter {
    private ColorManager manager;
    private String[] keys;

    public TitleColorTransmitter(ColorManager colorManager, String ... stringArray) {
        super(stringArray);
        this.keys = stringArray;
        this.manager = colorManager;
    }

    protected abstract Color convert(Color var1, String var2);

    protected abstract Color convertFocused(Color var1, String var2);

    protected abstract boolean isForeground(String var1);

    protected abstract boolean isFocused(String var1);

    public String[] getKeys() {
        return this.keys;
    }

    @Override
    protected Color get(Color color, String string, DockColor dockColor) {
        CDockable cDockable = this.getDockable(dockColor);
        if (cDockable != null) {
            return this.get(color, string, cDockable);
        }
        return color;
    }

    @Override
    protected CDockable getDockable(DockColor dockColor) {
        Dockable dockable = ((TitleColor)dockColor).getTitle().getDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }

    @Override
    protected Color get(Color color, String string, CDockable cDockable) {
        Color color2 = null;
        ColorMap colorMap = cDockable.getColors();
        boolean bl = this.isForeground(string);
        boolean bl2 = this.isFocused(string);
        if (bl) {
            if (bl2) {
                color2 = colorMap.getColor("title.foreground.focused");
            }
            if (color2 == null) {
                color2 = colorMap.getColor("title.foreground");
            }
        }
        if (color2 == null) {
            if (bl2 && (color2 = colorMap.getColor("title.background.focused")) != null) {
                color2 = this.convertFocused(color2, string);
            }
            if (color2 == null && (color2 = colorMap.getColor("title.background")) != null) {
                color2 = this.convert(color2, string);
            }
        }
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    @Override
    protected void update(CDockable cDockable, String string, Color color) {
        boolean bl;
        boolean bl2 = bl = "title.background".equals(string) || "title.background.focused".equals(string) || "title.foreground".equals(string) || "title.foreground.focused".equals(string);
        if (bl) {
            String[] stringArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                this.set(string2, this.get((Color)this.manager.get(string2), string2, cDockable), cDockable);
                ++n2;
            }
        }
    }
}

