/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class MinimizedButtonColorTransmitter
extends ColorTransmitter {
    private ColorManager manager;
    private String[] keys;

    public MinimizedButtonColorTransmitter(ColorManager colorManager, String ... stringArray) {
        super(stringArray);
        this.keys = stringArray;
        this.manager = colorManager;
    }

    protected abstract Color convert(Color var1, String var2);

    protected abstract Color convertFocused(Color var1, String var2);

    protected abstract Color convertSelected(Color var1, String var2);

    protected abstract boolean isForeground(String var1);

    protected abstract boolean isFocused(String var1);

    protected abstract boolean isSelected(String var1);

    public String[] getKeys() {
        return this.keys;
    }

    @Override
    protected Color get(Color color, String string, DockColor dockColor) {
        CDockable cDockable = this.getDockable(dockColor);
        if (cDockable != null) {
            return this.get(color, string, cDockable);
        }
        return color;
    }

    @Override
    protected CDockable getDockable(DockColor dockColor) {
        Dockable dockable = ((TitleColor)dockColor).getTitle().getDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }

    @Override
    protected Color get(Color color, String string, CDockable cDockable) {
        boolean bl;
        Color color2 = null;
        ColorMap colorMap = cDockable.getColors();
        boolean bl2 = this.isForeground(string);
        boolean bl3 = this.isFocused(string);
        boolean bl4 = bl = bl3 || this.isSelected(string);
        if (bl2) {
            if (bl3) {
                color2 = colorMap.getColor("minimized.foreground.focused");
            }
            if (color2 == null && bl) {
                color2 = colorMap.getColor("minimized.foreground.selected");
            }
            if (color2 == null) {
                color2 = colorMap.getColor("minimized.foreground");
            }
        }
        if (color2 == null) {
            if (bl3 && (color2 = colorMap.getColor("minimized.background.focused")) != null) {
                color2 = this.convertFocused(color2, string);
            }
            if (color2 == null && bl && (color2 = colorMap.getColor("minimized.background.selected")) != null) {
                color2 = this.convertSelected(color2, string);
            }
            if (color2 == null && (color2 = colorMap.getColor("minimized.background")) != null) {
                color2 = this.convert(color2, string);
            }
        }
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    @Override
    protected void update(CDockable cDockable, String string, Color color) {
        boolean bl;
        boolean bl2 = bl = "minimized.background".equals(string) || "minimized.background.focused".equals(string) || "minimized.background.selected".equals(string) || "minimized.foreground".equals(string) || "minimized.foreground.focused".equals(string) || "minimized.foreground.selected".equals(string);
        if (bl) {
            String[] stringArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                this.set(string2, this.get((Color)this.manager.get(string2), string2, cDockable), cDockable);
                ++n2;
            }
        }
    }
}

