/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.event.ColorMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.ui.UITransmitter;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class ColorTransmitter
extends UITransmitter<Color, DockColor>
implements ColorBridge {
    private Listener listener = new Listener();

    public ColorTransmitter(String ... stringArray) {
        super(stringArray);
    }

    protected Color getFirstNonNull(ColorMap colorMap, String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Color color = colorMap.getColor(string);
            if (color != null) {
                return color;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void connect(CDockable cDockable) {
        cDockable.getColors().addListener(this.listener);
    }

    @Override
    protected void disconnect(CDockable cDockable) {
        cDockable.getColors().removeListener(this.listener);
    }

    private class Listener
    implements ColorMapListener {
        private Listener() {
        }

        @Override
        public void colorChanged(ColorMap colorMap, String string, Color color) {
            ColorTransmitter.this.update(colorMap.getDockable(), string, color);
        }
    }
}

