/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CloseActionSource
extends AbstractDockActionSource {
    private CDockable dockable;
    private CControlAccess control;
    private DockAction action;

    public CloseActionSource(CDockable cDockable) {
        this.dockable = cDockable;
        cDockable.addCDockablePropertyListener(new CDockableAdapter(){

            @Override
            public void actionChanged(CDockable cDockable, String string, CAction cAction, CAction cAction2) {
                CloseActionSource.this.update();
            }

            @Override
            public void closeableChanged(CDockable cDockable) {
                CloseActionSource.this.update();
            }
        });
    }

    public void setControl(CControlAccess cControlAccess) {
        this.control = cControlAccess;
        this.update();
    }

    protected void update() {
        DockAction dockAction = null;
        if (this.control != null && this.dockable.isCloseable()) {
            CAction cAction = this.dockable.getAction("cdockable.close");
            dockAction = cAction != null ? cAction.intern() : this.control.createCloseAction(this.dockable);
        }
        if (dockAction != this.action) {
            if (this.action != null) {
                this.action = null;
                this.fireRemoved(0, 0);
            }
            if (dockAction != null) {
                this.action = dockAction;
                this.fireAdded(0, 0);
            }
        }
    }

    @Override
    public DockAction getDockAction(int n) {
        if (n == 0 && this.action != null) {
            return this.action;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    public int getDockActionCount() {
        if (this.action == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public LocationHint getLocationHint() {
        return new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL);
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private DockAction action;
            {
                this.action = CloseActionSource.this.action;
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public DockAction next() {
                if (this.action == null) {
                    throw new NoSuchElementException();
                }
                DockAction dockAction = this.action;
                this.action = null;
                return dockAction;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

