/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.core.CommonSimpleButtonAction;
import bibliothek.gui.dock.common.action.util.CActionText;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CDropDownItem;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CExtendedModeAction
extends CDropDownItem<Action> {
    private ExtendedMode mode;
    private DockActionIcon iconListener;
    private PropertyValue<KeyStroke> stroke;
    private CControl control;
    private CActionText text;
    private CActionText tooltip;
    private Action action;
    private DockController controller;

    protected CExtendedModeAction(CControl cControl, ExtendedMode extendedMode, String string, String string2, String string3, PropertyKey<KeyStroke> propertyKey) {
        super(null);
        this.init(cControl, extendedMode, string, string2, string3, propertyKey);
    }

    protected CExtendedModeAction() {
        super(null);
    }

    protected void init(CControl cControl, ExtendedMode extendedMode, String string, String string2, String string3, PropertyKey<KeyStroke> propertyKey) {
        this.action = this.createAction();
        this.init(this.action);
        if (cControl == null) {
            throw new NullPointerException("control is null");
        }
        if (extendedMode == null) {
            throw new NullPointerException("mode is null");
        }
        if (string == null) {
            throw new NullPointerException("iconKey is null");
        }
        if (propertyKey == null) {
            throw new NullPointerException("gotoStroke is null");
        }
        this.control = cControl;
        this.mode = extendedMode;
        this.iconListener = new DockActionIcon(string, this.action){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                CExtendedModeAction.this.setIcon(icon2);
            }
        };
        this.stroke = new PropertyValue<KeyStroke>(propertyKey){

            @Override
            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                CExtendedModeAction.this.setAccelerator(keyStroke2);
            }
        };
        this.text = new CActionText(string2, this){

            @Override
            protected void changed(String string, String string2) {
                CExtendedModeAction.this.setText(string2);
            }
        };
        this.tooltip = new CActionText(string3, this){

            @Override
            protected void changed(String string, String string2) {
                CExtendedModeAction.this.setTooltip(string2);
            }
        };
    }

    protected void setController(DockController dockController) {
        this.controller = dockController;
        this.stroke.setProperties(dockController);
        this.iconListener.setController(dockController);
        this.text.setController(dockController);
        this.tooltip.setController(dockController);
    }

    protected DockController getController() {
        return this.controller;
    }

    protected boolean checkTrigger(KeyEvent keyEvent) {
        return true;
    }

    public void action(CDockable cDockable) {
        cDockable.setExtendedMode(this.mode);
    }

    protected Action createAction() {
        return new Action();
    }

    public class Action
    extends CommonSimpleButtonAction {
        private int count;

        public Action() {
            super(CExtendedModeAction.this);
            this.count = 0;
        }

        @Override
        protected boolean trigger(KeyEvent keyEvent, Dockable dockable) {
            if (CExtendedModeAction.this.checkTrigger(keyEvent)) {
                return super.trigger(keyEvent, dockable);
            }
            return false;
        }

        @Override
        public void action(Dockable dockable) {
            while (dockable != null) {
                if (dockable instanceof CommonDockable) {
                    CExtendedModeAction.this.action(((CommonDockable)dockable).getDockable());
                    return;
                }
                DockStation dockStation = dockable.asDockStation();
                if (dockStation == null) {
                    return;
                }
                dockable = dockStation.getFrontDockable();
            }
        }

        @Override
        protected void bound(Dockable dockable) {
            super.bound(dockable);
            if (this.count == 0) {
                CExtendedModeAction.this.setController(CExtendedModeAction.this.control.intern().getController());
            }
            ++this.count;
        }

        @Override
        protected void unbound(Dockable dockable) {
            super.unbound(dockable);
            --this.count;
            if (this.count == 0) {
                CExtendedModeAction.this.setController(null);
            }
        }
    }
}

