/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class RootStationAdjacentFactory
implements AdjacentDockFactory<Path> {
    public static final String FACTORY_ID = "dock.RootStationAdjacentFactory";

    @Override
    public boolean interested(DockElement dockElement) {
        return dockElement instanceof CommonDockStation;
    }

    @Override
    public boolean interested(PerspectiveElement perspectiveElement) {
        if (perspectiveElement instanceof CommonElementPerspective) {
            CStationPerspective cStationPerspective = ((CommonElementPerspective)perspectiveElement).getElement().asStation();
            return cStationPerspective != null;
        }
        return false;
    }

    @Override
    public String getID() {
        return FACTORY_ID;
    }

    @Override
    public Path getLayout(DockElement dockElement, Map<Dockable, Integer> map) {
        return ((CommonDockStation)dockElement).getStation().getTypeId();
    }

    @Override
    public Path getPerspectiveLayout(PerspectiveElement perspectiveElement, Map<PerspectiveDockable, Integer> map) {
        CStationPerspective cStationPerspective = ((CommonElementPerspective)perspectiveElement).getElement().asStation();
        return cStationPerspective.getTypeId();
    }

    @Override
    public Path read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        byte by = dataInputStream.readByte();
        if (by != 0) {
            throw new IOException("unknown version: " + by);
        }
        if (dataInputStream.readBoolean()) {
            return new Path(dataInputStream.readUTF());
        }
        return null;
    }

    @Override
    public Path read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2 = xElement.getElement("type");
        if (xElement2 == null) {
            return null;
        }
        return new Path(xElement2.getString());
    }

    @Override
    public void setLayout(DockElement dockElement, Path path, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        if (!(dockElement instanceof CommonDockStation)) {
            throw new IllegalArgumentException("expected the 'element' to be a '" + CommonDockStation.class.getSimpleName() + "', but instead it was a '" + dockElement.getClass().getName() + "'.\n" + "The reason for this exception may be be:\n - a DockElement that was registered with the wrong unique identifier\n - the type of a DockElement was changed\n - a SingleCDockableFactory creating the wrong type of items.\n" + "Type and toString of 'element': " + dockElement.getClass().getName() + ",\n" + dockElement);
        }
        CStation cStation = ((CommonDockStation)dockElement).getStation();
        Path path2 = cStation.getTypeId();
        if (path2 != null && !path2.equals(path)) {
            throw new IllegalArgumentException("expected the 'element' to have type id '" + path + "', but instead it was '" + path2 + "'.\n" + "The reason for this exception may be be:\n - a DockElement that was registered with the wrong unique identifier\n - the type of a DockElement was changed\n - a SingleCDockableFactory creating the wrong type of items.\n" + "Type and toString of 'element': " + cStation.getClass().getName() + ",\n" + cStation);
        }
    }

    @Override
    public void setLayout(DockElement dockElement, Path path, PlaceholderStrategy placeholderStrategy) {
        this.setLayout(dockElement, path, (Map<Integer, Dockable>)null, placeholderStrategy);
    }

    @Override
    public void write(Path path, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(0);
        if (path == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(path.toString());
        }
    }

    @Override
    public void write(Path path, XElement xElement) {
        if (path != null) {
            xElement.addElement("type").setString(path.toString());
        }
    }
}

