/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CActionSource;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;

public class DefaultCommonDockable
extends DefaultDockable
implements CommonDockable {
    private CDockable dockable;
    private CActionSource actions;
    private DockActionSource[] sources;

    public DefaultCommonDockable(CDockable cDockable, DockActionSource ... dockActionSourceArray) {
        this.dockable = cDockable;
        this.sources = dockActionSourceArray;
        this.actions = new CActionSource(new LocationHint(LocationHint.DOCKABLE, LocationHint.LEFT));
        this.setActionOffers(this.actions);
        cDockable.addCDockablePropertyListener(new CDockableAdapter(){

            @Override
            public void titleShownChanged(CDockable cDockable) {
                DefaultCommonDockable.this.fireTitleExchanged();
            }
        });
        this.setFactoryID("ccontrol backup factory id");
    }

    public CActionSource getActions() {
        return this.actions;
    }

    @Override
    public CDockable getDockable() {
        return this.dockable;
    }

    @Override
    public CommonDockable asDockable() {
        return this;
    }

    @Override
    public CommonDockStation<?, ?> asDockStation() {
        return null;
    }

    @Override
    public CStation<?> getStation() {
        return null;
    }

    @Override
    public DockActionSource[] getSources() {
        return this.sources;
    }

    @Override
    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
        if (this.dockable.isTitleShown()) {
            super.requestDockTitle(dockTitleRequest);
        } else {
            boolean bl;
            DockTitleVersion dockTitleVersion = dockTitleRequest.getVersion();
            boolean bl2 = bl = dockTitleVersion.getID().equals("split") || dockTitleVersion.getID().equals("stack") || dockTitleVersion.getID().equals("flap window");
            if (bl) {
                dockTitleRequest.answer(null);
            } else {
                super.requestDockTitle(dockTitleRequest);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[dockable=" + this.dockable + "]";
    }
}

