/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.CStationContainerListener;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.frontend.FrontendEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultCControlRegister
implements MutableCControlRegister {
    private CControl control;
    private CContentArea content;
    private boolean settingDefaultStations = false;
    private List<CStationContainer> containers = new ArrayList<CStationContainer>();
    private CommonSingleDockableFactory backupFactory;
    private Map<String, CommonMultipleDockableFactory> factories = new HashMap<String, CommonMultipleDockableFactory>();
    private List<CDockable> dockables = new ArrayList<CDockable>();
    private List<SingleCDockable> singleDockables = new ArrayList<SingleCDockable>();
    private List<MultipleCDockable> multiDockables = new ArrayList<MultipleCDockable>();
    private List<CStation<?>> stations = new ArrayList();
    private CStationContainerListener containerListener = new CStationContainerListener(){

        @Override
        public void removed(CStationContainer cStationContainer, CStation<?> cStation) {
            DefaultCControlRegister.this.control.removeStation(cStation);
        }

        @Override
        public void added(CStationContainer cStationContainer, CStation<?> cStation) {
            try {
                DefaultCControlRegister.this.settingDefaultStations = cStationContainer == DefaultCControlRegister.this.content;
                DefaultCControlRegister.this.control.addStation(cStation, true);
            }
            finally {
                DefaultCControlRegister.this.settingDefaultStations = false;
            }
        }
    };

    public DefaultCControlRegister(CControl cControl) {
        this.control = cControl;
        this.backupFactory = new CommonSingleDockableFactory(cControl);
    }

    @Override
    public CControl getControl() {
        return this.control;
    }

    @Override
    public List<CDockable> getDockables() {
        return Collections.unmodifiableList(this.dockables);
    }

    @Override
    public List<MultipleCDockable> getMultipleDockables() {
        return Collections.unmodifiableList(this.multiDockables);
    }

    @Override
    public List<SingleCDockable> getSingleDockables() {
        return Collections.unmodifiableList(this.singleDockables);
    }

    @Override
    public List<CStation<?>> getStations() {
        return Collections.unmodifiableList(this.stations);
    }

    @Override
    public List<CStationContainer> getStationContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    @Override
    public CStationContainer getContainer(CStation<?> cStation) {
        for (CStationContainer cStationContainer : this.getStationContainers()) {
            int n = 0;
            int n2 = cStationContainer.getStationCount();
            while (n < n2) {
                if (cStationContainer.getStation(n) == cStation) {
                    return cStationContainer;
                }
                ++n;
            }
        }
        return null;
    }

    @Override
    public void addStationContainer(CStationContainer cStationContainer) {
        if (cStationContainer == null) {
            throw new NullPointerException("container is null");
        }
        if (this.containers.contains(cStationContainer)) {
            throw new IllegalArgumentException("container already registered");
        }
        for (CStationContainer cStationContainer2 : this.containers) {
            if (!cStationContainer2.getUniqueId().equals(cStationContainer.getUniqueId())) continue;
            throw new IllegalArgumentException("A container with unique id '" + cStationContainer.getUniqueId() + "' is already registered");
        }
        this.containers.add(cStationContainer);
        try {
            this.settingDefaultStations = cStationContainer == this.content;
            int n = 0;
            int n2 = cStationContainer.getStationCount();
            while (n < n2) {
                this.control.addStation(cStationContainer.getStation(n), true);
                ++n;
            }
        }
        finally {
            this.settingDefaultStations = false;
        }
        cStationContainer.addStationContainerListener(this.containerListener);
    }

    @Override
    public Set<String> listSingleBackupFactories() {
        return this.backupFactory.getFactoryIds();
    }

    @Override
    public Set<String> listMultipleDockableFactories() {
        return this.factories.keySet();
    }

    @Override
    public List<MultipleCDockable> listMultipleDockables(MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        ArrayList<MultipleCDockable> arrayList = new ArrayList<MultipleCDockable>();
        for (MultipleCDockable multipleCDockable : this.multiDockables) {
            if (multipleCDockable.getFactory() != multipleCDockableFactory) continue;
            arrayList.add(multipleCDockable);
        }
        return arrayList;
    }

    @Override
    public List<CDockable> listDockablesInMode(ExtendedMode extendedMode) {
        ArrayList<CDockable> arrayList = new ArrayList<CDockable>();
        for (CDockable cDockable : this.dockables) {
            if (!cDockable.isVisible() || cDockable.getExtendedMode() != extendedMode) continue;
            arrayList.add(cDockable);
        }
        return arrayList;
    }

    @Override
    public Set<String> listSingleDockables() {
        HashSet<String> hashSet = new HashSet<String>();
        for (FrontendEntry frontendEntry : this.control.intern().listFrontendEntries()) {
            String string = frontendEntry.getKey();
            if (!this.isSingleId(string)) continue;
            hashSet.add(this.singleToNormalId(string));
        }
        return hashSet;
    }

    @Override
    public String toSingleId(String string) {
        return "single " + string;
    }

    @Override
    public boolean isSingleId(String string) {
        return string.startsWith("single ");
    }

    @Override
    public String singleToNormalId(String string) {
        return string.substring(7);
    }

    @Override
    public String toMultiId(String string) {
        return "multi " + string;
    }

    @Override
    public boolean isMultiId(String string) {
        return string.startsWith("multi ");
    }

    @Override
    public String multiToNormalId(String string) {
        return string.substring(6);
    }

    @Override
    public void addMultipleDockable(MultipleCDockable multipleCDockable) {
        this.dockables.add(multipleCDockable);
        this.multiDockables.add(multipleCDockable);
    }

    @Override
    public void addSingleDockable(SingleCDockable singleCDockable) {
        this.dockables.add(singleCDockable);
        this.singleDockables.add(singleCDockable);
    }

    @Override
    public SingleCDockable getSingleDockable(String string) {
        for (SingleCDockable singleCDockable : this.singleDockables) {
            if (!singleCDockable.getUniqueId().equals(string)) continue;
            return singleCDockable;
        }
        return null;
    }

    @Override
    public void addStation(CStation<?> cStation) {
        if (!this.settingDefaultStations) {
            this.checkStationIdentifierUniqueness(cStation.getUniqueId(), cStation);
        }
        this.stations.add(cStation);
    }

    private void checkStationIdentifierUniqueness(String string, CStation<?> cStation) {
        if (string == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        if (CContentArea.getCenterIdentifier("ccontrol").equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getEastIdentifier("ccontrol").equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getWestIdentifier("ccontrol").equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getSouthIdentifier("ccontrol").equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getNorthIdentifier("ccontrol").equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        for (CStation<?> cStation2 : this.stations) {
            if (!cStation2.getUniqueId().equals(string)) continue;
            if (cStation2 == cStation) {
                throw new IllegalArgumentException("The station has already been registered");
            }
            throw new IllegalArgumentException("There exists already a station with id: " + string);
        }
    }

    @Override
    public CommonSingleDockableFactory getBackupFactory() {
        return this.backupFactory;
    }

    @Override
    public CommonMultipleDockableFactory getCommonMultipleDockableFactory(String string) {
        return this.factories.get(string);
    }

    @Override
    public CContentArea getDefaultContentArea() {
        return this.content;
    }

    @Override
    public void putCommonMultipleDockableFactory(String string, CommonMultipleDockableFactory commonMultipleDockableFactory) {
        this.factories.put(string, commonMultipleDockableFactory);
    }

    @Override
    public CommonMultipleDockableFactory removeCommonMultipleDockableFactory(String string) {
        return this.factories.remove(string);
    }

    @Override
    public boolean removeStationContainer(CStationContainer cStationContainer) {
        if (this.containers.remove(cStationContainer)) {
            cStationContainer.removeStationContainerListener(this.containerListener);
            int n = 0;
            int n2 = cStationContainer.getStationCount();
            while (n < n2) {
                this.control.removeStation(cStationContainer.getStation(n));
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeMultipleDockable(MultipleCDockable multipleCDockable) {
        if (this.dockables.remove(multipleCDockable)) {
            this.multiDockables.remove(multipleCDockable);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSingleDockable(SingleCDockable singleCDockable) {
        if (this.dockables.remove(singleCDockable)) {
            this.singleDockables.remove(singleCDockable);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeStation(CStation<?> cStation) {
        return this.stations.remove(cStation);
    }

    @Override
    public void setDefaultContentArea(CContentArea cContentArea) {
        this.content = cContentArea;
    }

    @Override
    public CDockable getDockable(int n) {
        return this.dockables.get(n);
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Map<String, MultipleCDockableFactory<?, ?>> getFactories() {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, CommonMultipleDockableFactory> entry : this.factories.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getFactory());
        }
        return hashMap;
    }

    @Override
    public MultipleCDockableFactory<?, ?> getFactory(String string) {
        CommonMultipleDockableFactory commonMultipleDockableFactory = this.factories.get(string);
        if (commonMultipleDockableFactory == null) {
            return null;
        }
        return commonMultipleDockableFactory.getFactory();
    }
}

