/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonSingleDockableLayout;
import bibliothek.gui.dock.common.intern.DelayedWorkingAreaSetter;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Filter;
import bibliothek.util.Version;
import bibliothek.util.filter.PresetFilter;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommonSingleDockableFactory
implements DockFactory<CommonDockable, CommonElementPerspective, CommonSingleDockableLayout> {
    public static final String BACKUP_FACTORY_ID = "ccontrol backup factory id";
    private List<Entry> factories = new ArrayList<Entry>();
    private Map<String, Entry> singleIdFactories = new HashMap<String, Entry>();
    private CControl control;
    private CPerspective perspective;

    public CommonSingleDockableFactory(CControl cControl) {
        this.control = cControl;
    }

    public CommonSingleDockableFactory(CControl cControl, CPerspective cPerspective) {
        this.control = cControl;
        this.perspective = cPerspective;
    }

    public void add(String string, SingleCDockableFactory singleCDockableFactory) {
        Entry entry = this.singleIdFactories.remove(string);
        if (entry != null) {
            this.factories.remove(entry);
        }
        Entry entry2 = new Entry(new PresetFilter<String>(string), singleCDockableFactory);
        this.factories.add(entry2);
        this.singleIdFactories.put(string, entry2);
    }

    public void add(Filter<String> filter, SingleCDockableFactory singleCDockableFactory) {
        this.factories.add(new Entry(filter, singleCDockableFactory));
    }

    public void remove(String string) {
        Entry entry = this.singleIdFactories.remove(string);
        if (entry != null) {
            this.factories.remove(entry);
        }
    }

    public void remove(SingleCDockableFactory singleCDockableFactory) {
        Entry entry;
        Iterator<Entry> iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.factory != singleCDockableFactory) continue;
            iterator.remove();
        }
        iterator = this.singleIdFactories.values().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.factory != singleCDockableFactory) continue;
            iterator.remove();
        }
    }

    public SingleCDockableFactory getFactory(String string) {
        Entry entry = this.singleIdFactories.get(string);
        if (entry != null) {
            return entry.factory;
        }
        for (Entry entry2 : this.factories) {
            if (!entry2.filter.includes(string)) continue;
            return entry2.factory;
        }
        return null;
    }

    @Override
    public String getID() {
        return BACKUP_FACTORY_ID;
    }

    public String[] listFactories() {
        Set<String> set = this.singleIdFactories.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Set<String> getFactoryIds() {
        return Collections.unmodifiableSet(this.singleIdFactories.keySet());
    }

    @Override
    public void estimateLocations(CommonSingleDockableLayout commonSingleDockableLayout, LocationEstimationMap locationEstimationMap) {
    }

    @Override
    public CommonSingleDockableLayout getLayout(CommonDockable commonDockable, Map<Dockable, Integer> map) {
        CDockable cDockable = commonDockable.getDockable();
        if (cDockable instanceof SingleCDockable) {
            SingleCDockable singleCDockable = (SingleCDockable)cDockable;
            CommonSingleDockableLayout commonSingleDockableLayout = new CommonSingleDockableLayout();
            commonSingleDockableLayout.setId(singleCDockable.getUniqueId());
            commonSingleDockableLayout.setArea(singleCDockable.getWorkingArea() == null ? null : singleCDockable.getWorkingArea().getUniqueId());
            return commonSingleDockableLayout;
        }
        throw new IllegalArgumentException("A CommonSingleDockableFactory works only with Dockables of type SingleCDockable, but this is not a single dockable: " + commonDockable);
    }

    @Override
    public CommonDockable layout(CommonSingleDockableLayout commonSingleDockableLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        return this.layout(commonSingleDockableLayout, placeholderStrategy);
    }

    @Override
    public CommonDockable layout(CommonSingleDockableLayout commonSingleDockableLayout, PlaceholderStrategy placeholderStrategy) {
        SingleCDockableFactory singleCDockableFactory = this.getFactory(commonSingleDockableLayout.getId());
        if (singleCDockableFactory == null) {
            return null;
        }
        SingleCDockable singleCDockable = singleCDockableFactory.createBackup(commonSingleDockableLayout.getId());
        if (singleCDockable == null) {
            return null;
        }
        String string = singleCDockable.intern().getFactoryID();
        if (!string.equals(this.getID())) {
            throw new IllegalArgumentException("Wrong type of dockable for unique id '" + commonSingleDockableLayout.getId() + "': The backup factory created a dockable which expects a factory with type-id '" + string + "',  but the call was done from a factory with type-id '" + this.getID() + "'");
        }
        this.control.addDockable(singleCDockable);
        if (commonSingleDockableLayout.isAreaSet()) {
            if (commonSingleDockableLayout.getArea() != null) {
                CStation<?> cStation = this.control.getStation(commonSingleDockableLayout.getArea());
                if (cStation == null) {
                    DelayedWorkingAreaSetter delayedWorkingAreaSetter = new DelayedWorkingAreaSetter(commonSingleDockableLayout.getArea(), singleCDockable, this.control);
                    delayedWorkingAreaSetter.install();
                } else {
                    singleCDockable.setWorkingArea(cStation);
                }
            } else {
                singleCDockable.setWorkingArea(null);
            }
        }
        return singleCDockable.intern();
    }

    @Override
    public CommonElementPerspective layoutPerspective(CommonSingleDockableLayout commonSingleDockableLayout, Map<Integer, PerspectiveDockable> map) {
        SingleCDockablePerspective singleCDockablePerspective = new SingleCDockablePerspective(commonSingleDockableLayout.getId());
        if (commonSingleDockableLayout.isAreaSet() && commonSingleDockableLayout.getArea() != null) {
            singleCDockablePerspective.setWorkingArea(this.perspective.getStation(commonSingleDockableLayout.getArea()));
        }
        return singleCDockablePerspective.intern();
    }

    @Override
    public void layoutPerspective(CommonElementPerspective commonElementPerspective, CommonSingleDockableLayout commonSingleDockableLayout, Map<Integer, PerspectiveDockable> map) {
    }

    @Override
    public CommonSingleDockableLayout getPerspectiveLayout(CommonElementPerspective commonElementPerspective, Map<PerspectiveDockable, Integer> map) {
        SingleCDockablePerspective singleCDockablePerspective = (SingleCDockablePerspective)commonElementPerspective.getElement();
        CommonSingleDockableLayout commonSingleDockableLayout = new CommonSingleDockableLayout();
        commonSingleDockableLayout.setId(singleCDockablePerspective.getUniqueId());
        commonSingleDockableLayout.setArea(singleCDockablePerspective.getWorkingArea() == null ? null : singleCDockablePerspective.getWorkingArea().getUniqueId());
        return commonSingleDockableLayout;
    }

    @Override
    public CommonSingleDockableLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        CommonSingleDockableLayout commonSingleDockableLayout = new CommonSingleDockableLayout();
        if (version.equals(Version.VERSION_1_0_4)) {
            commonSingleDockableLayout.setId(dataInputStream.readUTF());
        } else if (version.equals(Version.VERSION_1_1_0)) {
            commonSingleDockableLayout.setId(dataInputStream.readUTF());
            commonSingleDockableLayout.setArea(dataInputStream.readUTF());
        } else if (version.equals(Version.VERSION_1_1_0a)) {
            commonSingleDockableLayout.setId(dataInputStream.readUTF());
            if (dataInputStream.readBoolean()) {
                commonSingleDockableLayout.setArea(dataInputStream.readUTF());
            } else {
                commonSingleDockableLayout.setArea(null);
            }
        } else {
            throw new IOException("Data from the future - unknown version: " + version);
        }
        return commonSingleDockableLayout;
    }

    @Override
    public CommonSingleDockableLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        CommonSingleDockableLayout commonSingleDockableLayout = new CommonSingleDockableLayout();
        commonSingleDockableLayout.setId(xElement.getElement("id").getString());
        XElement xElement2 = xElement.getElement("area");
        if (xElement2 != null) {
            String string = xElement2.getString();
            if ("".equals(string)) {
                commonSingleDockableLayout.setArea(null);
            } else {
                commonSingleDockableLayout.setArea(string);
            }
        }
        return commonSingleDockableLayout;
    }

    @Override
    public void setLayout(CommonDockable commonDockable, CommonSingleDockableLayout commonSingleDockableLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public void setLayout(CommonDockable commonDockable, CommonSingleDockableLayout commonSingleDockableLayout, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public void write(CommonSingleDockableLayout commonSingleDockableLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_0a);
        dataOutputStream.writeUTF(commonSingleDockableLayout.getId());
        String string = commonSingleDockableLayout.getArea();
        if (string == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(string);
        }
    }

    @Override
    public void write(CommonSingleDockableLayout commonSingleDockableLayout, XElement xElement) {
        xElement.addElement("id").setString(commonSingleDockableLayout.getId());
        XElement xElement2 = xElement.addElement("area");
        if (commonSingleDockableLayout.getArea() != null) {
            xElement2.setString(commonSingleDockableLayout.getArea());
        }
    }

    private static class Entry {
        public final Filter<String> filter;
        public final SingleCDockableFactory factory;

        public Entry(Filter<String> filter, SingleCDockableFactory singleCDockableFactory) {
            if (filter == null) {
                throw new IllegalArgumentException("filter must not be null");
            }
            if (singleCDockableFactory == null) {
                throw new IllegalArgumentException("factory must not be null");
            }
            this.filter = filter;
            this.factory = singleCDockableFactory;
        }
    }
}

