/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableLayout;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CPerspectiveMultipleIdentifierCollection;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class CommonMultipleDockableFactory
implements DockFactory<CommonDockable, CommonElementPerspective, CommonMultipleDockableLayout> {
    private String id;
    private MultipleCDockableFactory<MultipleCDockable, MultipleCDockableLayout> delegate;
    private CControlAccess controlAccess;
    private CPerspectiveMultipleIdentifierCollection perspectiveIdentifiers;

    public CommonMultipleDockableFactory(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory, CControlAccess cControlAccess) {
        this.id = string;
        this.delegate = multipleCDockableFactory;
        this.controlAccess = cControlAccess;
    }

    public CommonMultipleDockableFactory(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory, CControlAccess cControlAccess, CPerspective cPerspective) {
        this.id = string;
        this.delegate = multipleCDockableFactory;
        this.controlAccess = cControlAccess;
        this.perspectiveIdentifiers = new CPerspectiveMultipleIdentifierCollection(string, cPerspective);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public MultipleCDockableFactory<?, ?> getFactory() {
        return this.delegate;
    }

    @Override
    public void estimateLocations(CommonMultipleDockableLayout commonMultipleDockableLayout, LocationEstimationMap locationEstimationMap) {
    }

    @Override
    public CommonMultipleDockableLayout getLayout(CommonDockable commonDockable, Map<Dockable, Integer> map) {
        MultipleCDockable multipleCDockable = (MultipleCDockable)commonDockable.getDockable();
        MultipleCDockableLayout multipleCDockableLayout = this.delegate.write(multipleCDockable);
        CommonMultipleDockableLayout commonMultipleDockableLayout = new CommonMultipleDockableLayout();
        commonMultipleDockableLayout.setLayout(multipleCDockableLayout);
        String string = this.controlAccess.access(commonDockable.getDockable()).getUniqueId();
        string = this.controlAccess.getRegister().multiToNormalId(string);
        commonMultipleDockableLayout.setId(string);
        if (commonDockable.getDockable().getWorkingArea() != null) {
            commonMultipleDockableLayout.setArea(commonDockable.getDockable().getWorkingArea().getUniqueId());
        }
        return commonMultipleDockableLayout;
    }

    @Override
    public CommonMultipleDockableLayout getPerspectiveLayout(CommonElementPerspective commonElementPerspective, Map<PerspectiveDockable, Integer> map) {
        MultipleCDockablePerspective multipleCDockablePerspective = (MultipleCDockablePerspective)commonElementPerspective.getElement();
        MultipleCDockableLayout multipleCDockableLayout = multipleCDockablePerspective.getLayout();
        CommonMultipleDockableLayout commonMultipleDockableLayout = new CommonMultipleDockableLayout();
        commonMultipleDockableLayout.setLayout(multipleCDockableLayout);
        String string = this.perspectiveIdentifiers.getUniqueId(multipleCDockablePerspective);
        commonMultipleDockableLayout.setId(string);
        if (multipleCDockablePerspective.getWorkingArea() != null) {
            commonMultipleDockableLayout.setArea(multipleCDockablePerspective.getWorkingArea().getUniqueId());
        }
        return commonMultipleDockableLayout;
    }

    @Override
    public void layoutPerspective(CommonElementPerspective commonElementPerspective, CommonMultipleDockableLayout commonMultipleDockableLayout, Map<Integer, PerspectiveDockable> map) {
        MultipleCDockablePerspective multipleCDockablePerspective = (MultipleCDockablePerspective)commonElementPerspective.getElement();
        multipleCDockablePerspective.setLayout(commonMultipleDockableLayout.getLayout());
        this.perspectiveIdentifiers.putDockable(commonMultipleDockableLayout.getId(), multipleCDockablePerspective);
        String string = commonMultipleDockableLayout.getArea();
        if (string != null) {
            multipleCDockablePerspective.setWorkingArea(this.perspectiveIdentifiers.getPerspective().getStation(string));
        }
    }

    @Override
    public CommonElementPerspective layoutPerspective(CommonMultipleDockableLayout commonMultipleDockableLayout, Map<Integer, PerspectiveDockable> map) {
        MultipleCDockablePerspective multipleCDockablePerspective = new MultipleCDockablePerspective(this.getID(), commonMultipleDockableLayout.getId(), commonMultipleDockableLayout.getLayout());
        this.layoutPerspective(multipleCDockablePerspective.intern(), commonMultipleDockableLayout, map);
        return multipleCDockablePerspective.intern();
    }

    @Override
    public CommonDockable layout(CommonMultipleDockableLayout commonMultipleDockableLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        return this.layout(commonMultipleDockableLayout, placeholderStrategy);
    }

    @Override
    public CommonDockable layout(CommonMultipleDockableLayout commonMultipleDockableLayout, PlaceholderStrategy placeholderStrategy) {
        MultipleCDockable multipleCDockable = this.delegate.read(commonMultipleDockableLayout.getLayout());
        if (multipleCDockable == null) {
            return null;
        }
        String string = commonMultipleDockableLayout.getId();
        MultipleCDockable multipleCDockable2 = this.controlAccess.getOwner().getMultipleDockable(string);
        if (multipleCDockable2 != null) {
            this.controlAccess.getOwner().replace(multipleCDockable2, multipleCDockable);
        } else {
            this.controlAccess.getOwner().addDockable(string, multipleCDockable);
        }
        String string2 = commonMultipleDockableLayout.getArea();
        if (string2 != null) {
            CStation<?> cStation = this.controlAccess.getOwner().getStation(string2);
            if (cStation != null) {
                if (cStation.isWorkingArea()) {
                    multipleCDockable.setWorkingArea(cStation);
                }
            } else {
                int n = 0;
                int n2 = this.controlAccess.getOwner().getCDockableCount();
                while (n < n2) {
                    CDockable cDockable = this.controlAccess.getOwner().getCDockable(n);
                    CStation<?> cStation2 = cDockable.asStation();
                    if (cStation2 != null && cStation2.isWorkingArea() && cStation2.getUniqueId().equals(string2)) {
                        multipleCDockable.setWorkingArea(cStation2);
                        break;
                    }
                    ++n;
                }
            }
        }
        return multipleCDockable.intern();
    }

    @Override
    public void setLayout(CommonDockable commonDockable, CommonMultipleDockableLayout commonMultipleDockableLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public void setLayout(CommonDockable commonDockable, CommonMultipleDockableLayout commonMultipleDockableLayout, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public CommonMultipleDockableLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        CommonMultipleDockableLayout commonMultipleDockableLayout = new CommonMultipleDockableLayout();
        commonMultipleDockableLayout.setLayout(this.delegate.create());
        commonMultipleDockableLayout.getLayout().readStream(dataInputStream);
        commonMultipleDockableLayout.setId(dataInputStream.readUTF());
        if (dataInputStream.readBoolean()) {
            commonMultipleDockableLayout.setArea(dataInputStream.readUTF());
        }
        return commonMultipleDockableLayout;
    }

    @Override
    public CommonMultipleDockableLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        CommonMultipleDockableLayout commonMultipleDockableLayout = new CommonMultipleDockableLayout();
        commonMultipleDockableLayout.setLayout(this.delegate.create());
        commonMultipleDockableLayout.getLayout().readXML(xElement.getElement("multiple"));
        commonMultipleDockableLayout.setId(xElement.getElement("id").getString());
        XElement xElement2 = xElement.getElement("area");
        if (xElement2 != null) {
            commonMultipleDockableLayout.setArea(xElement2.getString());
        }
        return commonMultipleDockableLayout;
    }

    @Override
    public void write(CommonMultipleDockableLayout commonMultipleDockableLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        commonMultipleDockableLayout.getLayout().writeStream(dataOutputStream);
        dataOutputStream.writeUTF(commonMultipleDockableLayout.getId());
        if (commonMultipleDockableLayout.getArea() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(commonMultipleDockableLayout.getArea());
        }
    }

    @Override
    public void write(CommonMultipleDockableLayout commonMultipleDockableLayout, XElement xElement) {
        xElement.addElement("id").setString(commonMultipleDockableLayout.getId());
        if (commonMultipleDockableLayout.getArea() != null) {
            xElement.addElement("area").setString(commonMultipleDockableLayout.getArea());
        }
        commonMultipleDockableLayout.getLayout().writeXML(xElement.addElement("multiple"));
    }
}

