/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockFrontendListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CPlaceholderStrategy
implements PlaceholderStrategy {
    private CControl control;
    private List<PlaceholderStrategyListener> listeners = new ArrayList<PlaceholderStrategyListener>();
    private Map<MultipleCDockable, Path> multiplePlaceholders = new HashMap<MultipleCDockable, Path>();
    private CControlListener controlListener = new CControlListener(){

        @Override
        public void removed(CControl cControl, CDockable cDockable) {
            Path path;
            if (cDockable instanceof SingleCDockable) {
                String string = ((SingleCDockable)cDockable).getUniqueId();
                Path path2 = CPlaceholderStrategy.getSingleDockablePlaceholder(string);
                if (!CPlaceholderStrategy.this.isValidPlaceholder(path2)) {
                    CPlaceholderStrategy.this.fireInvalidated(path2);
                }
            } else if (cDockable instanceof MultipleCDockable && (path = (Path)CPlaceholderStrategy.this.multiplePlaceholders.remove(cDockable)) != null && !CPlaceholderStrategy.this.isValidPlaceholder(path)) {
                CPlaceholderStrategy.this.fireInvalidated(path);
            }
        }

        @Override
        public void opened(CControl cControl, CDockable cDockable) {
        }

        @Override
        public void closed(CControl cControl, CDockable cDockable) {
        }

        @Override
        public void added(CControl cControl, CDockable cDockable) {
        }
    };
    private Set<Path> pendingChecks = null;
    private CDockFrontendListener frontendListener = new CDockFrontendListener(){

        @Override
        public void loading(CDockFrontend cDockFrontend, CSetting cSetting) {
            CPlaceholderStrategy.this.pendingChecks = new HashSet();
        }

        @Override
        public void loaded(CDockFrontend cDockFrontend, CSetting cSetting) {
            if (CPlaceholderStrategy.this.pendingChecks != null) {
                Set set = CPlaceholderStrategy.this.pendingChecks;
                CPlaceholderStrategy.this.pendingChecks = null;
                for (Path path : set) {
                    if (CPlaceholderStrategy.this.isValidPlaceholder(path)) continue;
                    CPlaceholderStrategy.this.fireInvalidated(path);
                }
            }
        }
    };

    public static Path getSingleDockablePlaceholder(String string) {
        return new Path("dock", "single", string);
    }

    public static Path getMultipleDockablePlaceholder(String string) {
        return new Path("dock", "multi", string);
    }

    public CPlaceholderStrategy(CControl cControl) {
        this.control = cControl;
    }

    @Override
    public void addListener(PlaceholderStrategyListener placeholderStrategyListener) {
        if (placeholderStrategyListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listeners.isEmpty()) {
            this.control.addControlListener(this.controlListener);
            this.control.intern().addListener(this.frontendListener);
        }
        this.listeners.add(placeholderStrategyListener);
    }

    @Override
    public void removeListener(PlaceholderStrategyListener placeholderStrategyListener) {
        this.listeners.remove(placeholderStrategyListener);
        if (this.listeners.isEmpty()) {
            this.control.removeControlListener(this.controlListener);
            this.control.intern().removeListener(this.frontendListener);
            this.frontendListener.loaded(null, null);
        }
    }

    protected void fireInvalidated(Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        hashSet = Collections.unmodifiableSet(hashSet);
        PlaceholderStrategyListener[] placeholderStrategyListenerArray = this.listeners.toArray(new PlaceholderStrategyListener[this.listeners.size()]);
        int n = placeholderStrategyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlaceholderStrategyListener placeholderStrategyListener = placeholderStrategyListenerArray[n2];
            placeholderStrategyListener.placeholderInvalidated(hashSet);
            ++n2;
        }
    }

    @Override
    public Path getPlaceholderFor(Dockable dockable) {
        CDockableAccess cDockableAccess;
        if (!(dockable instanceof CommonDockable)) {
            return null;
        }
        CDockable cDockable = ((CommonDockable)dockable).getDockable();
        CControlAccess cControlAccess = cDockable.getControlAccess();
        if (cControlAccess == null || cControlAccess.getOwner() != this.control) {
            return null;
        }
        if (cDockable instanceof SingleCDockable) {
            String string = ((SingleCDockable)cDockable).getUniqueId();
            return CPlaceholderStrategy.getSingleDockablePlaceholder(string);
        }
        if (cDockable instanceof MultipleCDockable && (cDockableAccess = cControlAccess.access(cDockable)) != null) {
            Path path = CPlaceholderStrategy.getMultipleDockablePlaceholder(cControlAccess.getRegister().multiToNormalId(cDockableAccess.getUniqueId()));
            this.multiplePlaceholders.put((MultipleCDockable)cDockable, path);
            return path;
        }
        return null;
    }

    @Override
    public boolean isValidPlaceholder(Path path) {
        String string;
        if (path.getSegmentCount() != 3) {
            return true;
        }
        if (!path.getSegment(0).equals("dock")) {
            return true;
        }
        if (path.getSegment(1).equals("single")) {
            string = path.getSegment(2);
            if (this.control.getSingleDockable(string) != null) {
                return true;
            }
            if (this.control.getSingleDockableFactory(string) != null) {
                return true;
            }
        }
        if (path.getSegment(1).equals("multi")) {
            if (this.pendingChecks != null) {
                this.pendingChecks.add(path);
                return true;
            }
            string = path.getSegment(2);
            if (this.control.getMultipleDockable(string) != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void install(DockStation dockStation) {
    }

    @Override
    public void uninstall(DockStation dockStation) {
    }
}

