/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.event.CDockableLocationEvent;
import bibliothek.gui.dock.common.event.CDockableLocationListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.dockable.DockableStateEvent;
import bibliothek.gui.dock.dockable.DockableStateListener;
import java.awt.EventQueue;

public class CDockableLocationListenerManager {
    private CDockable dockable;
    private CDockableLocationListener listener;
    private CLocation location;
    private boolean showing;
    private boolean delayed = false;
    private DockableStateListener dockableListener = new DockableStateListener(){

        @Override
        public void changed(DockableStateEvent dockableStateEvent) {
            CDockableLocationListenerManager.this.check();
        }
    };

    public CDockableLocationListenerManager(CDockable cDockable) {
        this.dockable = cDockable;
    }

    public void setListener(CDockableLocationListener cDockableLocationListener) {
        if (this.listener == null) {
            this.dockable.intern().removeDockableStateListener(this.dockableListener);
        }
        this.listener = null;
        if (cDockableLocationListener != null) {
            this.check();
            this.listener = cDockableLocationListener;
            this.dockable.intern().addDockableStateListener(this.dockableListener);
        }
    }

    private void check() {
        if (!this.delayed) {
            this.delayed = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CDockableLocationListenerManager.this.delayed = false;
                    CDockableLocationListenerManager.this.checkNow();
                }
            });
        }
    }

    private void checkNow() {
        boolean bl = this.dockable.isShowing();
        CLocation cLocation = this.dockable.getBaseLocation();
        boolean bl2 = this.showing;
        CLocation cLocation2 = this.location;
        this.showing = bl;
        this.location = cLocation;
        boolean bl3 = false;
        if (!(cLocation == null && cLocation2 == null || cLocation != null && cLocation.equals(cLocation2))) {
            bl3 = true;
        }
        if ((bl3 || bl != bl2) && this.listener != null) {
            CDockableLocationEvent cDockableLocationEvent = new CDockableLocationEvent(this.dockable, bl2, bl, cLocation2, cLocation);
            this.listener.changed(cDockableLocationEvent);
        }
    }
}

