/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;

public abstract class AbstractCStation<S extends CommonDockStation<?, ?>>
implements CStation<S> {
    private CLocation location;
    private String id;
    private S station;
    private CControlAccess control;

    public AbstractCStation(S s, String string, CLocation cLocation) {
        this.init(s, string, cLocation);
    }

    protected AbstractCStation() {
    }

    protected void init(S s, String string, CLocation cLocation) {
        if (s == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (cLocation == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        this.station = s;
        this.id = string;
        this.location = cLocation;
    }

    @Override
    public CLocation getStationLocation() {
        return this.location;
    }

    @Override
    public CLocation getDropLocation() {
        if (this.control == null) {
            return null;
        }
        return this.control.getLocationManager().getDropLocation(this);
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public S getStation() {
        return this.station;
    }

    @Override
    public void setControlAccess(CControlAccess cControlAccess) {
        if (this.control != cControlAccess) {
            if (this.control != null) {
                this.uninstall(this.control);
            }
            this.control = cControlAccess;
            if (this.control != null) {
                this.install(this.control);
            }
        }
    }

    protected CControlAccess getControl() {
        return this.control;
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    @Override
    public CDockable asDockable() {
        return null;
    }

    protected abstract void install(CControlAccess var1);

    protected abstract void uninstall(CControlAccess var1);
}

