/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.grouping;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;

public class PlaceholderGrouping
implements DockableGrouping {
    private CControl control;
    private Path placeholder;

    public PlaceholderGrouping(CControl cControl, Path path) {
        if (cControl == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        this.control = cControl;
        this.placeholder = path;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    protected Path getLastPlaceholder() {
        return this.placeholder.append("last");
    }

    @Override
    public Location getStoredLocation(Dockable dockable, CLocationMode cLocationMode, Location location) {
        return location;
    }

    @Override
    public Location getValidatedLocation(Dockable dockable, CLocationMode cLocationMode, Location location) {
        Location location2;
        if (location != null && (location2 = this.findLocationFor(dockable, cLocationMode, location)) != location) {
            return location2;
        }
        location2 = this.findLocationFor(dockable, cLocationMode);
        if (location2 == null) {
            location2 = location;
        }
        return location2;
    }

    @Override
    public ExtendedMode getInitialMode(Dockable dockable) {
        ExtendedMode extendedMode = this.getInitialMode(dockable, true);
        if (extendedMode == null) {
            extendedMode = this.getInitialMode(dockable, false);
        }
        return extendedMode;
    }

    private ExtendedMode getInitialMode(Dockable dockable, boolean bl) {
        Path path = this.getLastPlaceholder();
        for (CLocationMode cLocationMode : this.control.getLocationManager().modes()) {
            for (String string : cLocationMode.getRepresentationIds()) {
                Dockable dockable2;
                DockStation dockStation = cLocationMode.getRepresentation(string);
                if (!dockStation.getPlaceholderMapping().hasPlaceholder(path)) continue;
                boolean bl2 = true;
                if (bl && (dockable2 = dockStation.getPlaceholderMapping().getDockableAt(path)) != null) {
                    bl2 = cLocationMode.isCurrentMode(dockable2);
                }
                if (!bl2) continue;
                return cLocationMode.getExtendedMode();
            }
        }
        return null;
    }

    protected Location findLocationFor(Dockable dockable, CLocationMode cLocationMode) {
        for (String string : cLocationMode.getRepresentationIds()) {
            DockableProperty dockableProperty;
            DockStation dockStation = cLocationMode.getRepresentation(string);
            if (!dockStation.getPlaceholderMapping().hasPlaceholder(this.placeholder) || (dockableProperty = this.getLocation(dockStation)) == null) continue;
            return new Location(cLocationMode.getUniqueIdentifier(), string, dockableProperty, false);
        }
        return null;
    }

    protected Location findLocationFor(Dockable dockable, CLocationMode cLocationMode, Location location) {
        DockableProperty dockableProperty;
        DockStation dockStation = cLocationMode.getRepresentation(location.getRoot());
        if (dockStation != null && dockStation.getPlaceholderMapping().hasPlaceholder(this.placeholder) && (dockableProperty = this.getLocation(dockStation)) != null) {
            return new Location(cLocationMode.getUniqueIdentifier(), location.getRoot(), dockableProperty, location.isApplicationDefined());
        }
        return location;
    }

    protected DockableProperty getLocation(DockStation dockStation) {
        Object object;
        DockableProperty dockableProperty = dockStation.getPlaceholderMapping().getLocationAt(this.placeholder);
        Object object2 = dockableProperty;
        DockableProperty dockableProperty2 = null;
        DockStation dockStation2 = dockStation;
        while (object2 != dockableProperty2) {
            DockableProperty dockableProperty3;
            PlaceholderMapping placeholderMapping;
            dockableProperty2 = object2;
            object = dockStation2.getPlaceholderMapping().getDockableAt(this.placeholder);
            if ((dockStation2 = object != null ? object.asDockStation() : null) == null || !(placeholderMapping = dockStation2.getPlaceholderMapping()).hasPlaceholder(this.placeholder) || (dockableProperty3 = placeholderMapping.getLocationAt(this.placeholder)) == null) continue;
            while (object2.getSuccessor() != null) {
                object2 = object2.getSuccessor();
            }
            object2.setSuccessor(dockableProperty3);
            object2 = dockableProperty3;
        }
        while (object2 != null) {
            object = object2.getSuccessor();
            if (object == null) {
                object2.setSuccessor(new StackDockProperty(Integer.MAX_VALUE, this.placeholder));
            }
            object2 = object;
        }
        return dockableProperty;
    }

    @Override
    public void hierarchyChanged(Dockable dockable) {
        this.markLocation(dockable);
    }

    @Override
    public void focusGained(Dockable dockable) {
        this.markLocation(dockable);
    }

    protected void markLocation(Dockable dockable) {
        this.removePlaceholderInMode(dockable);
        this.removePlaceholderEverywhere();
        Path path = this.getLastPlaceholder();
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null && dockable != null) {
            PlaceholderMapping placeholderMapping = dockStation.getPlaceholderMapping();
            placeholderMapping.addPlaceholder(dockable, this.placeholder);
            placeholderMapping.addPlaceholder(dockable, path);
            dockable = dockStation.asDockable();
            if (dockable == null) continue;
            dockStation = dockable.getDockParent();
        }
    }

    private void removePlaceholderInMode(Dockable dockable) {
        CLocationMode cLocationMode = (CLocationMode)this.control.getLocationManager().getCurrentMode(dockable);
        if (cLocationMode == null) {
            return;
        }
        for (String string : cLocationMode.getRepresentationIds()) {
            DockStation dockStation = cLocationMode.getRepresentation(string);
            if (DockUtilities.isAncestor(dockStation, dockable)) continue;
            dockStation.getPlaceholderMapping().removePlaceholder(this.placeholder);
        }
    }

    public void removePlaceholderEverywhere() {
        Path path = this.getLastPlaceholder();
        for (CLocationMode cLocationMode : this.control.getLocationManager().modes()) {
            for (String string : cLocationMode.getRepresentationIds()) {
                DockStation dockStation = cLocationMode.getRepresentation(string);
                dockStation.getPlaceholderMapping().removePlaceholder(path);
            }
        }
    }
}

