/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.grouping;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.grouping.CGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;

public class GroupingDockLocationListener
extends DockRegisterAdapter
implements DockableFocusListener {
    private CControl control;
    private Listener listener = new Listener();

    public GroupingDockLocationListener(CControl cControl) {
        this.control = cControl;
    }

    @Override
    public void dockableRegistered(DockController dockController, Dockable dockable) {
        dockable.addDockHierarchyListener(this.listener);
        this.update(dockable);
    }

    @Override
    public void dockableUnregistered(DockController dockController, Dockable dockable) {
        dockable.removeDockHierarchyListener(this.listener);
    }

    private void update(Dockable dockable) {
        CGroupingBehavior cGroupingBehavior = this.control.getProperty(CControl.GROUPING_BEHAVIOR);
        DockableGrouping dockableGrouping = cGroupingBehavior.getGrouping(dockable);
        if (dockableGrouping != null) {
            dockableGrouping.hierarchyChanged(dockable);
        }
    }

    @Override
    public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
        CGroupingBehavior cGroupingBehavior;
        DockableGrouping dockableGrouping;
        Dockable dockable = dockableFocusEvent.getNewFocusOwner();
        if (dockable != null && (dockableGrouping = (cGroupingBehavior = this.control.getProperty(CControl.GROUPING_BEHAVIOR)).getGrouping(dockable)) != null) {
            dockableGrouping.focusGained(dockable);
        }
    }

    private class Listener
    implements DockHierarchyListener {
        private Listener() {
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            GroupingDockLocationListener.this.update(dockHierarchyEvent.getDockable());
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
        }
    }
}

