/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.group;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.group.SingleGroupMovement;
import bibliothek.gui.dock.common.group.StackGroupMovement;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.util.DockUtilities;

public class StackGroupBehavior
implements CGroupBehavior {
    @Override
    public CGroupMovement prepare(LocationModeManager<? extends LocationMode> locationModeManager, Dockable dockable, ExtendedMode extendedMode) {
        if (this.isGrouped(dockable, extendedMode, locationModeManager)) {
            return new StackGroupMovement((StackDockStation)dockable.getDockParent(), dockable, extendedMode);
        }
        return new SingleGroupMovement(dockable, extendedMode);
    }

    private boolean isGrouped(Dockable dockable, ExtendedMode extendedMode, LocationModeManager<?> locationModeManager) {
        DockStation dockStation = dockable.getDockParent();
        if (dockStation instanceof StackDockStation) {
            int n = 0;
            int n2 = dockStation.getDockableCount();
            while (n < n2) {
                if (!locationModeManager.isModeAvailable(dockStation.getDockable(n), extendedMode)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public Dockable getGroupElement(LocationModeManager<? extends LocationMode> locationModeManager, Dockable dockable, ExtendedMode extendedMode) {
        DockStation dockStation = dockable.getDockParent();
        if (dockStation instanceof StackDockStation) {
            if (dockStation.asDockable().getDockParent() == null) {
                return dockable;
            }
            int n = 0;
            int n2 = dockStation.getDockableCount();
            while (n < n2) {
                Dockable dockable2 = dockStation.getDockable(n);
                if (dockable2 != dockable && !locationModeManager.isModeAvailable(dockable2, extendedMode)) {
                    return dockable;
                }
                ++n;
            }
            return (StackDockStation)dockStation;
        }
        return dockable;
    }

    @Override
    public Dockable getReplaceElement(LocationModeManager<? extends LocationMode> locationModeManager, Dockable dockable, Dockable dockable2, ExtendedMode extendedMode) {
        if (dockable == dockable2) {
            return null;
        }
        if (!DockUtilities.isAncestor(dockable, dockable2)) {
            return null;
        }
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            return dockable;
        }
        if (dockStation.getDockableCount() == 2) {
            if (dockStation.getDockable(0) == dockable2) {
                return dockStation.getDockable(1);
            }
            if (dockStation.getDockable(1) == dockable2) {
                return dockStation.getDockable(0);
            }
        }
        return dockable;
    }

    @Override
    public boolean shouldForwardActions(LocationModeManager<? extends LocationMode> locationModeManager, DockStation dockStation, Dockable dockable, ExtendedMode extendedMode) {
        Dockable dockable2 = dockStation.asDockable();
        if (dockable2 != null && !locationModeManager.isModeAvailable(dockable2, extendedMode)) {
            return false;
        }
        int n = 0;
        int n2 = dockStation.getDockableCount();
        while (n < n2) {
            Dockable dockable3 = dockStation.getDockable(n);
            if (!locationModeManager.isModeAvailable(dockable3, extendedMode)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

