/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action.panel;

import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.action.panel.AbstractPanelPopupWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DialogWindow
extends AbstractPanelPopupWindow {
    private JDialog dialog;
    private CPanelPopup panel;
    private WindowListener listener = new WindowAdapter(){

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            DialogWindow.this.closing();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DialogWindow.this.closing();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (DialogWindow.this.panel.isCloseOnFocusLost()) {
                DialogWindow.this.close();
            }
        }
    };

    public DialogWindow(Component component, CPanelPopup cPanelPopup) {
        this.panel = cPanelPopup;
        this.dialog = this.createDialog(component);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this.listener);
    }

    public void setUndecorated(boolean bl) {
        this.dialog.setUndecorated(bl);
    }

    public void setContent(Component component) {
        this.dialog.getContentPane().removeAll();
        if (component != null) {
            this.dialog.add(component);
        }
    }

    public void open(int n, int n2) {
        this.dialog.pack();
        this.dialog.setLocation(n, n2);
        this.validateBounds();
        this.dialog.setVisible(true);
    }

    public void open(Component component) {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(component);
        this.validateBounds();
        this.dialog.setVisible(true);
    }

    private void validateBounds() {
        Rectangle rectangle = this.dialog.getBounds();
        Point point = this.dialog.getLocation();
        GraphicsConfiguration graphicsConfiguration = null;
        int n = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n2 = graphicsDeviceArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n3];
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = graphicsConfiguration2.getBounds();
            if (rectangle2.contains(point)) {
                graphicsConfiguration = graphicsConfiguration2;
                n = 0;
            } else {
                int n4;
                int n5 = rectangle2.x <= point.x && rectangle2.x + rectangle2.width >= point.x ? 0 : Math.min(Math.abs(rectangle2.x - point.x), Math.abs(rectangle2.x + rectangle2.width - point.x));
                int n6 = n5 + (n4 = rectangle2.y <= point.y && rectangle2.y + rectangle2.height >= point.y ? 0 : Math.min(Math.abs(rectangle2.y - point.y), Math.abs(rectangle2.y + rectangle2.height - point.y)));
                if (n6 < n || graphicsConfiguration == null) {
                    n = n6;
                    graphicsConfiguration = graphicsConfiguration2;
                }
            }
            ++n3;
        }
        if ((rectangle = this.validateBounds(rectangle, graphicsConfiguration)) != null) {
            this.dialog.setBounds(rectangle);
        }
    }

    @Override
    public boolean isOpen() {
        return this.dialog.isVisible();
    }

    @Override
    public void close() {
        this.dialog.setVisible(false);
    }

    private void closing() {
        this.dialog.dispose();
        this.dialog.removeWindowListener(this.listener);
        this.fireClosed();
    }

    protected JDialog createDialog(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof Frame) {
            return new JDialog((Frame)window);
        }
        if (window instanceof Dialog) {
            return new JDialog((Dialog)window);
        }
        return new JDialog();
    }
}

