/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action.panel;

import bibliothek.gui.dock.common.action.panel.PanelPopupWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindowListener;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPanelPopupWindow
implements PanelPopupWindow {
    private List<PanelPopupWindowListener> listeners = new ArrayList<PanelPopupWindowListener>();

    @Override
    public void addListener(PanelPopupWindowListener panelPopupWindowListener) {
        if (panelPopupWindowListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(panelPopupWindowListener);
    }

    @Override
    public void removeListener(PanelPopupWindowListener panelPopupWindowListener) {
        this.listeners.remove(panelPopupWindowListener);
    }

    protected PanelPopupWindowListener[] listeners() {
        return this.listeners.toArray(new PanelPopupWindowListener[this.listeners.size()]);
    }

    protected void fireClosed() {
        PanelPopupWindowListener[] panelPopupWindowListenerArray = this.listeners();
        int n = panelPopupWindowListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PanelPopupWindowListener panelPopupWindowListener = panelPopupWindowListenerArray[n2];
            panelPopupWindowListener.closed(this);
            ++n2;
        }
    }

    protected Rectangle validateBounds(Rectangle rectangle, GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            return null;
        }
        Rectangle rectangle2 = graphicsConfiguration.getBounds();
        rectangle = new Rectangle(rectangle);
        rectangle.width = Math.min(rectangle.width, rectangle2.width);
        rectangle.height = Math.min(rectangle.height, rectangle2.height);
        rectangle.x = Math.min(Math.max(rectangle.x, rectangle2.x), rectangle2.x + rectangle2.width - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, rectangle2.y), rectangle2.y + rectangle2.height - rectangle.height);
        return rectangle;
    }
}

