/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.action.core.CommonSimpleButtonAction;
import bibliothek.gui.dock.common.action.panel.DialogWindow;
import bibliothek.gui.dock.common.action.panel.MenuWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindow;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindowListener;
import bibliothek.gui.dock.common.intern.action.CDecorateableAction;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CPanelPopup
extends CDecorateableAction<PanelPopup> {
    public static final ActionType<PanelPopup> PANEL_POPUP = new ActionType("panel popup");
    private MenuBehavior menu = MenuBehavior.UNDECORATED_DIALOG;
    private ButtonBehavior button = ButtonBehavior.OPEN_ON_CLICK;
    private JComponent content;
    private PanelPopupWindow window;
    private boolean closeOnFocusLost = true;
    private PanelPopupWindowListener listener = new PanelPopupWindowListener(){

        @Override
        public void closed(PanelPopupWindow panelPopupWindow) {
            panelPopupWindow.removeListener(CPanelPopup.this.listener);
            panelPopupWindow = null;
        }
    };

    public CPanelPopup() {
        super(null);
        this.init(new PanelPopup());
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setMenuBehavior(MenuBehavior menuBehavior) {
        if (menuBehavior == null) {
            throw new IllegalArgumentException("menu must not be null");
        }
        this.menu = menuBehavior;
    }

    public MenuBehavior getMenuBehavior() {
        return this.menu;
    }

    public void setButtonBehavior(ButtonBehavior buttonBehavior) {
        if (buttonBehavior == null) {
            throw new IllegalArgumentException("button must not be null");
        }
        this.button = buttonBehavior;
    }

    public ButtonBehavior getButtonBehavior() {
        return this.button;
    }

    public void setCloseOnFocusLost(boolean bl) {
        this.closeOnFocusLost = bl;
    }

    public boolean isCloseOnFocusLost() {
        return this.closeOnFocusLost;
    }

    public void openPopup(PanelPopupWindow panelPopupWindow) {
        if (!panelPopupWindow.isOpen()) {
            throw new IllegalArgumentException("window is not open");
        }
        this.closePopup();
        this.window = panelPopupWindow;
        this.window.addListener(this.listener);
    }

    public void closePopup() {
        if (this.window != null) {
            this.window.close();
        }
    }

    public boolean isOpen() {
        return this.window != null && this.window.isOpen();
    }

    protected void onMousePressed(Dockable dockable, JComponent jComponent, DockTitle.Orientation orientation) {
        if (this.getButtonBehavior() == ButtonBehavior.OPEN_ON_PRESS) {
            this.openDialog(dockable, jComponent, orientation);
        }
    }

    protected void onMouseReleased(Dockable dockable, JComponent jComponent, DockTitle.Orientation orientation) {
        if (this.getButtonBehavior() == ButtonBehavior.OPEN_ON_CLICK) {
            this.openDialog(dockable, jComponent, orientation);
        }
    }

    protected void onTrigger(Dockable dockable, JComponent jComponent, DockTitle.Orientation orientation) {
        this.openDialog(dockable, jComponent, orientation);
    }

    protected void openDialog(Dockable dockable, final JComponent jComponent, DockTitle.Orientation orientation) {
        if (this.isOpen() || this.content == null) {
            return;
        }
        final Point point = new Point();
        if (orientation.isHorizontal()) {
            point.y = jComponent.getHeight();
        } else {
            point.x = jComponent.getWidth();
        }
        SwingUtilities.convertPointToScreen(point, jComponent);
        this.executeOneDockableHasFocus(dockable, new Runnable(){

            @Override
            public void run() {
                DialogWindow dialogWindow = CPanelPopup.this.createDialogWindow(jComponent);
                dialogWindow.setUndecorated(true);
                dialogWindow.setContent(CPanelPopup.this.getContent());
                dialogWindow.open(point.x, point.y);
                CPanelPopup.this.openPopup(dialogWindow);
            }
        });
    }

    protected void onMenuItemTrigger(final Dockable dockable) {
        if (this.content == null) {
            return;
        }
        this.closePopup();
        this.executeOneDockableHasFocus(dockable, new Runnable(){

            @Override
            public void run() {
                DialogWindow dialogWindow = CPanelPopup.this.createDialogWindow(dockable.getComponent());
                dialogWindow.setUndecorated(CPanelPopup.this.getMenuBehavior() == MenuBehavior.UNDECORATED_DIALOG);
                dialogWindow.setContent(CPanelPopup.this.getContent());
                dialogWindow.open(dockable.getComponent());
                CPanelPopup.this.openPopup(dialogWindow);
            }
        });
    }

    protected DialogWindow createDialogWindow(Component component) {
        return new DialogWindow(component, this);
    }

    protected void onMenuTrigger(JPopupMenu jPopupMenu) {
        if (this.content == null) {
            return;
        }
        jPopupMenu.add(this.content);
        MenuWindow menuWindow = this.createMenuWindow(jPopupMenu);
        this.openPopup(menuWindow);
    }

    protected MenuWindow createMenuWindow(JPopupMenu jPopupMenu) {
        return new MenuWindow(jPopupMenu);
    }

    protected void executeOneDockableHasFocus(Dockable dockable, Runnable runnable) {
        DockController dockController = dockable.getController();
        if (dockController != null) {
            dockController.getFocusController().onFocusRequestCompletion(runnable);
        } else {
            runnable.run();
        }
    }

    public static enum ButtonBehavior {
        OPEN_ON_PRESS,
        OPEN_ON_CLICK;

    }

    public static enum MenuBehavior {
        HIDE,
        SUBMENU,
        UNDECORATED_DIALOG,
        DECORATED_DIALOG;

    }

    public class PanelPopup
    extends CommonSimpleButtonAction {
        public PanelPopup() {
            super(CPanelPopup.this);
        }

        @Override
        public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
            return actionViewConverter.createView(PANEL_POPUP, this, viewTarget, dockable);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            return false;
        }

        @Override
        public CPanelPopup getAction() {
            return CPanelPopup.this;
        }

        public void onMousePressed(Dockable dockable, JComponent jComponent, DockTitle.Orientation orientation) {
            CPanelPopup.this.onMousePressed(dockable, jComponent, orientation);
        }

        public void onMouseReleased(Dockable dockable, JComponent jComponent, DockTitle.Orientation orientation) {
            CPanelPopup.this.onMouseReleased(dockable, jComponent, orientation);
        }

        public void onTrigger(Dockable dockable, JComponent jComponent, DockTitle.Orientation orientation) {
            CPanelPopup.this.onTrigger(dockable, jComponent, orientation);
        }

        public void onMenuItemTrigger(Dockable dockable) {
            CPanelPopup.this.onMenuItemTrigger(dockable);
        }

        public void onMenuTrigger(JPopupMenu jPopupMenu) {
            CPanelPopup.this.onMenuTrigger(jPopupMenu);
        }
    }
}

