/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.location.CWorkingAreaLocation;
import bibliothek.gui.dock.common.perspective.CWorkingPerspective;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.util.Path;

public class CWorkingArea
extends CGridArea {
    public static final Path TYPE_ID = new Path("dock", "CWorkingArea");

    public CWorkingArea(CControl cControl, String string) {
        super(cControl, string);
        this.setMaximizingArea(false);
    }

    @Override
    public boolean isWorkingArea() {
        return true;
    }

    @Override
    public CLocation getStationLocation() {
        return new CWorkingAreaLocation(this);
    }

    @Override
    public CWorkingPerspective createPerspective() {
        return new CWorkingPerspective(this.getUniqueId(), this.getTypeId());
    }

    @Override
    public void deploy(CGrid cGrid) {
        DockableSplitDockTree dockableSplitDockTree = cGrid.toTree();
        Dockable[] dockableArray = (Dockable[])dockableSplitDockTree.getDockables();
        int n = dockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dockable dockable = dockableArray[n2];
            if (dockable instanceof CommonDockable) {
                CommonDockable commonDockable = (CommonDockable)dockable;
                commonDockable.getDockable().setWorkingArea(this);
            }
            ++n2;
        }
        this.getStation().dropTree(dockableSplitDockTree);
    }

    public <F extends SingleCDockable> F show(F f) {
        this.add(f);
        f.setLocationsAsideFocused();
        f.setVisible(true);
        return f;
    }

    public <F extends MultipleCDockable> F show(F f) {
        this.add(f);
        f.setLocationsAsideFocused();
        f.setVisible(true);
        return f;
    }

    public <F extends SingleCDockable> F add(F f) {
        f.setWorkingArea(this);
        CControlAccess cControlAccess = this.control();
        if (cControlAccess != null) {
            cControlAccess.getOwner().addDockable(f);
        }
        return f;
    }

    public <F extends MultipleCDockable> F add(F f) {
        f.setWorkingArea(this);
        CControlAccess cControlAccess = this.control();
        if (cControlAccess != null) {
            cControlAccess.getOwner().addDockable(f);
        }
        return f;
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }
}

