/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CFlapIndexLocation;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.common.location.CLocationExpandStrategy;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.common.location.CMinimizeAreaLocation;
import bibliothek.gui.dock.common.location.CWorkingAreaLocation;
import bibliothek.gui.dock.common.location.DefaultExpandStrategy;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;

public abstract class CLocation {
    public static CBaseLocation base(CContentArea cContentArea) {
        return new CBaseLocation(cContentArea);
    }

    public static CBaseLocation base() {
        return new CBaseLocation();
    }

    public static CWorkingAreaLocation working(CWorkingArea cWorkingArea) {
        return new CWorkingAreaLocation(cWorkingArea);
    }

    public static CMinimizeAreaLocation minimized(CMinimizeArea cMinimizeArea) {
        return new CMinimizeAreaLocation(cMinimizeArea);
    }

    public static CFlapIndexLocation minimized(CMinimizeArea cMinimizeArea, int n) {
        return new CMinimizeAreaLocation(cMinimizeArea).insert(n);
    }

    public static CGridAreaLocation normalized(CGridArea cGridArea) {
        return new CGridAreaLocation(cGridArea);
    }

    public static CMaximizedLocation maximized() {
        return new CMaximizedLocation();
    }

    public static CMaximizedLocation maximized(CGridArea cGridArea) {
        return new CMaximizedLocation(cGridArea.getUniqueId());
    }

    public static CMaximizedLocation maximized(CContentArea cContentArea) {
        return new CMaximizedLocation(cContentArea.getCenterIdentifier());
    }

    public abstract CLocation getParent();

    public abstract String findRoot();

    public abstract ExtendedMode findMode();

    public DockableProperty findProperty() {
        return this.findProperty(null);
    }

    public abstract DockableProperty findProperty(DockableProperty var1);

    public final CLocation expandProperty(DockController dockController, DockableProperty dockableProperty) {
        return this.expandProperty(dockableProperty, new DefaultExpandStrategy(dockController));
    }

    public CLocation expandProperty(DockableProperty dockableProperty, CLocationExpandStrategy cLocationExpandStrategy) {
        CLocation cLocation = cLocationExpandStrategy.expand(this, dockableProperty);
        if (cLocation == null) {
            return null;
        }
        if ((dockableProperty = dockableProperty.getSuccessor()) == null) {
            return cLocation;
        }
        return cLocation.expandProperty(dockableProperty, cLocationExpandStrategy);
    }

    @Deprecated
    public abstract CLocation aside();

    public boolean equals(Object object) {
        if (object instanceof CLocation) {
            CLocation cLocation = (CLocation)object;
            return this.equals(this.findRoot(), cLocation.findRoot()) && this.equals(this.findMode(), cLocation.findMode()) && this.equals(this.findProperty(), cLocation.findProperty());
        }
        return false;
    }

    private boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        return object != null && object.equals(object2);
    }

    public int hashCode() {
        String string = this.findRoot();
        ExtendedMode extendedMode = this.findMode();
        DockableProperty dockableProperty = this.findProperty();
        int n = 0;
        if (string != null) {
            n = string.hashCode();
        }
        n *= 31;
        if (extendedMode != null) {
            n += ((Object)extendedMode).hashCode();
        }
        n *= 31;
        if (dockableProperty != null) {
            n += dockableProperty.hashCode();
        }
        return n;
    }
}

