/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.AbstractDockableCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.station.CSplitDockStationHandle;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Path;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CGridArea
extends AbstractDockableCStation<CSplitDockStation>
implements SingleCDockable {
    public static final Path TYPE_ID = new Path("dock", "CGridArea");
    private String uniqueId;
    private CSplitDockStation station;
    private SplitResizeRequestHandler resizeRequestHandler;
    private CSplitDockStationHandle modeManagerHandle;
    private boolean maximizing = false;

    public CGridArea(CControl cControl, String string) {
        this.init(cControl, string);
    }

    protected CGridArea() {
    }

    protected void init(CControl cControl, String string) {
        if (string == null) {
            throw new NullPointerException("id must not be null");
        }
        this.uniqueId = string;
        CommonDockStation<SplitDockStation, CSplitDockStation> commonDockStation = cControl.getFactory().createSplitDockStation(new Delegate());
        this.station = commonDockStation.asDockStation();
        this.init(commonDockStation.asDockable());
        this.setTitleShown(false);
        this.station.setExpandOnDoubleclick(false);
        this.resizeRequestHandler = new SplitResizeRequestHandler(this.station);
        this.setMaximizingArea(true);
        this.modeManagerHandle = this.createSplitDockStationHandle(cControl);
    }

    protected CSplitDockStationHandle createSplitDockStationHandle(CControl cControl) {
        return new CSplitDockStationHandle(this, cControl.getLocationManager());
    }

    @Override
    protected CommonDockable createCommonDockable() {
        throw new IllegalStateException("the common-dockable gets already initialized by the constructor");
    }

    public void deploy(CGrid cGrid) {
        this.station.dropTree(cGrid.toTree());
    }

    @Override
    public CSplitDockStation getStation() {
        return this.station;
    }

    @Override
    public CDockable asDockable() {
        return this;
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CGridPerspective(this.getUniqueId(), this.getTypeId(), this.isWorkingArea());
    }

    public JComponent getComponent() {
        return this.station;
    }

    @Override
    public CLocation getStationLocation() {
        return new CGridAreaLocation(this);
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }

    public void setTitleText(String string) {
        this.station.setTitleText(string);
    }

    public String getTitleText() {
        return this.station.getTitleText();
    }

    public void setTitleIcon(Icon icon) {
        this.station.setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.station.getTitleIcon();
    }

    public void setMaximizingArea(boolean bl) {
        if (bl != this.maximizing) {
            this.maximizing = bl;
            CControl cControl = this.getControl();
            if (cControl != null) {
                CMaximizedMode cMaximizedMode = cControl.getLocationManager().getMaximizedMode();
                if (this.maximizing) {
                    cMaximizedMode.add(this.modeManagerHandle.asMaximziedModeArea());
                } else {
                    cMaximizedMode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
                }
            }
        }
    }

    public boolean isMaximizingArea() {
        return this.maximizing;
    }

    protected boolean isNormalizingArea() {
        return true;
    }

    protected CSplitDockStationHandle getModeManagerHandle() {
        return this.modeManagerHandle;
    }

    @Override
    protected void install(CControlAccess cControlAccess) {
        if (this.isNormalizingArea()) {
            cControlAccess.getLocationManager().getNormalMode().add(this.modeManagerHandle.asNormalModeArea());
            cControlAccess.getOwner().addResizeRequestListener(this.resizeRequestHandler);
        }
        if (this.isMaximizingArea()) {
            CMaximizedMode cMaximizedMode = cControlAccess.getLocationManager().getMaximizedMode();
            cMaximizedMode.add(this.modeManagerHandle.asMaximziedModeArea());
        }
    }

    @Override
    protected void uninstall(CControlAccess cControlAccess) {
        if (this.isNormalizingArea()) {
            cControlAccess.getLocationManager().getNormalMode().remove(this.modeManagerHandle.asNormalModeArea().getUniqueId());
            cControlAccess.getOwner().removeResizeRequestListener(this.resizeRequestHandler);
        }
        if (this.isMaximizingArea()) {
            CMaximizedMode cMaximizedMode = cControlAccess.getLocationManager().getMaximizedMode();
            cMaximizedMode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
        }
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean isExternalizable() {
        return false;
    }

    @Override
    public boolean isMaximizable() {
        return false;
    }

    @Override
    public boolean isMinimizable() {
        return false;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    protected boolean suppressTitle(DockTitleVersion dockTitleVersion) {
        if (!this.isTitleShown()) {
            if (dockTitleVersion.getID().equals("split")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("flap window")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("stack")) {
                return true;
            }
        }
        return false;
    }

    private class Delegate
    implements CommonStationDelegate<CSplitDockStation> {
        private Delegate() {
        }

        @Override
        public CDockable getDockable() {
            return CGridArea.this;
        }

        @Override
        public DockActionSource[] getSources() {
            return new DockActionSource[]{CGridArea.this.getClose()};
        }

        @Override
        public CStation<CSplitDockStation> getStation() {
            return CGridArea.this;
        }

        @Override
        public boolean isTitleDisplayed(DockTitleVersion dockTitleVersion) {
            return !CGridArea.this.suppressTitle(dockTitleVersion);
        }
    }
}

