/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CPlaceholderStrategy;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockGrid;
import bibliothek.util.Path;

public class CGrid {
    private SplitDockGrid grid = new SplitDockGrid();
    private CControl control;

    @Deprecated
    public CGrid() {
    }

    public CGrid(CControl cControl) {
        this.control = cControl;
    }

    public DockableSplitDockTree toTree() {
        return this.grid.toTree();
    }

    public void add(double d, double d2, double d3, double d4, CDockable ... cDockableArray) {
        Dockable[] dockableArray = new Dockable[cDockableArray.length];
        int n = 0;
        while (n < dockableArray.length) {
            CDockable cDockable = cDockableArray[n];
            if (this.control != null) {
                if (cDockable instanceof SingleCDockable) {
                    this.control.addDockable((SingleCDockable)cDockable);
                } else if (cDockable instanceof MultipleCDockable && cDockable.getControl() == null) {
                    this.control.addDockable((MultipleCDockable)cDockable);
                }
            }
            dockableArray[n] = cDockable.intern();
            ++n;
        }
        this.grid.addDockable(d, d2, d3, d4, dockableArray);
    }

    public void addSingle(double d, double d2, double d3, double d4, String ... stringArray) {
        if (this.control == null) {
            throw new IllegalStateException("This method is only available if the CGrid was constructed with a CControl");
        }
        Path[] pathArray = new Path[stringArray.length];
        int n = 0;
        while (n < pathArray.length) {
            pathArray[n] = CPlaceholderStrategy.getSingleDockablePlaceholder(this.control.getRegister().toSingleId(stringArray[n]));
            ++n;
        }
    }

    public void addMulti(double d, double d2, double d3, double d4, String ... stringArray) {
        if (this.control == null) {
            throw new IllegalStateException("This method is only available if the CGrid was constructed with a CControl");
        }
        Path[] pathArray = new Path[stringArray.length];
        int n = 0;
        while (n < pathArray.length) {
            pathArray[n] = CPlaceholderStrategy.getMultipleDockablePlaceholder(this.control.getRegister().toMultiId(stringArray[n]));
            ++n;
        }
    }

    public void addPlaceholders(double d, double d2, double d3, double d4, Path ... pathArray) {
        this.grid.addPlaceholders(d, d2, d3, d4, pathArray);
    }

    public void select(double d, double d2, double d3, double d4, CDockable cDockable) {
        this.grid.setSelected(d, d2, d3, d4, cDockable.intern());
    }

    public void addHorizontalDivider(double d, double d2, double d3) {
        this.grid.addHorizontalDivider(d, d2, d3);
    }

    public void addVerticalDivider(double d, double d2, double d3) {
        this.grid.addVerticalDivider(d, d2, d3);
    }
}

