/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControlRegister;
import bibliothek.gui.dock.common.CFocusHistory;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.DefaultCFocusHistory;
import bibliothek.gui.dock.common.DestroyHook;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.NullMultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CloseActionFactory;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.event.CVetoFocusListener;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.grouping.CGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DefaultCGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.common.grouping.GroupingDockLocationListener;
import bibliothek.gui.dock.common.grouping.GroupingHistoryRewriter;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CControlFactory;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CListenerCollection;
import bibliothek.gui.dock.common.intern.CPlaceholderStrategy;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.ControlVetoClosingListener;
import bibliothek.gui.dock.common.intern.ControlVetoFocusListener;
import bibliothek.gui.dock.common.intern.EfficientControlFactory;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.common.intern.action.CActionImportanceOrder;
import bibliothek.gui.dock.common.intern.action.CActionOffer;
import bibliothek.gui.dock.common.intern.action.CButtonContentFilter;
import bibliothek.gui.dock.common.intern.station.CFlapLayoutManager;
import bibliothek.gui.dock.common.intern.station.CLockedResizeLayoutManager;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStationFactory;
import bibliothek.gui.dock.common.intern.ui.CDisablingStrategy;
import bibliothek.gui.dock.common.intern.ui.CSingleParentRemover;
import bibliothek.gui.dock.common.intern.ui.CommonSingleTabDecider;
import bibliothek.gui.dock.common.intern.ui.ExtendedModeAcceptance;
import bibliothek.gui.dock.common.intern.ui.StackableAcceptance;
import bibliothek.gui.dock.common.intern.ui.WorkingAreaAcceptance;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CStationContainerHistoryRewriter;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CControlPerspective;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CStackPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.theme.ThemeMap;
import bibliothek.gui.dock.common.theme.eclipse.CommonEclipseThemeConnector;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.DefaultFocusStrategy;
import bibliothek.gui.dock.control.focus.FocusStrategyRequest;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.frontend.FrontendEntry;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockStationLayout;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.gui.dock.support.util.ApplicationResourceManager;
import bibliothek.gui.dock.themes.basic.action.DockActionImportanceOrder;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.NullWindowProvider;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.icon.DefaultIconScheme;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.text.DefaultTextScheme;
import bibliothek.util.Filter;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XIO;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class CControl {
    public static final PropertyKey<CControl> CCONTROL = new PropertyKey("ccontrol");
    public static final PropertyKey<KeyStroke> KEY_MAXIMIZE_CHANGE = new PropertyKey("ccontrol.maximize_change");
    public static final PropertyKey<KeyStroke> KEY_GOTO_MAXIMIZED = new PropertyKey("ccontrol.goto_maximized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_NORMALIZED = new PropertyKey("ccontrol.goto_normalized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_MINIMIZED = new PropertyKey("ccontrol.goto_minimized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_EXTERNALIZED = new PropertyKey("ccontrol.goto_externalized");
    public static final PropertyKey<KeyStroke> KEY_CLOSE = new PropertyKey("ccontrol.close");
    public static final PropertyKey<ConflictResolver<RequestDimension>> RESIZE_LOCK_CONFLICT_RESOLVER = new PropertyKey("ccontrol.resize_lock_conflict_resolver", new ConstantPropertyFactory(new DefaultConflictResolver()), true);
    public static final PropertyKey<CloseActionFactory> CLOSE_ACTION_FACTORY = new PropertyKey<CloseActionFactory>("ccontrol.closeActionFactory", new ConstantPropertyFactory<CloseActionFactory>(CloseActionFactory.DEFAULT), true);
    public static final PropertyKey<CGroupingBehavior> GROUPING_BEHAVIOR = new PropertyKey<DefaultCGroupingBehavior>("ccontrol.groupingBehavior", new ConstantPropertyFactory<DefaultCGroupingBehavior>(new DefaultCGroupingBehavior()), true);
    public static final String EXTERNALIZED_STATION_ID = "external";
    public static final String CONTENT_AREA_STATIONS_ID = "ccontrol";
    private CDockFrontend frontend;
    private Map<CDockable, CDockableAccess> accesses = new HashMap<CDockable, CDockableAccess>();
    private CLocationModeManager locationManager;
    private CLocation defaultLocation;
    private ThemeMap themes;
    private CControlAccess access = new Access();
    private ApplicationResourceManager resources = new ApplicationResourceManager();
    private List<DestroyHook> hooks = new ArrayList<DestroyHook>();
    private CControlFactory factory;
    private MutableCControlRegister register;
    private List<CControlListener> listeners = new ArrayList<CControlListener>();
    private List<ResizeRequestListener> resizeListeners = new ArrayList<ResizeRequestListener>();
    private CListenerCollection listenerCollection = new CListenerCollection();
    private boolean transferFocusOnMinimize = true;

    public CControl() {
        this(new NullWindowProvider());
    }

    public CControl(JFrame jFrame) {
        this(jFrame == null ? new NullWindowProvider() : new DirectWindowProvider(jFrame));
    }

    @Deprecated
    public CControl(boolean bl) {
        this(new NullWindowProvider());
        this.getController().setRestrictedEnvironment(bl);
    }

    public CControl(WindowProvider windowProvider) {
        this(windowProvider, (CControlFactory)new EfficientControlFactory());
    }

    @Deprecated
    public CControl(JFrame jFrame, boolean bl) {
        this(jFrame == null ? new NullWindowProvider() : new DirectWindowProvider(jFrame));
        this.getController().setRestrictedEnvironment(bl);
    }

    @Deprecated
    public CControl(WindowProvider windowProvider, boolean bl) {
        this(windowProvider);
        this.getController().setRestrictedEnvironment(bl);
    }

    public CControl(JFrame jFrame, CControlFactory cControlFactory) {
        this(jFrame == null ? new NullWindowProvider() : new DirectWindowProvider(jFrame), cControlFactory);
    }

    public CControl(WindowProvider windowProvider, CControlFactory cControlFactory) {
        this(windowProvider, cControlFactory, true);
    }

    protected CControl(WindowProvider windowProvider, CControlFactory cControlFactory, boolean bl) {
        if (bl) {
            this.init(windowProvider, cControlFactory);
        }
    }

    protected void init(WindowProvider windowProvider, CControlFactory cControlFactory) {
        if (windowProvider == null) {
            throw new IllegalArgumentException("window must not be null, however its search method may return null");
        }
        this.factory = cControlFactory;
        this.register = cControlFactory.createRegister(this);
        DockController dockController = cControlFactory.createController(this);
        dockController.getProperties().set(CCONTROL, this, Priority.CLIENT);
        dockController.getProperties().finalize(CCONTROL);
        dockController.setSingleParentRemover(new CSingleParentRemover(this));
        this.initFocusListeners(dockController);
        this.initInputListener(dockController);
        this.initTransferFocusOnMinimize(dockController);
        this.frontend = cControlFactory.createFrontend(this.access, dockController);
        this.frontend.setOwner(windowProvider);
        this.setIgnoreWorkingForEntry(true);
        this.frontend.setShowHideAction(false);
        this.frontend.getController().addActionOffer(new CActionOffer(this));
        this.frontend.getController().getRegister().addDockRegisterListener(new DockRegisterAdapter(){

            @Override
            public void dockableRegistered(DockController dockController, Dockable dockable) {
                if (dockable instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.informVisibility(true);
                    }
                    CControlListener[] cControlListenerArray = CControl.this.listeners();
                    int n = cControlListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CControlListener cControlListener = cControlListenerArray[n2];
                        cControlListener.opened(CControl.this, cDockable);
                        ++n2;
                    }
                }
            }

            @Override
            public void dockableUnregistered(DockController dockController, Dockable dockable) {
                if (dockable instanceof CommonDockable) {
                    Object object;
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.informVisibility(false);
                    }
                    CControlListener[] cControlListenerArray = CControl.this.listeners();
                    int n = cControlListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = cControlListenerArray[n2];
                        object.closed(CControl.this, cDockable);
                        ++n2;
                    }
                    if (cDockable instanceof MultipleCDockable && (object = (MultipleCDockable)cDockable).isRemoveOnClose()) {
                        CControl.this.removeDockable((MultipleCDockable)object);
                    }
                }
            }
        });
        this.frontend.getController().getFocusController().addVetoListener(new ControlVetoFocusListener(this, this.listenerCollection.getVetoFocusListener()));
        this.frontend.getController().getFocusController().setStrategy(new DefaultFocusStrategy(this.frontend.getController()){

            @Override
            public Component getFocusComponent(FocusStrategyRequest focusStrategyRequest) {
                Component component;
                Component component2 = focusStrategyRequest.getMouseClicked();
                Dockable dockable = focusStrategyRequest.getDockable();
                if (component2 != null && (component2.isFocusable() && !this.excluded(component2, focusStrategyRequest) || this.focusable(component2, focusStrategyRequest))) {
                    return component2;
                }
                if (dockable instanceof CommonDockable && (component = ((CommonDockable)dockable).getDockable().getFocusComponent()) != null) {
                    return component;
                }
                return super.getFocusComponent(focusStrategyRequest);
            }
        });
        this.frontend.addVetoableListener(new ControlVetoClosingListener(this, this.listenerCollection.getVetoClosingListener()));
        this.frontend.getController().addAcceptance(new StackableAcceptance());
        this.frontend.getController().addAcceptance(new WorkingAreaAcceptance(this.access));
        this.frontend.getController().addAcceptance(new ExtendedModeAcceptance(this.access));
        this.initFactories();
        this.themes = new ThemeMap(this);
        this.initPersistentStorage();
        this.initExtendedModes();
        this.initProperties();
        this.initIcons();
        this.initTexts();
        this.setTheme("smooth");
    }

    private void initFocusListeners(DockController dockController) {
        dockController.addDockableFocusListener(new DockableFocusListener(){

            @Override
            public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
                CDockableAccess cDockableAccess;
                CDockable cDockable;
                Dockable dockable = dockableFocusEvent.getOldFocusOwner();
                Dockable dockable2 = dockableFocusEvent.getNewFocusOwner();
                if (dockable != null && dockable instanceof CommonDockable) {
                    cDockable = ((CommonDockable)dockable).getDockable();
                    cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.getFocusListener().focusLost(cDockable);
                    }
                    CControl.this.listenerCollection.getFocusListener().focusLost(cDockable);
                }
                if (dockable2 != null && dockable2 instanceof CommonDockable) {
                    cDockable = ((CommonDockable)dockable2).getDockable();
                    cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.getFocusListener().focusGained(cDockable);
                    }
                    CControl.this.listenerCollection.getFocusListener().focusGained(cDockable);
                }
            }
        });
    }

    protected void initTransferFocusOnMinimize(DockController dockController) {
        this.addStateListener(new CDockableAdapter(){

            @Override
            public void extendedModeChanged(CDockable cDockable, ExtendedMode extendedMode) {
                if (CControl.this.transferFocusOnMinimize && extendedMode == ExtendedMode.MINIMIZED) {
                    Dockable[] dockableArray = CControl.this.getController().getFocusHistory().getHistory();
                    int n = dockableArray.length - 1;
                    while (n >= 0) {
                        CDockable cDockable2;
                        Dockable dockable = dockableArray[n];
                        if (dockable instanceof CommonDockable && (cDockable2 = ((CommonDockable)dockable).getDockable()).getExtendedMode() != ExtendedMode.MINIMIZED) {
                            CControl.this.getController().setFocusedDockable(cDockable2.intern(), true);
                            break;
                        }
                        --n;
                    }
                }
            }
        });
    }

    private void initInputListener(DockController dockController) {
        dockController.getKeyboardController().addListener(new KeyboardListener(){

            @Override
            public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
                if (dockElement instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getKeyboardListener().keyPressed(cDockable, keyEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyPressed(cDockable, keyEvent);
                }
                return false;
            }

            @Override
            public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
                if (dockElement instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getKeyboardListener().keyReleased(cDockable, keyEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyReleased(cDockable, keyEvent);
                }
                return false;
            }

            @Override
            public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
                if (dockElement instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getKeyboardListener().keyTyped(cDockable, keyEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyTyped(cDockable, keyEvent);
                }
                return false;
            }

            @Override
            public DockElement getTreeLocation() {
                return null;
            }
        });
        dockController.getDoubleClickController().addListener(new DoubleClickListener(){

            @Override
            public boolean process(Dockable dockable, MouseEvent mouseEvent) {
                if (dockable instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getDoubleClickListener().clicked(cDockable, mouseEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getDoubleClickListener().clicked(cDockable, mouseEvent);
                }
                return false;
            }

            @Override
            public DockElement getTreeLocation() {
                return null;
            }
        });
    }

    private void initExtendedModes() {
        this.locationManager = new CLocationModeManager(this.access);
        CStationContainerHistoryRewriter cStationContainerHistoryRewriter = new CStationContainerHistoryRewriter(this);
        this.locationManager.setHistoryRewriter(new GroupingHistoryRewriter(this, cStationContainerHistoryRewriter));
        GroupingDockLocationListener groupingDockLocationListener = new GroupingDockLocationListener(this);
        this.getController().getRegister().addDockRegisterListener(groupingDockLocationListener);
        this.getController().addDockableFocusListener(groupingDockLocationListener);
    }

    protected void initFactories() {
        CommonSingleDockableFactory commonSingleDockableFactory = this.register.getBackupFactory();
        this.frontend.registerFactory(commonSingleDockableFactory);
        this.frontend.registerBackupFactory(commonSingleDockableFactory);
        this.frontend.registerFactory(new StackDockStationFactory(){

            @Override
            public StackDockPerspective layoutPerspective(StackDockStationLayout stackDockStationLayout, Map<Integer, PerspectiveDockable> map) {
                CStackPerspective cStackPerspective = new CStackPerspective();
                this.layoutPerspective(cStackPerspective, stackDockStationLayout, map);
                return cStackPerspective;
            }
        });
        CommonDockStationFactory commonDockStationFactory = new CommonDockStationFactory(this, null, commonSingleDockableFactory);
        this.frontend.registerFactory(commonDockStationFactory);
        this.frontend.registerBackupFactory(commonDockStationFactory);
    }

    protected void initProperties() {
        this.putProperty(KEY_MAXIMIZE_CHANGE, KeyStroke.getKeyStroke(77, 2));
        this.putProperty(KEY_GOTO_EXTERNALIZED, KeyStroke.getKeyStroke(69, 2));
        this.putProperty(KEY_GOTO_NORMALIZED, KeyStroke.getKeyStroke(78, 2));
        this.putProperty(KEY_CLOSE, KeyStroke.getKeyStroke(115, 2));
        this.putProperty(SplitDockStation.LAYOUT_MANAGER, new CLockedResizeLayoutManager(this));
        this.putProperty(FlapDockStation.LAYOUT_MANAGER, new CFlapLayoutManager());
        this.putProperty(EclipseTheme.THEME_CONNECTOR, new CommonEclipseThemeConnector(this));
        this.putProperty(SingleTabDecider.SINGLE_TAB_DECIDER, new CommonSingleTabDecider(this));
        this.putProperty(PlaceholderStrategy.PLACEHOLDER_STRATEGY, new CPlaceholderStrategy(this));
        this.putProperty(DockActionImportanceOrder.ORDER, new CActionImportanceOrder());
        this.putProperty(DockAction.BUTTON_CONTENT_FILTER, new CButtonContentFilter());
        this.putProperty(DisablingStrategy.STRATEGY, new CDisablingStrategy(this));
    }

    protected void initIcons() {
        DefaultIconScheme defaultIconScheme = new DefaultIconScheme(this.getController(), new DefaultIconScheme.IconResource("data/bibliothek/gui/dock/core/icons.ini", null, DockController.class.getClassLoader()), new DefaultIconScheme.IconResource("data/bibliothek/gui/dock/common/icons/icons.ini", null, CControl.class.getClassLoader()));
        defaultIconScheme.link(PropertyKey.DOCKABLE_ICON, "dockable.default");
        defaultIconScheme.link(PropertyKey.DOCK_STATION_ICON, "dockStation.default");
        this.getController().getIcons().setScheme(Priority.DEFAULT, defaultIconScheme);
    }

    protected void initTexts() {
        Locale locale = Locale.getDefault();
        String string = System.getProperty("asaf.language");
        if (string != null) {
            int n = string.indexOf(95);
            locale = n > 0 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string);
        }
        this.initTexts(locale);
    }

    public void setLanguage(Locale locale) {
        this.initTexts(locale);
    }

    protected void initTexts(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("data.bibliothek.gui.dock.core.locale.text", locale, DockController.class.getClassLoader());
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("data.bibliothek.gui.dock.common.locale.common", locale, CControl.class.getClassLoader());
        this.getController().getTexts().setScheme(Priority.DEFAULT, new DefaultTextScheme(resourceBundle, resourceBundle2));
    }

    protected void initPersistentStorage() {
        try {
            this.addMultipleDockableFactory("", NullMultipleCDockableFactory.NULL, false);
            this.resources.put("ccontrol.frontend", new ApplicationResource(){

                @Override
                public void write(DataOutputStream dataOutputStream) throws IOException {
                    Version.write(dataOutputStream, Version.VERSION_1_1_1);
                    CControl.this.frontend.write(dataOutputStream);
                }

                @Override
                public void read(DataInputStream dataInputStream) throws IOException {
                    Version version = Version.read(dataInputStream);
                    version.checkCurrent();
                    if (Version.VERSION_1_1_1.compareTo(version) > 0 && Version.VERSION_1_0_4.compareTo(version) <= 0) {
                        CControl.this.readWorkingAreas(dataInputStream);
                    }
                    CControl.this.frontend.read(dataInputStream);
                }

                @Override
                public void writeXML(XElement xElement) {
                    CControl.this.frontend.writeXML(xElement.addElement("frontend"));
                }

                @Override
                public void readXML(XElement xElement) {
                    CControl.this.frontend.readXML(xElement.getElement("frontend"));
                }
            });
        }
        catch (IOException iOException) {
            System.err.println("Non lethal IO-error:");
            iOException.printStackTrace();
        }
    }

    public void addControlListener(CControlListener cControlListener) {
        if (cControlListener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.listeners.add(cControlListener);
    }

    public void removeControlListener(CControlListener cControlListener) {
        this.listeners.remove(cControlListener);
    }

    public void addFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.addFocusListener(cFocusListener);
    }

    public void removeFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.removeFocusListener(cFocusListener);
    }

    public CDockable getFocusedCDockable() {
        Dockable dockable = this.getController().getFocusedDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }

    public CFocusHistory getFocusHistory() {
        return new DefaultCFocusHistory(this);
    }

    public void addVetoFocusListener(CVetoFocusListener cVetoFocusListener) {
        this.listenerCollection.addVetoFocusListener(cVetoFocusListener);
    }

    public void removeVetoFocusListener(CVetoFocusListener cVetoFocusListener) {
        this.listenerCollection.removeVetoFocusListener(cVetoFocusListener);
    }

    public void addStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.addCDockableStateListener(cDockableStateListener);
    }

    public void removeStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.removeCDockableStateListener(cDockableStateListener);
    }

    public void addPropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.addCDockablePropertyListener(cDockablePropertyListener);
    }

    public void removePropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.removeCDockablePropertyListener(cDockablePropertyListener);
    }

    public void addKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.addKeyboardListener(cKeyboardListener);
    }

    public void removeKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.removeKeyboardListener(cKeyboardListener);
    }

    public void addGlobalKeyListener(KeyListener keyListener) {
        this.intern().getController().getKeyboardController().addGlobalListener(keyListener);
    }

    public void removeGlobalKeyListener(KeyListener keyListener) {
        this.intern().getController().getKeyboardController().removeGlobalListener(keyListener);
    }

    public void addDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.addDoubleClickListener(cDoubleClickListener);
    }

    public void removeDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.removeDoubleClickListener(cDoubleClickListener);
    }

    public void addVetoClosingListener(CVetoClosingListener cVetoClosingListener) {
        this.listenerCollection.addVetoClosingListener(cVetoClosingListener);
    }

    public void removeVetoClosingListener(CVetoClosingListener cVetoClosingListener) {
        this.listenerCollection.removeVetoClosingListener(cVetoClosingListener);
    }

    private CControlListener[] listeners() {
        return this.listeners.toArray(new CControlListener[this.listeners.size()]);
    }

    public void setIgnoreWorkingForEntry(boolean bl) {
        if (bl) {
            this.frontend.setIgnoreForEntry(new DockSituationIgnore(){

                @Override
                public boolean ignoreChildren(DockStation dockStation) {
                    CStation<?> cStation = CControl.this.getStation(dockStation);
                    if (cStation != null) {
                        return cStation.isWorkingArea();
                    }
                    return false;
                }

                @Override
                public boolean ignoreChildren(PerspectiveStation perspectiveStation) {
                    CStationPerspective cStationPerspective;
                    if (perspectiveStation instanceof CommonElementPerspective && (cStationPerspective = ((CommonElementPerspective)((Object)perspectiveStation)).getElement().asStation()) != null) {
                        return cStationPerspective.isWorkingArea();
                    }
                    return false;
                }

                @Override
                public boolean ignoreElement(DockElement dockElement) {
                    CDockable cDockable;
                    return dockElement instanceof CommonDockable && (cDockable = ((CommonDockable)dockElement).getDockable()).getWorkingArea() != null;
                }

                @Override
                public boolean ignoreElement(PerspectiveElement perspectiveElement) {
                    CDockablePerspective cDockablePerspective;
                    if (perspectiveElement instanceof CommonElementPerspective && (cDockablePerspective = ((CommonElementPerspective)perspectiveElement).getElement().asDockable()) != null) {
                        return cDockablePerspective.getWorkingArea() != null;
                    }
                    return false;
                }
            });
        } else {
            this.frontend.setIgnoreForEntry(null);
        }
    }

    private void readWorkingAreas(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        int n2 = dataInputStream.readInt();
        while (n < n2) {
            dataInputStream.readUTF();
            dataInputStream.readUTF();
            ++n;
        }
    }

    public void destroy() {
        this.frontend.kill();
        for (DestroyHook destroyHook : this.hooks) {
            destroyHook.destroy();
        }
    }

    public CWorkingArea createWorkingArea(String string) {
        CWorkingArea cWorkingArea = new CWorkingArea(this, string);
        this.addDockable((MultipleCDockable)((Object)cWorkingArea));
        this.addStation(cWorkingArea, true);
        return cWorkingArea;
    }

    public CMinimizeArea createMinimizeArea(String string) {
        CMinimizeArea cMinimizeArea = new CMinimizeArea(this, string);
        this.addStation(cMinimizeArea, true);
        return cMinimizeArea;
    }

    public CGridArea createGridArea(String string) {
        CGridArea cGridArea = new CGridArea(this, string);
        this.addStation(cGridArea, true);
        if (this.frontend.getDefaultStation() == null) {
            this.frontend.setDefaultStation(cGridArea.getStation());
        }
        return cGridArea;
    }

    public CContentArea createContentArea(String string) {
        return this.createContentArea(string, false);
    }

    private CContentArea createContentArea(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        if (!bl && string.equals(CONTENT_AREA_STATIONS_ID)) {
            throw new IllegalArgumentException("the unique identifier '" + string + "' is reserved for the default CContentArea and may not be used by the client");
        }
        CContentArea cContentArea = new CContentArea(this, string);
        if (bl) {
            this.register.setDefaultContentArea(cContentArea);
        }
        this.addStationContainer(cContentArea);
        return cContentArea;
    }

    public void addStationContainer(CStationContainer cStationContainer) {
        CStation<?> cStation;
        if (cStationContainer == null) {
            throw new NullPointerException("container is null");
        }
        this.checkValidUniqueId(cStationContainer.getUniqueId());
        DockStation dockStation = this.frontend.getDefaultStation();
        boolean bl = dockStation == null;
        this.register.addStationContainer(cStationContainer);
        if (bl && (cStation = cStationContainer.getDefaultStation()) != null) {
            this.frontend.setDefaultStation((DockStation)cStation.getStation());
        }
    }

    @Deprecated
    public void removeContentArea(CContentArea cContentArea) {
        this.removeStationContainer(cContentArea);
    }

    public void removeStationContainer(CStationContainer cStationContainer) {
        if (cStationContainer == null) {
            throw new NullPointerException("container must not be null");
        }
        if (this.register.getDefaultContentArea() == cStationContainer) {
            throw new IllegalArgumentException("The default-contentarea can't be removed");
        }
        this.register.removeStationContainer(cStationContainer);
    }

    public CControlRegister getRegister() {
        return this.register;
    }

    public List<CStationContainer> getStationContainers() {
        return this.register.getStationContainers();
    }

    public CControlFactory getFactory() {
        return this.factory;
    }

    public CLocationModeManager getLocationManager() {
        return this.locationManager;
    }

    public void addDestroyHook(DestroyHook destroyHook) {
        if (destroyHook == null) {
            throw new NullPointerException("hook must not be null");
        }
        this.hooks.add(destroyHook);
    }

    public void removeDestroyHook(DestroyHook destroyHook) {
        this.hooks.remove(destroyHook);
    }

    public ApplicationResourceManager getResources() {
        return this.resources;
    }

    public <A> void putProperty(PropertyKey<A> propertyKey, A a) {
        this.putProperty(propertyKey, a, Priority.CLIENT);
    }

    protected <A> void putProperty(PropertyKey<A> propertyKey, A a, Priority priority) {
        this.frontend.getController().getProperties().set(propertyKey, a, priority);
    }

    public <A> A getProperty(PropertyKey<A> propertyKey) {
        return this.frontend.getController().getProperties().get(propertyKey);
    }

    public CContentArea getContentArea() {
        CContentArea cContentArea = this.register.getDefaultContentArea();
        if (cContentArea == null) {
            cContentArea = this.createContentArea(CONTENT_AREA_STATIONS_ID, true);
        }
        return cContentArea;
    }

    public void addStation(CStation<?> cStation) {
        this.addStation(cStation, true);
    }

    public void addStation(CStation<?> cStation, boolean bl) {
        String string = cStation.getUniqueId();
        this.checkValidUniqueId(string);
        this.register.addStation(cStation);
        if (bl) {
            this.frontend.addRoot(string, (DockStation)cStation.getStation());
        }
        cStation.setControlAccess(this.access);
    }

    public boolean isRootStation(CStation<?> cStation) {
        DockStation dockStation = this.frontend.getRoot(cStation.getUniqueId());
        return dockStation == cStation.getStation();
    }

    public void removeStation(CStation<?> cStation) {
        if (this.register.removeStation(cStation)) {
            this.frontend.removeRoot((DockStation)cStation.getStation());
            cStation.setControlAccess(null);
        }
    }

    public List<CStation<?>> getStations() {
        return this.register.getStations();
    }

    public CStation<?> getStation(DockStation dockStation) {
        if (dockStation instanceof CommonDockStation) {
            return ((CommonDockStation)dockStation).getStation();
        }
        return null;
    }

    public CStation<?> findStation(DockStation dockStation) {
        CStation<?> cStation = null;
        while (cStation == null && dockStation != null) {
            cStation = this.getStation(dockStation);
            Dockable dockable = dockStation.asDockable();
            dockStation = dockable == null ? null : dockable.getDockParent();
        }
        return cStation;
    }

    public CStation<?> getStation(String string) {
        for (CStation<?> cStation : this.register.getStations()) {
            if (!cStation.getUniqueId().equals(string)) continue;
            return cStation;
        }
        return null;
    }

    public <S extends SingleCDockable> S addDockable(S s) {
        boolean bl;
        if (s == null) {
            throw new NullPointerException("dockable must not be null");
        }
        this.checkValidUniqueId(s.getUniqueId());
        boolean bl2 = bl = s.getControl() == this;
        if (s.getControl() != null && !bl) {
            throw new IllegalArgumentException("dockable is already part of a control");
        }
        SingleCDockable singleCDockable = this.register.getSingleDockable(s.getUniqueId());
        if (singleCDockable != null) {
            if (singleCDockable == s) {
                return s;
            }
            throw new IllegalArgumentException("unique id '" + s.getUniqueId() + "' already in use for another SingleCDockable");
        }
        if (!bl) {
            s.setControlAccess(this.access);
        }
        String string = this.register.toSingleId(s.getUniqueId());
        this.accesses.get(s).setUniqueId(string);
        this.frontend.addDockable(string, s.intern());
        this.frontend.setHideable(s.intern(), true);
        this.register.addSingleDockable(s);
        CControlListener[] cControlListenerArray = this.listeners();
        int n = cControlListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CControlListener cControlListener = cControlListenerArray[n2];
            cControlListener.added(this, s);
            ++n2;
        }
        return s;
    }

    private void checkValidUniqueId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("unique id is 'null'");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("unique id has length of 0");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("unique id consists of whitespaces only");
        }
    }

    public SingleCDockable getSingleDockable(String string) {
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            if (!singleCDockable.getUniqueId().equals(string)) continue;
            return singleCDockable;
        }
        return null;
    }

    public boolean removeSingleDockable(String string) {
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            if (!singleCDockable.getUniqueId().equals(string)) continue;
            return this.removeDockable(singleCDockable);
        }
        return false;
    }

    public boolean removeDockable(SingleCDockable singleCDockable) {
        if (singleCDockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (singleCDockable.getControl() == this) {
            singleCDockable.setVisible(false);
            this.frontend.remove(singleCDockable.intern());
            this.register.removeSingleDockable(singleCDockable);
            singleCDockable.setControlAccess(null);
            CControlListener[] cControlListenerArray = this.listeners();
            int n = cControlListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CControlListener cControlListener = cControlListenerArray[n2];
                cControlListener.removed(this, singleCDockable);
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void addSingleDockableFactory(String string, SingleCDockableFactory singleCDockableFactory) {
        SingleCDockable singleCDockable;
        this.register.getBackupFactory().add(string, singleCDockableFactory);
        String string2 = this.register.toSingleId(string);
        this.locationManager.addEmpty(string2);
        this.frontend.addEmpty(string2);
        FrontendEntry frontendEntry = this.frontend.getFrontendEntry(string2);
        if (frontendEntry != null && frontendEntry.getDockable() == null && frontendEntry.isShown() && (singleCDockable = singleCDockableFactory.createBackup(string)) != null) {
            this.addDockable((MultipleCDockable)((Object)singleCDockable));
            if (frontendEntry.isShown() || !singleCDockable.isCloseable()) {
                singleCDockable.setVisible(true);
            }
        }
    }

    public void addSingleDockableFactory(Filter<String> filter, SingleCDockableFactory singleCDockableFactory) {
        this.register.getBackupFactory().add(filter, singleCDockableFactory);
        for (FrontendEntry frontendEntry : this.frontend.listFrontendEntries()) {
            SingleCDockable singleCDockable;
            String string;
            if (frontendEntry.getDockable() != null || !frontendEntry.isShown() || !this.register.isSingleId(frontendEntry.getKey()) || !filter.includes(string = this.register.singleToNormalId(frontendEntry.getKey())) || (singleCDockable = singleCDockableFactory.createBackup(string)) == null) continue;
            this.addDockable((MultipleCDockable)((Object)singleCDockable));
            if (!frontendEntry.isShown() && singleCDockable.isCloseable()) continue;
            singleCDockable.setVisible(true);
        }
    }

    public SingleCDockableFactory getSingleDockableFactory(String string) {
        return this.register.getBackupFactory().getFactory(string);
    }

    public void removeSingleDockableFactory(SingleCDockableFactory singleCDockableFactory) {
        this.register.getBackupFactory().remove(singleCDockableFactory);
        for (FrontendEntry frontendEntry : this.frontend.listFrontendEntries()) {
            if (frontendEntry.getDockable() != null || !frontendEntry.isShown() || !this.register.isSingleId(frontendEntry.getKey())) continue;
            this.locationManager.removeEmpty(frontendEntry.getKey());
            this.frontend.removeEmpty(frontendEntry.getKey());
        }
    }

    public void removeSingleDockableFactory(String string) {
        this.register.getBackupFactory().remove(string);
        string = this.register.toSingleId(string);
        this.locationManager.removeEmpty(string);
        this.frontend.removeEmpty(string);
    }

    public <M extends MultipleCDockable> M addDockable(M m) {
        HashSet<String> hashSet = new HashSet<String>();
        MultipleCDockableFactory<?, ?> multipleCDockableFactory = m.getFactory();
        if (multipleCDockableFactory == null) {
            throw new IllegalArgumentException("factory of dockable must not be null");
        }
        String string = this.access.getFactoryId(m.getFactory());
        if (string == null) {
            throw new IllegalStateException("the factory for a MultipleCDockable is not registered: " + m.getFactory());
        }
        for (MultipleCDockable multipleCDockable : this.register.getMultipleDockables()) {
            if (!string.equals(this.access.getFactoryId(multipleCDockable.getFactory()))) continue;
            hashSet.add(this.accesses.get(multipleCDockable).getUniqueId());
        }
        int n = 0;
        Object object = String.valueOf(n) + " " + string;
        while (hashSet.contains(this.register.toMultiId((String)object))) {
            object = String.valueOf(++n) + " " + string;
        }
        return this.addDockable((String)object, m);
    }

    public <M extends MultipleCDockable> M addDockable(String string, M m) {
        if (m == null) {
            throw new NullPointerException("dockable must not be null");
        }
        this.checkValidUniqueId(string);
        String string2 = this.access.getFactoryId(m.getFactory());
        if (string2 == null) {
            throw new IllegalStateException("the factory for a MultipleCDockable is not registered: " + m.getFactory());
        }
        if (m.getControl() != null) {
            throw new IllegalStateException("dockable is already part of a control");
        }
        string = this.register.toMultiId(string);
        for (MultipleCDockable object : this.register.getMultipleDockables()) {
            String string3 = this.accesses.get(object).getUniqueId();
            if (!string.equals(string3)) continue;
            throw new IllegalArgumentException("The unique identifier is already in use: " + string);
        }
        m.setControlAccess(this.access);
        this.accesses.get(m).setUniqueId(string);
        this.frontend.addDockable(string, m.intern());
        this.frontend.setHideable(m.intern(), true);
        this.register.addMultipleDockable(m);
        CControlListener[] cControlListenerArray = this.listeners();
        int n = cControlListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CControlListener cControlListener = cControlListenerArray[n2];
            cControlListener.added(this, m);
            ++n2;
        }
        return m;
    }

    public void replace(MultipleCDockable multipleCDockable, MultipleCDockable multipleCDockable2) {
        boolean bl;
        if (multipleCDockable == null) {
            throw new IllegalArgumentException("old dockable must not be null");
        }
        if (multipleCDockable2 == null) {
            throw new IllegalArgumentException("new dockable must not be null");
        }
        if (multipleCDockable.getControl() != this) {
            throw new IllegalArgumentException("old dockable not registered at this CControl");
        }
        if (multipleCDockable2.getControl() != null) {
            throw new IllegalArgumentException("new dockable alread registered at some CControl");
        }
        String string = this.accesses.get(multipleCDockable).getUniqueId();
        boolean bl2 = this.frontend.isEmpty(string);
        if (!bl2) {
            this.frontend.addEmpty(string);
        }
        if (!(bl = this.locationManager.isEmpty(string))) {
            this.locationManager.addEmpty(string);
        }
        string = this.register.multiToNormalId(string);
        this.removeDockable(multipleCDockable);
        this.addDockable(string, multipleCDockable2);
        if (!bl2) {
            this.frontend.removeEmpty(string);
        }
        if (!bl) {
            this.locationManager.removeEmpty(string);
        }
    }

    public MultipleCDockable getMultipleDockable(String string) {
        string = this.register.toMultiId(string);
        for (MultipleCDockable multipleCDockable : this.register.getMultipleDockables()) {
            if (!this.accesses.get(multipleCDockable).getUniqueId().equals(string)) continue;
            return multipleCDockable;
        }
        return null;
    }

    public String getUniqueId(MultipleCDockable multipleCDockable) {
        CDockableAccess cDockableAccess = this.accesses.get(multipleCDockable);
        if (cDockableAccess == null) {
            return null;
        }
        return this.register.multiToNormalId(cDockableAccess.getUniqueId());
    }

    public void removeDockable(MultipleCDockable multipleCDockable) {
        if (multipleCDockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (multipleCDockable.getControl() == this) {
            multipleCDockable.setVisible(false);
            this.frontend.remove(multipleCDockable.intern());
            this.register.removeMultipleDockable(multipleCDockable);
            multipleCDockable.setControlAccess(null);
            CControlListener[] cControlListenerArray = this.listeners();
            int n = cControlListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CControlListener cControlListener = cControlListenerArray[n2];
                cControlListener.removed(this, multipleCDockable);
                ++n2;
            }
        }
    }

    public int getCDockableCount() {
        return this.register.getDockableCount();
    }

    public CDockable getCDockable(int n) {
        return this.register.getDockable(n);
    }

    public void addMultipleDockableFactory(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        this.addMultipleDockableFactory(string, multipleCDockableFactory, true);
    }

    private void addMultipleDockableFactory(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory, boolean bl) {
        if (bl) {
            this.checkValidUniqueId(string);
        }
        if (multipleCDockableFactory == null) {
            throw new NullPointerException("factory must not be null");
        }
        if (this.register.getCommonMultipleDockableFactory(string) != null) {
            throw new IllegalArgumentException("there is already a factory named " + string);
        }
        if (this.access.getFactoryId(multipleCDockableFactory) != null) {
            throw new IllegalArgumentException("this factory-object is already in use and cannot be added a second time");
        }
        CommonMultipleDockableFactory commonMultipleDockableFactory = new CommonMultipleDockableFactory(string, multipleCDockableFactory, this.access);
        this.register.putCommonMultipleDockableFactory(string, commonMultipleDockableFactory);
        this.frontend.registerFactory(commonMultipleDockableFactory);
    }

    public MultipleCDockableFactory<?, ?> getMultipleDockableFactory(String string) {
        return this.register.getFactory(string);
    }

    public String getFactoryId(MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        return this.access.getFactoryId(multipleCDockableFactory);
    }

    public void removeMultipleDockableFactory(String string) {
        CommonMultipleDockableFactory commonMultipleDockableFactory = this.register.removeCommonMultipleDockableFactory(string);
        if (commonMultipleDockableFactory != null) {
            this.frontend.unregisterFactory(commonMultipleDockableFactory);
            ArrayList<MultipleCDockable> arrayList = new ArrayList<MultipleCDockable>();
            for (MultipleCDockable multipleCDockable : this.register.getMultipleDockables()) {
                if (multipleCDockable.getFactory() != commonMultipleDockableFactory.getFactory()) continue;
                arrayList.add(multipleCDockable);
            }
            for (MultipleCDockable multipleCDockable : arrayList) {
                this.removeDockable(multipleCDockable);
            }
        }
    }

    public void setDefaultLocation(CLocation cLocation) {
        this.defaultLocation = cLocation;
    }

    public CLocation getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setMaximizeArea(String string) {
        CMaximizedMode cMaximizedMode = this.locationManager.getMaximizedMode();
        CMaximizedModeArea cMaximizedModeArea = (CMaximizedModeArea)cMaximizedMode.get(string);
        if (cMaximizedModeArea == null) {
            throw new IllegalArgumentException("No area registered with key '" + string + "'");
        }
        cMaximizedMode.setDefaultArea(cMaximizedModeArea);
    }

    public void setGroupBehavior(CGroupBehavior cGroupBehavior) {
        this.locationManager.setGroupBehavior(cGroupBehavior);
    }

    public CGroupBehavior getGroupBehavior() {
        return this.locationManager.getGroupBehavior();
    }

    @Deprecated
    public void setTheme(DockTheme dockTheme) {
        this.frontend.getController().setTheme(dockTheme);
    }

    public void setTheme(String string) {
        this.themes.select(string);
    }

    public ThemeMap getThemes() {
        return this.themes;
    }

    public CControlPerspective getPerspectives() {
        return new CControlPerspective(this.access);
    }

    public void setRootWindow(WindowProvider windowProvider) {
        this.frontend.setOwner(windowProvider);
    }

    public WindowProvider getRootWindow() {
        return this.frontend.getOwner();
    }

    public void addResizeRequestListener(ResizeRequestListener resizeRequestListener) {
        if (resizeRequestListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.resizeListeners.add(resizeRequestListener);
    }

    public void removeResizeRequestListener(ResizeRequestListener resizeRequestListener) {
        this.resizeListeners.remove(resizeRequestListener);
    }

    public void handleResizeRequests() {
        ResizeRequestListener[] resizeRequestListenerArray;
        ResizeRequestListener[] resizeRequestListenerArray2 = resizeRequestListenerArray = this.resizeListeners.toArray(new ResizeRequestListener[this.resizeListeners.size()]);
        int n = resizeRequestListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResizeRequestListener object = resizeRequestListenerArray2[n2];
            object.handleResizeRequest(this);
            ++n2;
        }
        for (CDockable cDockable : this.register.getDockables()) {
            cDockable.getAndClearResizeRequest();
        }
    }

    public CDockFrontend intern() {
        return this.frontend;
    }

    public DockController getController() {
        return this.intern().getController();
    }

    public IconManager getIcons() {
        return this.getController().getIcons();
    }

    public void setRevertToBasicModes(boolean bl) {
        this.intern().setRevertToBasicModes(bl);
    }

    public boolean isRevertToBasicModes() {
        return this.intern().isRevertToBasicModes();
    }

    public void setTransferFocusOnMinimize(boolean bl) {
        this.transferFocusOnMinimize = bl;
    }

    public boolean isTransferFocusOnMinimize() {
        return this.transferFocusOnMinimize;
    }

    public void write(File file) throws IOException {
        this.getResources().writeFile(file);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.getResources().writeStream(dataOutputStream);
    }

    public void writeXML(XElement xElement) {
        this.getResources().writeXML(xElement);
    }

    public void writeXML(File file) throws IOException {
        XElement xElement = new XElement("root");
        this.getResources().writeXML(xElement);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        XIO.writeUTF(xElement, bufferedOutputStream);
        bufferedOutputStream.close();
    }

    public void read(File file) throws IOException {
        this.getResources().readFile(file);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.getResources().readStream(dataInputStream);
    }

    public void readXML(XElement xElement) {
        this.getResources().readXML(xElement);
    }

    public void readXML(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XElement xElement = XIO.readUTF(bufferedInputStream);
        bufferedInputStream.close();
        this.readXML(xElement);
    }

    public String save() {
        return this.save(false);
    }

    public String save(boolean bl) {
        String string = this.frontend.getCurrentSetting();
        if (string == null) {
            return null;
        }
        this.save(string, bl);
        return string;
    }

    public void save(String string) {
        this.frontend.save(string);
    }

    public void save(String string, boolean bl) {
        this.frontend.save(string, !bl);
    }

    public void load(String string) {
        this.frontend.load(string);
    }

    public void load(String string, boolean bl) {
        this.frontend.load(string, !bl);
    }

    public void delete(String string) {
        this.frontend.delete(string);
    }

    public String[] layouts() {
        Set<String> set = this.frontend.getSettings();
        return set.toArray(new String[set.size()]);
    }

    public String getLayout() {
        return this.frontend.getCurrentSetting();
    }

    private class Access
    implements CControlAccess {
        private DockAction closeAction;

        private Access() {
        }

        @Override
        public CControl getOwner() {
            return CControl.this;
        }

        @Override
        public void link(CDockable cDockable, CDockableAccess cDockableAccess) {
            if (cDockableAccess == null) {
                CDockableAccess cDockableAccess2 = (CDockableAccess)CControl.this.accesses.remove(cDockable);
                if (cDockableAccess2 != null) {
                    cDockableAccess2.setUniqueId(null);
                }
                cDockable.removeCDockablePropertyListener(CControl.this.listenerCollection.getCDockablePropertyListener());
                cDockable.removeCDockableStateListener(CControl.this.listenerCollection.getCDockableStateListener());
            } else if (CControl.this.accesses.put(cDockable, cDockableAccess) == null) {
                cDockable.addCDockablePropertyListener(CControl.this.listenerCollection.getCDockablePropertyListener());
                cDockable.addCDockableStateListener(CControl.this.listenerCollection.getCDockableStateListener());
            }
        }

        @Override
        public CDockableAccess access(CDockable cDockable) {
            return (CDockableAccess)CControl.this.accesses.get(cDockable);
        }

        @Override
        public void hide(CDockable cDockable) {
            if (!cDockable.isVisible()) {
                return;
            }
            DockRegister dockRegister = CControl.this.frontend.getController().getRegister();
            try {
                Object object;
                dockRegister.setStalled(true);
                HashMap<Dockable, ExtendedMode> hashMap = new HashMap<Dockable, ExtendedMode>();
                for (Dockable dockableArray2 : CControl.this.locationManager.listDockables()) {
                    if (dockableArray2 == cDockable.intern() || (object = (CLocationMode)CControl.this.locationManager.getCurrentMode(dockableArray2)) == null || object.isBasicMode()) continue;
                    hashMap.put(dockableArray2, object.getExtendedMode());
                }
                Dockable[] dockableArray = CControl.this.getController().getFocusHistory().getHistory();
                boolean bl = CControl.this.locationManager.ensureBasicModes();
                CControl.this.frontend.hide(cDockable.intern());
                if (bl) {
                    Dockable[] dockableArray2 = dockableArray;
                    int n = dockableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = dockableArray2[n2];
                        ExtendedMode extendedMode = (ExtendedMode)hashMap.get(object);
                        if (extendedMode != null && CControl.this.frontend.isShown((Dockable)object) && CControl.this.locationManager.isModeAvailable((Dockable)object, extendedMode)) {
                            CControl.this.locationManager.setMode((Dockable)object, extendedMode);
                        }
                        ++n2;
                    }
                }
            }
            finally {
                dockRegister.setStalled(false);
            }
        }

        @Override
        public void show(CDockable cDockable) {
            if (cDockable.hasParent()) {
                return;
            }
            DockRegister dockRegister = CControl.this.frontend.getController().getRegister();
            dockRegister.setStalled(true);
            try {
                CStation<?> cStation;
                CLocation cLocation = cDockable.getAutoBaseLocation(true);
                CDockableAccess cDockableAccess = this.access(cDockable);
                if (cDockableAccess != null) {
                    cDockableAccess.internalLocation(true);
                }
                if ((cStation = cDockable.getWorkingArea()) != null && cStation.asDockable() != null && !cStation.asDockable().isVisible()) {
                    throw new IllegalStateException("A dockable that wants to be on a CWorkingArea can't be made visible unless the CWorkingArea is visible.");
                }
                if (cLocation == null) {
                    cDockable.setExtendedMode(this.findInitialMode(cDockable));
                } else {
                    CControl.this.locationManager.setLocation(cDockable.intern(), cLocation);
                }
                if (!CControl.this.frontend.isShown(cDockable.intern())) {
                    CControl.this.frontend.show(cDockable.intern(), false);
                }
                CControl.this.locationManager.ensureValidLocation(cDockable);
            }
            finally {
                dockRegister.setStalled(false);
            }
        }

        private ExtendedMode findInitialMode(CDockable cDockable) {
            CGroupingBehavior cGroupingBehavior = CControl.this.getProperty(GROUPING_BEHAVIOR);
            DockableGrouping dockableGrouping = cGroupingBehavior.getGrouping(cDockable.intern());
            ExtendedMode extendedMode = null;
            if (dockableGrouping != null) {
                extendedMode = dockableGrouping.getInitialMode(cDockable.intern());
            }
            if (extendedMode == null) {
                extendedMode = ExtendedMode.NORMALIZED;
            }
            return extendedMode;
        }

        @Override
        public CLocation getAutoBaseLocation(CDockable cDockable, boolean bl) {
            CDockableAccess cDockableAccess = this.access(cDockable);
            CLocation cLocation = null;
            if (cDockableAccess != null) {
                cLocation = cDockableAccess.internalLocation(false);
            }
            if (cLocation == null) {
                CStation<?> cStation;
                if (CControl.this.frontend.hasLocation(cDockable.intern())) {
                    cStation = CControl.this.frontend.getFrontendEntry(cDockable.intern());
                    String string = cStation.getRoot();
                    DockableProperty dockableProperty = cStation.getLocation();
                    CStation<?> cStation2 = CControl.this.getStation(string);
                    if (cStation2 != null) {
                        if (bl) {
                            return null;
                        }
                        cLocation = cStation2.getStationLocation().expandProperty(CControl.this.getController(), dockableProperty);
                    }
                }
                if (cLocation == null) {
                    cStation = cDockable.getWorkingArea();
                    if (cStation != null) {
                        cLocation = cStation.getStationLocation();
                    }
                    if (cLocation == null) {
                        cLocation = CControl.this.defaultLocation;
                    }
                    if (cLocation == null && !bl) {
                        cLocation = CControl.this.locationManager.getLocation(cDockable.intern(), ExtendedMode.NORMALIZED);
                    }
                }
            }
            return cLocation;
        }

        @Override
        public boolean isVisible(CDockable cDockable) {
            return CControl.this.frontend.isShown(cDockable.intern());
        }

        @Override
        public boolean hasParent(CDockable cDockable) {
            if (CControl.this.frontend.isHiddenRootStation(cDockable.intern())) {
                return false;
            }
            return this.isVisible(cDockable);
        }

        @Override
        public String getFactoryId(MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
            for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : CControl.this.register.getFactories().entrySet()) {
                if (entry.getValue() != multipleCDockableFactory) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public CLocationModeManager getLocationManager() {
            return CControl.this.locationManager;
        }

        @Override
        public DockAction createCloseAction(CDockable cDockable) {
            if (this.closeAction == null) {
                CloseActionFactory closeActionFactory = CControl.this.getController().getProperties().get(CLOSE_ACTION_FACTORY);
                this.closeAction = closeActionFactory.create(CControl.this, cDockable).intern();
            }
            return this.closeAction;
        }

        @Override
        public MutableCControlRegister getRegister() {
            return CControl.this.register;
        }
    }
}

