/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.CStationContainerListener;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CMinimizedLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.util.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;

public class CContentArea
extends JPanel
implements CStationContainer {
    public static final Path TYPE_ID_CENTER = new Path("dock", "CContentArea", "center");
    public static final Path TYPE_ID_MINIMIZE = new Path("dock", "CContentArea", "minimize");
    private CenterStation center;
    private MinimizeStation north;
    private MinimizeStation south;
    private MinimizeStation east;
    private MinimizeStation west;
    private Component[] cornerComponents = new Component[8];
    private String uniqueId;
    private CControl control;
    private CStation<?>[] stations;

    public CContentArea(CControl cControl, String string) {
        this.control = cControl;
        this.uniqueId = string;
        CBaseLocation cBaseLocation = new CBaseLocation(this);
        this.center = new CenterStation(this.getCenterIdentifier(), cBaseLocation.normal());
        this.north = new MinimizeStation(this.getNorthIdentifier(), new CMinimizedLocation(cBaseLocation, Side.NORTH));
        this.south = new MinimizeStation(this.getSouthIdentifier(), new CMinimizedLocation(cBaseLocation, Side.SOUTH));
        this.east = new MinimizeStation(this.getEastIdentifier(), new CMinimizedLocation(cBaseLocation, Side.EAST));
        this.west = new MinimizeStation(this.getWestIdentifier(), new CMinimizedLocation(cBaseLocation, Side.WEST));
        this.center.getStation().setExpandOnDoubleclick(false);
        this.north.setDirection(FlapDockStation.Direction.SOUTH);
        this.south.setDirection(FlapDockStation.Direction.NORTH);
        this.east.setDirection(FlapDockStation.Direction.WEST);
        this.west.setDirection(FlapDockStation.Direction.EAST);
        this.setLayout(new BorderLayout());
        this.add((Component)this.center.getStation(), "Center");
        this.add((Component)this.north, "North");
        this.add((Component)this.south, "South");
        this.add((Component)this.east, "East");
        this.add((Component)this.west, "West");
        this.stations = new CStation[]{this.north, this.south, this.east, this.west, this.center};
    }

    protected void addStations(CStation<?> ... cStationArray) {
        CStation[] cStationArray2 = new CStation[this.stations.length + cStationArray.length];
        System.arraycopy(this.stations, 0, cStationArray2, 0, this.stations.length);
        System.arraycopy(cStationArray, 0, cStationArray2, this.stations.length, cStationArray.length);
        this.stations = cStationArray2;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void addStationContainerListener(CStationContainerListener cStationContainerListener) {
    }

    @Override
    public void removeStationContainerListener(CStationContainerListener cStationContainerListener) {
    }

    public CControl getControl() {
        return this.control;
    }

    public CStation<?>[] getStations() {
        CStation[] cStationArray = new CStation[this.stations.length];
        System.arraycopy(this.stations, 0, cStationArray, 0, this.stations.length);
        return cStationArray;
    }

    @Override
    public int getStationCount() {
        return this.stations.length;
    }

    @Override
    public CStation<?> getStation(int n) {
        return this.stations[n];
    }

    public int indexOf(CStation<?> cStation) {
        int n = 0;
        while (n < this.stations.length) {
            if (this.stations[n] == cStation) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public CStation<?> getDefaultStation() {
        return this.center;
    }

    @Override
    public CStation<?> getDefaultStation(ExtendedMode extendedMode) {
        if (extendedMode == ExtendedMode.MINIMIZED) {
            return this.north;
        }
        if (extendedMode == ExtendedMode.NORMALIZED) {
            return this.center;
        }
        if (extendedMode == ExtendedMode.MAXIMIZED) {
            return this.center;
        }
        return null;
    }

    public void deploy(CGrid cGrid) {
        this.getCenter().dropTree(cGrid.toTree());
    }

    public void setCornerComponent(Component component, Corner corner, boolean bl) {
        int n = corner.ordinal() * 2;
        if (bl) {
            ++n;
        }
        if (this.cornerComponents[n] != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (bl) {
                        this.north.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.west.remove(this.cornerComponents[n]);
                    break;
                }
                case NORTH_EAST: {
                    if (bl) {
                        this.north.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.east.remove(this.cornerComponents[n]);
                    break;
                }
                case SOUTH_WEST: {
                    if (bl) {
                        this.south.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.west.remove(this.cornerComponents[n]);
                    break;
                }
                case SOUTH_EAST: {
                    if (bl) {
                        this.south.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.east.remove(this.cornerComponents[n]);
                }
            }
        }
        this.cornerComponents[n] = component;
        if (component != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (bl) {
                        this.north.add(component, "West");
                        break;
                    }
                    this.west.add(component, "North");
                    break;
                }
                case NORTH_EAST: {
                    if (bl) {
                        this.north.add(component, "East");
                        break;
                    }
                    this.east.add(component, "North");
                    break;
                }
                case SOUTH_WEST: {
                    if (bl) {
                        this.south.add(component, "West");
                        break;
                    }
                    this.west.add(component, "South");
                    break;
                }
                case SOUTH_EAST: {
                    if (bl) {
                        this.south.add(component, "East");
                        break;
                    }
                    this.east.add(component, "South");
                }
            }
        }
    }

    public Component getCornerComponent(Corner corner, boolean bl) {
        int n = corner.ordinal() * 2;
        if (bl) {
            ++n;
        }
        return this.cornerComponents[n];
    }

    public void setMinimumAreaSize(Dimension dimension) {
        this.north.getStation().setMinimumSize(dimension);
        this.south.getStation().setMinimumSize(dimension);
        this.west.getStation().setMinimumSize(dimension);
        this.east.getStation().setMinimumSize(dimension);
    }

    public SplitDockStation getCenter() {
        return this.center.getStation();
    }

    public CGridArea getCenterArea() {
        return this.center;
    }

    public FlapDockStation getNorth() {
        return this.north.getStation();
    }

    public CMinimizeArea getNorthArea() {
        return this.north;
    }

    public FlapDockStation getSouth() {
        return this.south.getStation();
    }

    public CMinimizeArea getSouthArea() {
        return this.south;
    }

    public FlapDockStation getEast() {
        return this.east.getStation();
    }

    public CMinimizeArea getEastArea() {
        return this.east;
    }

    public FlapDockStation getWest() {
        return this.west.getStation();
    }

    public CMinimizeArea getWestArea() {
        return this.west;
    }

    public String getCenterIdentifier() {
        return CContentArea.getCenterIdentifier(this.uniqueId);
    }

    public static String getCenterIdentifier(String string) {
        return String.valueOf(string) + " center";
    }

    public String getNorthIdentifier() {
        return CContentArea.getNorthIdentifier(this.uniqueId);
    }

    public static String getNorthIdentifier(String string) {
        return String.valueOf(string) + " north";
    }

    public String getSouthIdentifier() {
        return CContentArea.getSouthIdentifier(this.uniqueId);
    }

    public static String getSouthIdentifier(String string) {
        return String.valueOf(string) + " south";
    }

    public String getEastIdentifier() {
        return CContentArea.getEastIdentifier(this.uniqueId);
    }

    public static String getEastIdentifier(String string) {
        return String.valueOf(string) + " east";
    }

    public String getWestIdentifier() {
        return CContentArea.getWestIdentifier(this.uniqueId);
    }

    public static String getWestIdentifier(String string) {
        return String.valueOf(string) + " west";
    }

    @Override
    public CStation<?> getMatchingStation(CStationContainer cStationContainer, CStation<?> cStation) {
        int n;
        CContentArea cContentArea;
        if (cStationContainer == this) {
            return cStation;
        }
        if (cStationContainer instanceof CContentArea && (cContentArea = (CContentArea)cStationContainer).getStationCount() == this.getStationCount() && (n = cContentArea.indexOf(cStation)) != -1) {
            return this.getStation(n);
        }
        return null;
    }

    private class CenterStation
    extends CGridArea {
        private CLocation location;

        public CenterStation(String string, CLocation cLocation) {
            super(CContentArea.this.control, string);
            this.location = cLocation;
        }

        @Override
        public Path getTypeId() {
            return TYPE_ID_CENTER;
        }

        @Override
        public CLocation getStationLocation() {
            return this.location;
        }
    }

    public static enum Corner {
        SOUTH_EAST,
        SOUTH_WEST,
        NORTH_EAST,
        NORTH_WEST;

    }

    private class MinimizeStation
    extends CMinimizeArea {
        private CLocation location;

        public MinimizeStation(String string, CLocation cLocation) {
            this.location = cLocation;
            this.init(CContentArea.this.control, string);
        }

        @Override
        public Path getTypeId() {
            return TYPE_ID_MINIMIZE;
        }

        @Override
        public CLocation getStationLocation() {
            return this.location;
        }
    }
}

