/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.view;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.view.ViewItem;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;

public abstract class ConnectingViewItem<A>
implements ViewItem<A> {
    private ViewItem<A> delegate;
    private Dockable dockable;
    private DockController controller;
    private boolean bound = false;
    private DockHierarchyListener listener = new DockHierarchyListener(){

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            ConnectingViewItem.this.check();
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }
    };

    public ConnectingViewItem(Dockable dockable, ViewItem<A> viewItem) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (viewItem == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.dockable = dockable;
        this.delegate = viewItem;
    }

    public void check() {
        DockController dockController;
        DockController dockController2 = dockController = this.bound ? this.dockable.getController() : null;
        if (dockController != this.controller) {
            this.changed(this.controller, dockController);
            this.controller = dockController;
        }
    }

    protected abstract void changed(DockController var1, DockController var2);

    @Override
    public void bind() {
        if (!this.bound) {
            this.bound = true;
            this.dockable.addDockHierarchyListener(this.listener);
            this.check();
        }
        this.delegate.bind();
    }

    @Override
    public DockAction getAction() {
        return this.delegate.getAction();
    }

    @Override
    public A getItem() {
        return this.delegate.getItem();
    }

    @Override
    public void unbind() {
        if (this.bound) {
            this.bound = false;
            this.dockable.removeDockHierarchyListener(this.listener);
            this.check();
        }
        this.delegate.unbind();
    }
}

