/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.popup;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenu;
import bibliothek.gui.dock.action.popup.ActionPopupMenuListener;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultActionPopupMenu
implements ActionPopupMenu {
    private Dockable dockable;
    private JPopupMenu menu;
    private MenuMenuHandler handler;
    private List<ActionPopupMenuListener> listeners = new ArrayList<ActionPopupMenuListener>();
    private boolean showing = false;

    public DefaultActionPopupMenu(Dockable dockable, DockActionSource dockActionSource) {
        this(dockable, dockActionSource, new JPopupMenu());
    }

    public DefaultActionPopupMenu(Dockable dockable, DockActionSource dockActionSource, JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        this.handler = new MenuMenuHandler(dockActionSource, dockable, jPopupMenu);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultActionPopupMenu.this.handler.unbind();
                        DefaultActionPopupMenu.this.showing = false;
                        DefaultActionPopupMenu.this.fireClosed();
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void fireClosed() {
        ActionPopupMenuListener[] actionPopupMenuListenerArray = this.listeners.toArray(new ActionPopupMenuListener[this.listeners.size()]);
        int n = actionPopupMenuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionPopupMenuListener actionPopupMenuListener = actionPopupMenuListenerArray[n2];
            actionPopupMenuListener.closed(this);
            ++n2;
        }
    }

    @Override
    public void addListener(ActionPopupMenuListener actionPopupMenuListener) {
        this.listeners.add(actionPopupMenuListener);
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public void removeListener(ActionPopupMenuListener actionPopupMenuListener) {
        this.listeners.remove(actionPopupMenuListener);
    }

    @Override
    public void show(Component component, int n, int n2) {
        if (!this.isShowing()) {
            this.handler.bind();
            this.menu.show(component, n, n2);
            this.showing = true;
        }
    }

    public boolean isShowing() {
        return this.showing;
    }
}

