/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.dropdown.AbstractDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import java.util.HashSet;
import javax.swing.Icon;

public class DefaultDropDownFilter
extends AbstractDropDownFilter {
    public static final DropDownFilterFactory FACTORY = new DropDownFilterFactory(){

        @Override
        public DropDownFilter createView(DropDownAction dropDownAction, Dockable dockable, DropDownView dropDownView) {
            return new DefaultDropDownFilter(dropDownAction, dockable, dropDownView);
        }
    };

    public DefaultDropDownFilter(DropDownAction dropDownAction, Dockable dockable, DropDownView dropDownView) {
        super(dropDownAction, dockable, dropDownView);
    }

    @Override
    public void update(DropDownViewItem dropDownViewItem) {
        this.updateEnabled(dropDownViewItem);
        this.updateSelected(dropDownViewItem);
        this.updateIcon(dropDownViewItem);
        this.updateText(dropDownViewItem);
        this.updateTooltip(dropDownViewItem);
        this.updateRepresentative(dropDownViewItem);
    }

    protected void updateEnabled(DropDownViewItem dropDownViewItem) {
        this.getView().setEnabled(this.enabled);
    }

    protected void updateRepresentative(DropDownViewItem dropDownViewItem) {
        this.getView().setDockableRepresentation(this.representative);
    }

    protected void updateSelected(DropDownViewItem dropDownViewItem) {
        this.getView().setSelected(this.selected);
    }

    @Override
    public ActionContentModifier[] getIconContexts() {
        return this.getView().getIconContexts();
    }

    protected void updateIcon(DropDownViewItem dropDownViewItem) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(this.icons.keySet());
        ActionContentModifier[] actionContentModifierArray = this.getView().getIconContexts();
        int n = actionContentModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContentModifier actionContentModifier2 = actionContentModifierArray[n2];
            hashSet.add(actionContentModifier2);
            ++n2;
        }
        actionContentModifierArray = this.getAction().getIconContexts(this.getDockable());
        n = actionContentModifierArray.length;
        n2 = 0;
        while (n2 < n) {
            ActionContentModifier actionContentModifier = actionContentModifierArray[n2];
            hashSet.add(actionContentModifier);
            ++n2;
        }
        for (ActionContentModifier actionContentModifier : hashSet) {
            Icon icon = (Icon)this.icons.get(actionContentModifier);
            if (icon == null) {
                this.getView().setIcon(actionContentModifier, this.getAction().getIcon(this.getDockable(), actionContentModifier));
                continue;
            }
            this.getView().setIcon(actionContentModifier, icon);
        }
    }

    protected void updateText(DropDownViewItem dropDownViewItem) {
        if (this.text == null) {
            this.getView().setText(this.getAction().getText(this.getDockable()));
        } else {
            this.getView().setText(this.text);
        }
    }

    protected void updateTooltip(DropDownViewItem dropDownViewItem) {
        if (dropDownViewItem == null || !dropDownViewItem.isTriggerable(true)) {
            String string = this.getAction().getTooltipText(this.getDockable());
            if (string == null) {
                string = this.tooltip;
            }
            if (string == null) {
                string = this.getAction().getText(this.getDockable());
            }
            if (string == null) {
                string = this.text;
            }
            this.getView().setTooltip(string);
        } else {
            String string = this.tooltip;
            if (string == null) {
                string = this.getAction().getTooltipText(this.getDockable());
            }
            if (string == null) {
                string = this.text;
            }
            if (string == null) {
                string = this.getAction().getText(this.getDockable());
            }
            this.getView().setTooltip(string);
        }
    }
}

