/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SharingSelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleDropDownItemAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public abstract class SimpleSelectableAction
extends SimpleDropDownItemAction
implements SharingSelectableDockAction,
SelectableDockAction {
    private List<SelectableDockActionListener> listeners = new ArrayList<SelectableDockActionListener>();
    private boolean selected = false;
    private Map<ActionContentModifier, Icon> selectIcons = new HashMap<ActionContentModifier, Icon>();
    private ActionType<SelectableDockAction> type;

    public SimpleSelectableAction(ActionType<SelectableDockAction> actionType, boolean bl) {
        super(bl);
        if (actionType == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = actionType;
    }

    @Override
    public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
        return actionViewConverter.createView(this.type, this, viewTarget, dockable);
    }

    @Override
    public void addSelectableListener(SelectableDockActionListener selectableDockActionListener) {
        this.listeners.add(selectableDockActionListener);
    }

    @Override
    public void removeSelectableListener(SelectableDockActionListener selectableDockActionListener) {
        this.listeners.remove(selectableDockActionListener);
    }

    protected void fireSelectedChanged() {
        Set<Dockable> set = this.getBoundDockables();
        SelectableDockActionListener[] selectableDockActionListenerArray = this.listeners.toArray(new SelectableDockActionListener[this.listeners.size()]);
        int n = selectableDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectableDockActionListener selectableDockActionListener = selectableDockActionListenerArray[n2];
            selectableDockActionListener.selectedChanged(this, set);
            ++n2;
        }
    }

    @Override
    public boolean isSelected(Dockable dockable) {
        return this.selected;
    }

    @Override
    public void setSelected(Dockable dockable, boolean bl) {
        this.setSelected(bl);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl != this.selected) {
            this.selected = bl;
            this.fireSelectedChanged();
            this.fireActionIconChanged(null, this.getBoundDockables());
        }
    }

    @Override
    public Icon getIcon(Dockable dockable, ActionContentModifier actionContentModifier) {
        if (this.isSelected()) {
            return this.firstNonNull(this.selectIcons.get(actionContentModifier), super.getIcon(dockable, actionContentModifier));
        }
        return super.getIcon(dockable, actionContentModifier);
    }

    protected Icon firstNonNull(Icon ... iconArray) {
        Icon[] iconArray2 = iconArray;
        int n = iconArray.length;
        int n2 = 0;
        while (n2 < n) {
            Icon icon = iconArray2[n2];
            if (icon != null) {
                return icon;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ActionContentModifier[] getIconContexts(Dockable dockable) {
        HashSet<ActionContentModifier> hashSet = new HashSet<ActionContentModifier>();
        ActionContentModifier[] actionContentModifierArray = super.getIconContexts(dockable);
        int n = actionContentModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContentModifier actionContentModifier = actionContentModifierArray[n2];
            hashSet.add(actionContentModifier);
            ++n2;
        }
        hashSet.addAll(this.selectIcons.keySet());
        return hashSet.toArray(new ActionContentModifier[hashSet.size()]);
    }

    public void setSelectedIcon(Icon icon) {
        this.setSelectedIcon(ActionContentModifier.NONE, icon);
    }

    public Icon getSelectedIcon() {
        return this.getSelectedIcon(ActionContentModifier.NONE);
    }

    public void setDisabledSelectedIcon(Icon icon) {
        this.setSelectedIcon(ActionContentModifier.DISABLED, icon);
    }

    public Icon getDisabledSelectedIcon() {
        return this.getSelectedIcon(ActionContentModifier.DISABLED);
    }

    @Override
    public Icon getSelectedIcon(ActionContentModifier actionContentModifier) {
        return this.selectIcons.get(actionContentModifier);
    }

    @Override
    public void setSelectedIcon(ActionContentModifier actionContentModifier, Icon icon) {
        if (icon == null) {
            this.selectIcons.remove(actionContentModifier);
        } else {
            this.selectIcons.put(actionContentModifier, icon);
        }
        this.fireActionIconChanged(actionContentModifier, this.getBoundDockables());
    }

    public static class Check
    extends SimpleSelectableAction {
        public Check() {
            this(true);
        }

        public Check(boolean bl) {
            super(ActionType.CHECK, bl);
            this.setDropDownSelectable(false);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable)) {
                return false;
            }
            this.setSelected(dockable, !this.isSelected(dockable));
            return true;
        }
    }

    public static class Radio
    extends SimpleSelectableAction {
        public Radio() {
            this(true);
        }

        public Radio(boolean bl) {
            super(ActionType.RADIO, bl);
            this.setDropDownTriggerableSelected(false);
        }

        @Override
        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable) || this.isSelected(dockable)) {
                return false;
            }
            this.setSelected(dockable, true);
            return true;
        }
    }
}

