/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.actions.AbstractStandardDockAction;
import bibliothek.gui.dock.action.actions.SharingStandardDockAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.station.LayoutLocked;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class SimpleDockAction
extends AbstractStandardDockAction
implements SharingStandardDockAction {
    private Map<ActionContentModifier, Icon> icons = new HashMap<ActionContentModifier, Icon>();
    private String text;
    private String tooltip;
    private boolean enabled = true;
    private KeyStroke accelerator;
    private Dockable representative;
    private Map<Dockable, DockableKeyForwarder> forwarders = new HashMap<Dockable, DockableKeyForwarder>();

    public SimpleDockAction(boolean bl) {
        super(bl);
    }

    @Override
    protected void bound(Dockable dockable) {
        super.bound(dockable);
        DockableKeyForwarder dockableKeyForwarder = new DockableKeyForwarder(dockable);
        this.forwarders.put(dockable, dockableKeyForwarder);
    }

    @Override
    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        DockableKeyForwarder dockableKeyForwarder = this.forwarders.remove(dockable);
        dockableKeyForwarder.destroy();
    }

    @Override
    public Icon getIcon(Dockable dockable, ActionContentModifier actionContentModifier) {
        return this.icons.get(actionContentModifier);
    }

    @Override
    public String getText(Dockable dockable) {
        return this.text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.fireActionTextChanged(this.getBoundDockables());
    }

    @Override
    public String getTooltipText(Dockable dockable) {
        return this.getTooltipText();
    }

    @Override
    public String getTooltipText() {
        if (this.accelerator == null) {
            return this.tooltip;
        }
        String string = this.stroketoString(this.accelerator, true);
        if (this.tooltip == null) {
            return string;
        }
        return String.valueOf(this.tooltip) + " (" + string + ")";
    }

    private final String stroketoString(KeyStroke keyStroke, boolean bl) {
        int n;
        String string = "";
        int n2 = keyStroke.getModifiers();
        if (n2 != 0) {
            string = KeyEvent.getKeyModifiersText(n2);
            if (!bl) {
                string = String.valueOf(string) + "+";
            }
        }
        if (!this.isModifierKey(n = keyStroke.getKeyCode())) {
            if (bl && n2 != 0) {
                string = String.valueOf(string) + "+";
            }
            string = n != 0 ? String.valueOf(string) + KeyEvent.getKeyText(n) : String.valueOf(string) + keyStroke.getKeyChar();
            if (!bl) {
                string = String.valueOf(string) + "+";
            }
        }
        return string;
    }

    private boolean isModifierKey(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(String string) {
        this.tooltip = string;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        return this.enabled && super.isEnabled(dockable);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireActionEnabledChanged(this.getBoundDockables());
        }
    }

    @Override
    public Icon getIcon() {
        return this.icons.get(ActionContentModifier.NONE);
    }

    @Override
    public void setIcon(Icon icon) {
        this.setIcon(ActionContentModifier.NONE, icon);
    }

    @Override
    public ActionContentModifier[] getIconContexts(Dockable dockable) {
        return this.icons.keySet().toArray(new ActionContentModifier[this.icons.size()]);
    }

    @Override
    public Icon getDisabledIcon() {
        return this.icons.get(ActionContentModifier.DISABLED);
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        this.setIcon(ActionContentModifier.DISABLED, icon);
    }

    @Override
    public Icon getIcon(ActionContentModifier actionContentModifier) {
        return this.icons.get(actionContentModifier);
    }

    @Override
    public void setIcon(ActionContentModifier actionContentModifier, Icon icon) {
        if (icon == null) {
            this.icons.remove(actionContentModifier);
        } else {
            this.icons.put(actionContentModifier, icon);
        }
        this.fireActionIconChanged(actionContentModifier, this.getBoundDockables());
    }

    @Override
    public void setDockableRepresentation(Dockable dockable) {
        if (this.representative != dockable) {
            this.representative = dockable;
            this.fireActionRepresentativeChanged(this.getBoundDockables());
        }
    }

    @Override
    public Dockable getDockableRepresentation(Dockable dockable) {
        return this.representative;
    }

    @Override
    public Dockable getDockableRepresentation() {
        return this.representative;
    }

    @Override
    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        this.accelerator = keyStroke;
        this.fireActionTooltipTextChanged(this.getBoundDockables());
    }

    protected boolean trigger(KeyEvent keyEvent, Dockable dockable) {
        return this.trigger(dockable);
    }

    @LayoutLocked(locked=false)
    private class DockableKeyForwarder
    implements KeyboardListener,
    DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;
        private boolean destroyed = false;

        public DockableKeyForwarder(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockHierarchyListener(this);
            this.setController(dockable.getController());
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            this.setController(this.dockable.getController());
        }

        private void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.getKeyboardController().removeListener(this);
            }
            this.controller = this.destroyed ? null : dockController;
            if (this.controller != null) {
                this.controller.getKeyboardController().addListener(this);
            }
        }

        public void destroy() {
            this.destroyed = true;
            this.setController(null);
            this.dockable.removeDockHierarchyListener(this);
        }

        private boolean forward(DockElement dockElement, KeyEvent keyEvent) {
            if (SimpleDockAction.this.accelerator != null && SimpleDockAction.this.accelerator.equals(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
                return SimpleDockAction.this.trigger(keyEvent, this.dockable);
            }
            return false;
        }

        @Override
        public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
            return this.forward(dockElement, keyEvent);
        }

        @Override
        public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
            return this.forward(dockElement, keyEvent);
        }

        @Override
        public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
            return this.forward(dockElement, keyEvent);
        }

        @Override
        public DockElement getTreeLocation() {
            return this.dockable;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " -> " + this.dockable.getTitleText() + " -> " + SimpleDockAction.this.getText();
        }
    }
}

