/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.actions.AbstractStandardDockAction;
import bibliothek.gui.dock.action.actions.GroupKeyGenerator;
import bibliothek.gui.dock.action.actions.SimpleDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.util.container.Tuple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class GroupedDockAction<K, D extends SimpleDockAction>
extends AbstractStandardDockAction {
    private Map<K, D> groups = new HashMap<K, D>();
    private Map<Dockable, Tuple<K, D>> dockActions = new HashMap<Dockable, Tuple<K, D>>();
    private Listener listener = new Listener();
    private boolean removeEmptyGroups = true;
    private GroupKeyGenerator<? extends K> generator;

    public GroupedDockAction(GroupKeyGenerator<? extends K> groupKeyGenerator) {
        super(true);
        this.generator = groupKeyGenerator;
    }

    public void setGenerator(GroupKeyGenerator<? extends K> groupKeyGenerator) {
        this.generator = groupKeyGenerator;
    }

    public GroupKeyGenerator<? extends K> getGenerator() {
        return this.generator;
    }

    public boolean isRemoveEmptyGroups() {
        return this.removeEmptyGroups;
    }

    public void setRemoveEmptyGroups(boolean bl) {
        this.removeEmptyGroups = bl;
    }

    @Override
    public Icon getIcon(Dockable dockable, ActionContentModifier actionContentModifier) {
        return ((SimpleDockAction)this.getGroup(dockable)).getIcon(dockable, actionContentModifier);
    }

    @Override
    public ActionContentModifier[] getIconContexts(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getIconContexts(dockable);
    }

    @Override
    public String getText(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getText(dockable);
    }

    @Override
    public String getTooltipText(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getTooltipText(dockable);
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).isEnabled(dockable) && super.isEnabled(dockable);
    }

    @Override
    public void bound(Dockable dockable) {
        K k = this.createGroupKey(dockable);
        if (k == null) {
            throw new IllegalStateException("null-key generated, a null-key is not allowed");
        }
        super.bound(dockable);
        D d = this.ensureGroup(k);
        ((AbstractStandardDockAction)d).bind(dockable);
        this.dockActions.put(dockable, new Tuple<K, D>(k, d));
    }

    @Override
    public void unbound(Dockable dockable) {
        super.unbound(dockable);
        Tuple<K, D> tuple = this.dockActions.remove(dockable);
        ((SimpleDockAction)tuple.getB()).unbind(dockable);
        this.removeIfEmpty(tuple.getA());
    }

    private void removeIfEmpty(K k) {
        D d;
        if (this.removeEmptyGroups && ((AbstractStandardDockAction)(d = this.getGroup(k))).getBoundDockables().isEmpty()) {
            this.groups.remove(k);
            ((AbstractStandardDockAction)d).removeDockActionListener(this.listener);
        }
    }

    public void setIcon(K k, Icon icon) {
        ((SimpleDockAction)this.ensureGroup(k)).setIcon(icon);
    }

    public Icon getIcon(Object object) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getIcon();
    }

    public void setIcon(K k, ActionContentModifier actionContentModifier, Icon icon) {
        ((SimpleDockAction)this.ensureGroup(k)).setIcon(actionContentModifier, icon);
    }

    public Icon getIcon(Object object, ActionContentModifier actionContentModifier) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getIcon(actionContentModifier);
    }

    public void setDisabledIcon(K k, Icon icon) {
        ((SimpleDockAction)this.ensureGroup(k)).setDisabledIcon(icon);
    }

    public Icon getDisabledIcon(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getDisabledIcon();
    }

    public Icon getDisabledIcon(Object object) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getDisabledIcon();
    }

    public void setText(K k, String string) {
        ((SimpleDockAction)this.ensureGroup(k)).setText(string);
    }

    public String getText(Object object) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getText();
    }

    public void setTooltip(K k, String string) {
        ((SimpleDockAction)this.ensureGroup(k)).setTooltip(string);
    }

    public String getTooltipText(Object object) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getTooltipText();
    }

    public String getTooltip(Object object) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getTooltip();
    }

    public void setEnabled(K k, boolean bl) {
        ((SimpleDockAction)this.ensureGroup(k)).setEnabled(bl);
    }

    public boolean isEnabled(Object object) {
        D d = this.getGroup(object);
        if (d == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return ((SimpleDockAction)d).isEnabled();
    }

    @Override
    public Dockable getDockableRepresentation(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getDockableRepresentation(dockable);
    }

    public Dockable getDockableRepresentation(K k) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(k);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getDockableRepresentation();
    }

    public void setDockableRepresentation(K k, Dockable dockable) {
        ((SimpleDockAction)this.ensureGroup(k)).setDockableRepresentation(dockable);
    }

    public void setAccelerator(K k, KeyStroke keyStroke) {
        ((SimpleDockAction)this.ensureGroup(k)).setAccelerator(keyStroke);
    }

    public KeyStroke getAccelerator(K k) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(k);
        if (simpleDockAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleDockAction.getAccelerator();
    }

    protected D ensureGroup(K k) {
        if (k == null) {
            throw new IllegalArgumentException("The key must be a non-null value");
        }
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(k);
        if (simpleDockAction == null) {
            simpleDockAction = this.createGroup(k);
            simpleDockAction.addDockActionListener(this.listener);
            this.groups.put(k, simpleDockAction);
        }
        return (D)simpleDockAction;
    }

    protected D getGroup(Dockable dockable) {
        Tuple<K, D> tuple = this.dockActions.get(dockable);
        return (D)(tuple == null ? null : (SimpleDockAction)tuple.getB());
    }

    protected D getGroup(Object object) {
        return (D)((SimpleDockAction)this.groups.get(object));
    }

    protected abstract D createGroup(K var1);

    public boolean groupExists(Object object) {
        return this.groups.containsKey(object);
    }

    public boolean removeGroup(Object object) {
        SimpleDockAction simpleDockAction = (SimpleDockAction)this.groups.get(object);
        if (simpleDockAction == null) {
            return true;
        }
        if (simpleDockAction.getBoundDockables().isEmpty()) {
            simpleDockAction.removeDockActionListener(this.listener);
            this.groups.remove(object);
            return true;
        }
        return false;
    }

    protected K createGroupKey(Dockable dockable) {
        return this.generator.generateKey(dockable);
    }

    public void setGroup(K k, Dockable dockable) {
        if (k == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        Tuple<K, D> tuple = this.dockActions.get(dockable);
        if (tuple == null) {
            throw new IllegalArgumentException("Dockable was not registered");
        }
        D d = this.ensureGroup(k);
        ((SimpleDockAction)tuple.getB()).unbind(dockable);
        this.removeIfEmpty(tuple.getA());
        ((AbstractStandardDockAction)d).bind(dockable);
        this.dockActions.put(dockable, new Tuple<K, D>(k, d));
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        hashSet.add(dockable);
        this.fireActionEnabledChanged(hashSet);
        this.fireActionIconChanged(null, hashSet);
        this.fireActionTextChanged(hashSet);
        this.fireActionTooltipTextChanged(hashSet);
        this.fireActionRepresentativeChanged(hashSet);
    }

    public boolean isKnown(Dockable dockable) {
        return this.dockActions.containsKey(dockable);
    }

    @Override
    public boolean trigger(Dockable dockable) {
        return this.getGroup(dockable).trigger(dockable);
    }

    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            GroupedDockAction.this.fireActionTooltipTextChanged(set);
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            GroupedDockAction.this.fireActionTextChanged(set);
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, ActionContentModifier actionContentModifier, Set<Dockable> set) {
            GroupedDockAction.this.fireActionIconChanged(actionContentModifier, set);
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            GroupedDockAction.this.fireActionEnabledChanged(set);
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            GroupedDockAction.this.fireActionRepresentativeChanged(set);
        }
    }
}

