/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.disable.ActionDisablingStrategyObserver;
import bibliothek.gui.dock.event.StandardDockActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStandardDockAction
implements StandardDockAction {
    protected List<StandardDockActionListener> listeners = new ArrayList<StandardDockActionListener>();
    private Map<Dockable, Integer> bound = new HashMap<Dockable, Integer>();
    private ActionDisablingStrategyObserver disabling;

    public AbstractStandardDockAction(boolean bl) {
        if (bl) {
            this.disabling = new ActionDisablingStrategyObserver(this){

                @Override
                protected void setDisabled(Set<Dockable> set, boolean bl) {
                    AbstractStandardDockAction.this.fireActionEnabledChanged(set);
                }

                @Override
                protected void setDisabled(Dockable dockable, boolean bl) {
                    HashSet<Dockable> hashSet = new HashSet<Dockable>(1);
                    hashSet.add(dockable);
                    AbstractStandardDockAction.this.fireActionEnabledChanged(hashSet);
                }
            };
        }
    }

    @Override
    public void addDockActionListener(StandardDockActionListener standardDockActionListener) {
        this.listeners.add(standardDockActionListener);
    }

    @Override
    public void removeDockActionListener(StandardDockActionListener standardDockActionListener) {
        this.listeners.remove(standardDockActionListener);
    }

    protected void bound(Dockable dockable) {
    }

    protected void unbound(Dockable dockable) {
    }

    public boolean isBound(Dockable dockable) {
        return this.bound.containsKey(dockable);
    }

    public Set<Dockable> getBoundDockables() {
        return Collections.unmodifiableSet(this.bound.keySet());
    }

    @Override
    public void bind(Dockable dockable) {
        Integer n;
        if (this.disabling != null) {
            this.disabling.bind(dockable);
        }
        if ((n = this.bound.get(dockable)) == null) {
            this.bound.put(dockable, 1);
            this.bound(dockable);
        } else {
            this.bound.put(dockable, n + 1);
        }
    }

    @Override
    public void unbind(Dockable dockable) {
        Integer n;
        if (this.disabling != null) {
            this.disabling.unbind(dockable);
        }
        if ((n = this.bound.get(dockable)) == null) {
            try {
                throw new NullPointerException("Unbind called too often, omit unbind and continue");
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        } else if (n == 1) {
            this.bound.remove(dockable);
            this.unbound(dockable);
        } else {
            this.bound.put(dockable, n - 1);
        }
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        if (this.disabling == null) {
            return true;
        }
        return !this.disabling.isDisabled(dockable);
    }

    protected void fireActionTextChanged(Set<Dockable> set) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener standardDockActionListener = standardDockActionListenerArray[n2];
            standardDockActionListener.actionTextChanged(this, set);
            ++n2;
        }
    }

    protected void fireActionTooltipTextChanged(Set<Dockable> set) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener standardDockActionListener = standardDockActionListenerArray[n2];
            standardDockActionListener.actionTooltipTextChanged(this, set);
            ++n2;
        }
    }

    protected void fireActionIconChanged(ActionContentModifier actionContentModifier, Set<Dockable> set) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener standardDockActionListener = standardDockActionListenerArray[n2];
            standardDockActionListener.actionIconChanged(this, actionContentModifier, set);
            ++n2;
        }
    }

    protected void fireActionEnabledChanged(Set<Dockable> set) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener standardDockActionListener = standardDockActionListenerArray[n2];
            standardDockActionListener.actionEnabledChanged(this, set);
            ++n2;
        }
    }

    protected void fireActionRepresentativeChanged(Set<Dockable> set) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener standardDockActionListener = standardDockActionListenerArray[n2];
            standardDockActionListener.actionRepresentativeChanged(this, set);
            ++n2;
        }
    }
}

