/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.actions.SimpleDockAction;
import bibliothek.gui.dock.action.dropdown.DefaultDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DropDownActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractSimpleDropDownAction
extends SimpleDockAction
implements DropDownAction {
    private DockAction selection;
    private List<DropDownActionListener> listeners = new ArrayList<DropDownActionListener>();
    private DropDownFilterFactory filter = DefaultDropDownFilter.FACTORY;

    public AbstractSimpleDropDownAction(boolean bl) {
        super(bl);
    }

    @Override
    public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
        return actionViewConverter.createView(ActionType.DROP_DOWN, this, viewTarget, dockable);
    }

    @Override
    public DockAction getSelection(Dockable dockable) {
        return this.selection;
    }

    public DockAction getSelection() {
        return this.selection;
    }

    @Override
    public void setSelection(Dockable dockable, DockAction dockAction) {
        this.setSelection(dockAction);
    }

    public void setSelection(DockAction dockAction) {
        if (this.selection != dockAction) {
            this.selection = dockAction;
            this.fireSelectionChanged();
        }
    }

    public void setFilter(DropDownFilterFactory dropDownFilterFactory) {
        if (dropDownFilterFactory == null) {
            throw new IllegalArgumentException("Filter must not be null");
        }
        this.filter = dropDownFilterFactory;
    }

    @Override
    public DropDownFilterFactory getFilter(Dockable dockable) {
        return this.filter;
    }

    protected abstract DockActionSource getSubActions();

    @Override
    public DockActionSource getSubActions(Dockable dockable) {
        return this.getSubActions();
    }

    @Override
    public void addDropDownActionListener(DropDownActionListener dropDownActionListener) {
        this.listeners.add(dropDownActionListener);
    }

    @Override
    public void removeDropDownActionListener(DropDownActionListener dropDownActionListener) {
        this.listeners.remove(dropDownActionListener);
    }

    protected DropDownActionListener[] getListeners() {
        return this.listeners.toArray(new DropDownActionListener[this.listeners.size()]);
    }

    protected void fireSelectionChanged() {
        Set<Dockable> set = this.getBoundDockables();
        DropDownActionListener[] dropDownActionListenerArray = this.getListeners();
        int n = dropDownActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DropDownActionListener dropDownActionListener = dropDownActionListenerArray[n2];
            dropDownActionListener.selectionChanged(this, set, this.selection);
            ++n2;
        }
    }

    @Override
    public boolean trigger(Dockable dockable) {
        if (!this.isEnabled(dockable)) {
            return false;
        }
        if (this.selection != null) {
            return this.selection.trigger(dockable);
        }
        return false;
    }
}

