/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.util.container.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class StationChildrenActionSource
extends AbstractDockActionSource {
    private LocationHint hint;
    private Dockable dockable;
    private Listener listener;
    private boolean onUpdateList = false;
    private List<Tuple<Dockable, DockAction>> actions = new ArrayList<Tuple<Dockable, DockAction>>();

    public StationChildrenActionSource(Dockable dockable, LocationHint locationHint) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
        if (locationHint == null) {
            locationHint = LocationHint.UNKNOWN;
        }
        this.hint = locationHint;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public DockAction getDockAction(int n) {
        this.updateActionList(false);
        return this.actions.get(n).getB();
    }

    @Override
    public int getDockActionCount() {
        this.updateActionList(false);
        return this.actions.size();
    }

    @Override
    public Iterator<DockAction> iterator() {
        this.updateActionList(false);
        return new Iterator<DockAction>(){
            private Iterator<Tuple<Dockable, DockAction>> iterator;
            {
                this.iterator = StationChildrenActionSource.this.actions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DockAction next() {
                return this.iterator.next().getB();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        if (this.listener == null) {
            this.updateActionList(false);
        }
        super.addDockActionSourceListener(dockActionSourceListener);
        if (this.listener == null) {
            this.listener = new Listener();
            this.listener.add(this.dockable);
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (this.listeners.size() == 0 && this.listener != null) {
            this.listener.remove(this.dockable);
            this.listener = null;
        }
    }

    private void updateActionList(boolean bl) {
        if (this.onUpdateList) {
            return;
        }
        try {
            this.onUpdateList = true;
            if (this.listener != null && !bl) {
                return;
            }
            ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
            this.fill(this.dockable, arrayList);
            this.sort(arrayList);
            int n = 0;
            int n2 = arrayList.size();
            int n3 = 0;
            int n4 = this.actions.size();
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            for (Tuple<Dockable, DockAction> object : this.actions) {
                hashSet.add((Dockable)object.getA());
            }
            while (n < n2 && n3 < n4) {
                Dockable n6 = (Dockable)arrayList.get(n);
                if (this.actions.get(n3).getA() == n6) {
                    ++n;
                    ++n3;
                } else if (hashSet.contains(n6)) {
                    this.actions.remove(n3);
                    --n4;
                    this.fireRemoved(n3, n3);
                } else {
                    this.actions.add(n3, new Tuple<Dockable, DockAction>(n6, this.createActionFor(n6)));
                    ++n4;
                    this.fireAdded(n3, n3);
                    ++n;
                    ++n3;
                }
                hashSet.remove(n6);
            }
            if (n3 < n4) {
                int n5 = n4;
                while (n3 < n4) {
                    this.actions.remove(--n4);
                }
                this.fireRemoved(n3, n5 - 1);
            }
            if (n < n2) {
                int n6 = n;
                while (n < n2) {
                    Dockable dockable = (Dockable)arrayList.get(n++);
                    this.actions.add(new Tuple<Object, DockAction>(dockable, this.createActionFor(dockable)));
                }
                this.fireAdded(n6, this.actions.size() - 1);
            }
        }
        finally {
            this.onUpdateList = false;
        }
    }

    private void fill(Dockable dockable, List<Dockable> list) {
        DockStation dockStation;
        if (this.shouldShow(dockable)) {
            list.add(dockable);
        }
        if ((dockStation = dockable.asDockStation()) != null) {
            int n = 0;
            int n2 = dockStation.getDockableCount();
            while (n < n2) {
                this.fill(dockStation.getDockable(n), list);
                ++n;
            }
        }
    }

    protected DockAction createActionFor(Dockable dockable) {
        return new FocusAction(dockable);
    }

    protected void sort(List<Dockable> list) {
    }

    protected boolean shouldShow(Dockable dockable) {
        if (dockable.getDockParent() == this.getDockable().asDockStation()) {
            return true;
        }
        return dockable == this.getDockable() && dockable.asDockStation() == null;
    }

    protected class FocusAction
    extends SimpleSelectableAction.Check
    implements DockableListener {
        private Dockable dockable;
        private DockStation parent;
        private boolean onChange = false;
        private int bound = 0;
        private DockStationAdapter adapter = new DockStationAdapter(){

            @Override
            public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                FocusAction.this.checkState();
            }

            @Override
            public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
                FocusAction.this.checkState();
            }
        };
        private DockHierarchyListener hierarchy = new DockHierarchyListener(){

            @Override
            public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
                if (FocusAction.this.bound > 0) {
                    if (FocusAction.this.parent != null) {
                        FocusAction.this.parent.removeDockStationListener(FocusAction.this.adapter);
                    }
                    FocusAction.this.parent = FocusAction.this.dockable.getDockParent();
                    if (FocusAction.this.parent != null) {
                        FocusAction.this.parent.addDockStationListener(FocusAction.this.adapter);
                    }
                    FocusAction.this.checkState();
                }
            }

            @Override
            public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            }
        };

        public FocusAction(Dockable dockable) {
            this.dockable = dockable;
            this.setDockableRepresentation(dockable);
            this.addSelectableListener(new SelectableDockActionListener(){

                @Override
                public void selectedChanged(SelectableDockAction selectableDockAction, Set<Dockable> set) {
                    FocusAction.this.checkDockable();
                }
            });
        }

        @Override
        public void bind(Dockable dockable) {
            ++this.bound;
            if (this.bound == 1) {
                this.dockable.addDockHierarchyListener(this.hierarchy);
                this.parent = this.dockable.getDockParent();
                if (this.parent != null) {
                    this.parent.addDockStationListener(this.adapter);
                }
                this.checkState();
            }
            super.bind(dockable);
        }

        @Override
        public void unbind(Dockable dockable) {
            super.unbind(dockable);
            --this.bound;
            if (this.bound == 0) {
                if (this.parent != null) {
                    this.parent.removeDockStationListener(this.adapter);
                }
                this.dockable.removeDockHierarchyListener(this.hierarchy);
                this.parent = null;
            }
        }

        private void checkState() {
            if (!this.onChange) {
                try {
                    this.onChange = true;
                    DockStation dockStation = this.dockable.getDockParent();
                    boolean bl = false;
                    if (dockStation != null) {
                        bl = dockStation.isChildShowing(this.dockable) && dockStation.getFrontDockable() == this.dockable;
                    }
                    this.setSelected(bl);
                }
                finally {
                    this.onChange = false;
                }
            }
        }

        private void checkDockable() {
            if (!this.onChange) {
                try {
                    this.onChange = true;
                    if (this.isSelected()) {
                        DockController dockController = this.dockable.getController();
                        if (dockController != null) {
                            dockController.setFocusedDockable(new DefaultFocusRequest(this.dockable, null, true, true, true));
                        }
                    } else {
                        DockStation dockStation = this.parent;
                        Dockable dockable = this.dockable;
                        DockStation dockStation2 = StationChildrenActionSource.this.dockable.getDockParent();
                        while (dockStation != null) {
                            if (dockStation.getFrontDockable() == dockable) {
                                dockStation.setFrontDockable(null);
                            }
                            dockStation = dockStation == dockStation2 ? null : ((dockable = dockStation.asDockable()) != null ? dockable.getDockParent() : null);
                        }
                    }
                }
                finally {
                    this.onChange = false;
                }
            }
        }

        @Override
        protected void bound(Dockable dockable) {
            this.dockable.addDockableListener(this);
            this.setIcon(this.dockable.getTitleIcon());
            this.setText(this.dockable.getTitleText());
            this.setTooltip(this.dockable.getTitleToolTip());
        }

        @Override
        protected void unbound(Dockable dockable) {
            this.dockable.removeDockableListener(this);
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            this.setIcon(icon2);
        }

        @Override
        public void titleTextChanged(Dockable dockable, String string, String string2) {
            this.setText(string2);
            String string3 = dockable.getTitleToolTip();
            if (string3 == null || string3.length() == 0) {
                this.setTooltip(string2);
            }
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            this.setTooltip(string2);
            if (string2 == null || string2.length() == 0) {
                this.setTooltip(dockable.getTitleText());
            }
        }

        @Override
        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }
    }

    private class Listener
    extends DockStationAdapter {
        private Listener() {
        }

        @Override
        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            this.add(dockable);
            StationChildrenActionSource.this.updateActionList(true);
        }

        @Override
        public void dockableRemoving(DockStation dockStation, Dockable dockable) {
            this.remove(dockable);
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            StationChildrenActionSource.this.updateActionList(true);
        }

        @Override
        public void dockablesRepositioned(DockStation dockStation, Dockable[] dockableArray) {
            StationChildrenActionSource.this.updateActionList(true);
        }

        public void add(Dockable dockable) {
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                dockStation.addDockStationListener(this);
                int n = 0;
                int n2 = dockStation.getDockableCount();
                while (n < n2) {
                    this.add(dockStation.getDockable(n));
                    ++n;
                }
            }
        }

        public void remove(Dockable dockable) {
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                dockStation.removeDockStationListener(this);
                int n = 0;
                int n2 = dockStation.getDockableCount();
                while (n < n2) {
                    this.remove(dockStation.getDockable(n));
                    ++n;
                }
            }
        }
    }
}

