/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiDockActionSource
extends AbstractDockActionSource {
    private List<DockActionSource> sources = new ArrayList<DockActionSource>();
    private List<SeparatorSource> separators = new ArrayList<SeparatorSource>();
    private Listener listener = new Listener();
    private boolean separateSources = false;
    private LocationHint hint;

    public MultiDockActionSource(DockActionSource ... dockActionSourceArray) {
        this(LocationHint.UNKNOWN, dockActionSourceArray);
    }

    public MultiDockActionSource(LocationHint locationHint, DockActionSource ... dockActionSourceArray) {
        DockActionSource[] dockActionSourceArray2 = dockActionSourceArray;
        int n = dockActionSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockActionSource dockActionSource = dockActionSourceArray2[n2];
            this.sources.add(dockActionSource);
            ++n2;
        }
        this.setHint(locationHint);
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockActionSource> sourceIterator;
            private Iterator<DockAction> actionIterator;
            {
                this.sourceIterator = MultiDockActionSource.this.sources.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.actionIterator == null) {
                    if (this.sourceIterator.hasNext()) {
                        this.actionIterator = this.sourceIterator.next().iterator();
                    } else {
                        return false;
                    }
                }
                while (true) {
                    if (this.actionIterator.hasNext()) {
                        return true;
                    }
                    if (!this.sourceIterator.hasNext()) break;
                    this.actionIterator = this.sourceIterator.next().iterator();
                }
                return false;
            }

            @Override
            public DockAction next() {
                this.hasNext();
                return this.actionIterator.next();
            }

            @Override
            public void remove() {
                this.hasNext();
                this.actionIterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        boolean bl = this.listeners.isEmpty();
        super.addDockActionSourceListener(dockActionSourceListener);
        if (bl && !this.listeners.isEmpty()) {
            for (DockActionSource dockActionSource : this.sources) {
                dockActionSource.addDockActionSourceListener(this.listener);
            }
            this.updateSeparators();
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        boolean bl = this.listeners.isEmpty();
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (!bl && this.listeners.isEmpty()) {
            for (DockActionSource dockActionSource : this.sources) {
                dockActionSource.removeDockActionSourceListener(this.listener);
            }
        }
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    public void setHint(LocationHint locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException("Hint must not be null");
        }
        this.hint = locationHint;
    }

    public void addSeparator() {
        this.add(SeparatorAction.SEPARATOR);
    }

    public boolean isSeparateSources() {
        return this.separateSources;
    }

    public void setSeparateSources(boolean bl) {
        if (this.separateSources != bl) {
            this.separateSources = bl;
            this.updateSeparators();
        }
    }

    public void add(DockActionSource dockActionSource) {
        SeparatorSource separatorSource = new SeparatorSource(dockActionSource);
        this.sources.add(dockActionSource);
        this.sources.add(separatorSource);
        this.separators.add(separatorSource);
        if (!this.listeners.isEmpty()) {
            dockActionSource.addDockActionSourceListener(this.listener);
            separatorSource.addDockActionSourceListener(this.listener);
        }
        int n = this.getDockActionCountUntil(this.sources.size() - 2, false);
        int n2 = dockActionSource.getDockActionCount();
        if (n2 > 0) {
            this.fireAdded(n, n + n2 - 1);
        }
        this.updateSeparators();
    }

    public void remove(DockActionSource dockActionSource) {
        int n = this.sources.indexOf(dockActionSource);
        if (n < 0) {
            return;
        }
        SeparatorSource separatorSource = (SeparatorSource)this.sources.get(n + 1);
        int n2 = this.getDockActionCountUntil(n, false);
        int n3 = dockActionSource.getDockActionCount();
        this.sources.remove(n + 1);
        this.sources.remove(n);
        this.separators.remove(separatorSource);
        if (!this.listeners.isEmpty()) {
            dockActionSource.removeDockActionSourceListener(this.listener);
            separatorSource.removeDockActionSourceListener(this.listener);
        }
        if (n3 > 0) {
            this.fireRemoved(n2, n + n3 - 1);
        }
        this.updateSeparators();
    }

    public void removeAll() {
        int n = this.getDockActionCount();
        if (!this.listeners.isEmpty()) {
            for (SeparatorSource dockActionSource : this.separators) {
                dockActionSource.removeDockActionSourceListener(this.listener);
            }
            for (DockActionSource dockActionSource : this.sources) {
                dockActionSource.removeDockActionSourceListener(this.listener);
            }
        }
        this.separators.clear();
        this.sources.clear();
        if (n > 0) {
            this.fireRemoved(0, n - 1);
        }
    }

    public void add(DockAction ... dockActionArray) {
        this.add(new DefaultDockActionSource(dockActionArray));
    }

    @Override
    public int getDockActionCount() {
        return this.getDockActionCountUntil(this.sources.size(), true);
    }

    protected int getSource(DockAction dockAction) {
        int n = 0;
        int n2 = this.sources.size();
        while (n < n2) {
            DockActionSource dockActionSource = this.sources.get(n);
            int n3 = 0;
            int n4 = dockActionSource.getDockActionCount();
            while (n3 < n4) {
                if (dockActionSource.getDockAction(n3) == dockAction) {
                    return n;
                }
                ++n3;
            }
            ++n;
        }
        return -1;
    }

    protected int getDockActionCountUntil(int n, boolean bl) {
        if (bl && this.listeners.isEmpty()) {
            this.updateSeparators();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.sources.get(n3).getDockActionCount();
            ++n3;
        }
        return n2;
    }

    @Override
    public DockAction getDockAction(int n) {
        if (this.listeners.isEmpty()) {
            this.updateSeparators();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.sources.size();
        while (n3 < n4) {
            int n5 = this.sources.get(n3).getDockActionCount();
            if (n2 <= n && n < n2 + n5) {
                return this.sources.get(n3).getDockAction(n - n2);
            }
            n2 += n5;
            ++n3;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private void updateSeparators() {
        int n = this.separators.size();
        int n2 = 0;
        for (SeparatorSource separatorSource : this.separators) {
            separatorSource.update(++n2 == n);
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = MultiDockActionSource.this.getDockActionCountUntil(MultiDockActionSource.this.sources.indexOf(dockActionSource), false);
            MultiDockActionSource.this.fireAdded(n + n3, n2 + n3);
            MultiDockActionSource.this.updateSeparators();
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = MultiDockActionSource.this.getDockActionCountUntil(MultiDockActionSource.this.sources.indexOf(dockActionSource), false);
            MultiDockActionSource.this.fireRemoved(n + n3, n2 + n3);
            MultiDockActionSource.this.updateSeparators();
        }
    }

    private class SeparatorSource
    extends DefaultDockActionSource {
        private DockActionSource predecessor;

        public SeparatorSource(DockActionSource dockActionSource) {
            super(new DockAction[0]);
            this.predecessor = dockActionSource;
        }

        public void update(boolean bl) {
            if (!MultiDockActionSource.this.separateSources || bl) {
                this.remove(SeparatorAction.SEPARATOR);
            } else if (this.predecessor.getDockActionCount() > 0 && this.getDockActionCount() == 0) {
                this.add(SeparatorAction.SEPARATOR);
            }
        }
    }
}

