/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import java.util.Iterator;

public class HierarchyDockActionSource
extends AbstractDockActionSource {
    private Dockable dockable;
    private int bound = 0;
    private Listener listener = new Listener();
    private DockActionSource source;

    public HierarchyDockActionSource(Dockable dockable) {
        this.dockable = dockable;
        this.update();
    }

    public void bind() {
        if (this.bound == 0) {
            this.dockable.addDockHierarchyListener(this.listener);
            this.update();
        }
        ++this.bound;
    }

    public void unbind() {
        --this.bound;
        if (this.bound == 0) {
            this.dockable.removeDockHierarchyListener(this.listener);
        }
    }

    public void update() {
        int n;
        DockController dockController;
        int n2 = this.getDockActionCount();
        if (this.source != null) {
            this.source.removeDockActionSourceListener(this.listener);
            this.source = null;
        }
        if (n2 > 0) {
            this.fireRemoved(0, n2 - 1);
        }
        if ((dockController = this.dockable.getController()) != null) {
            this.source = dockController.listOffers(this.dockable);
        }
        if (this.source != null && !this.listeners.isEmpty()) {
            this.source.addDockActionSourceListener(this.listener);
        }
        if ((n = this.getDockActionCount()) > 0) {
            this.fireAdded(0, n - 1);
        }
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        if (this.listeners.isEmpty() && this.source != null) {
            this.source.addDockActionSourceListener(this.listener);
        }
        super.addDockActionSourceListener(dockActionSourceListener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (this.listeners.isEmpty() && this.source != null) {
            this.source.removeDockActionSourceListener(this.listener);
        }
    }

    @Override
    public DockAction getDockAction(int n) {
        if (this.source == null) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.source.getDockAction(n);
    }

    @Override
    public int getDockActionCount() {
        if (this.source == null) {
            return 0;
        }
        return this.source.getDockActionCount();
    }

    @Override
    public LocationHint getLocationHint() {
        if (this.source == null) {
            return LocationHint.UNKNOWN;
        }
        return this.source.getLocationHint();
    }

    @Override
    public Iterator<DockAction> iterator() {
        if (this.source == null) {
            return new Iterator<DockAction>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public DockAction next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.source.iterator();
    }

    private class Listener
    implements DockHierarchyListener,
    DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            HierarchyDockActionSource.this.update();
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            HierarchyDockActionSource.this.update();
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            HierarchyDockActionSource.this.fireAdded(n, n2);
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            HierarchyDockActionSource.this.fireRemoved(n, n2);
        }
    }
}

