/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class FilteredDockActionSource
extends AbstractDockActionSource {
    private DockActionSource source;
    private List<Boolean> actions = null;
    private Listener listener = new Listener();

    public FilteredDockActionSource(DockActionSource dockActionSource) {
        if (dockActionSource == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = dockActionSource;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockAction> iterator;
            private DockAction next;
            {
                this.iterator = FilteredDockActionSource.this.source.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DockAction next() {
                DockAction dockAction = this.next;
                this.advance();
                return dockAction;
            }

            private void advance() {
                while (this.iterator.hasNext()) {
                    DockAction dockAction = this.iterator.next();
                    if (!FilteredDockActionSource.this.include(dockAction)) continue;
                    this.next = dockAction;
                    return;
                }
                this.next = null;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        if (this.listeners.isEmpty()) {
            this.source.addDockActionSourceListener(this.listener);
            this.actions = new ArrayList<Boolean>();
            for (DockAction dockAction : this.source) {
                this.actions.add(this.include(dockAction));
            }
        }
        super.addDockActionSourceListener(dockActionSourceListener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (this.listeners.isEmpty()) {
            this.source.removeDockActionSourceListener(this.listener);
            this.actions = null;
        }
    }

    @Override
    public DockAction getDockAction(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        int n2 = -1;
        if (this.actions == null) {
            for (DockAction dockAction : this.source) {
                if (!this.include(dockAction) || n != ++n2) continue;
                return dockAction;
            }
        } else {
            int n3 = 0;
            int n4 = this.source.getDockActionCount();
            while (n3 < n4) {
                if (this.actions.get(n3).booleanValue() && n == ++n2) {
                    return this.source.getDockAction(n3);
                }
                ++n3;
            }
        }
        throw new IllegalArgumentException("Index out of bounds: " + n);
    }

    @Override
    public int getDockActionCount() {
        int n = 0;
        if (this.actions == null) {
            for (DockAction dockAction : this.source) {
                if (!this.include(dockAction)) continue;
                ++n;
            }
        } else {
            int n2 = 0;
            int n3 = this.source.getDockActionCount();
            while (n2 < n3) {
                if (this.actions.get(n2).booleanValue()) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.source.getLocationHint();
    }

    public void refresh() {
        if (this.actions != null) {
            int n = 0;
            int n2 = 0;
            int n3 = this.source.getDockActionCount();
            while (n2 < n3) {
                boolean bl = this.include(this.source.getDockAction(n2));
                if (bl != this.actions.get(n2)) {
                    this.actions.set(n2, bl);
                    if (bl) {
                        this.fireAdded(n, n);
                    } else {
                        this.fireRemoved(n, n);
                    }
                }
                if (bl) {
                    ++n;
                }
                ++n2;
            }
        }
    }

    protected abstract boolean include(DockAction var1);

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (((Boolean)FilteredDockActionSource.this.actions.get(n4)).booleanValue()) {
                    ++n3;
                }
                ++n4;
            }
            n4 = 0;
            int n5 = n;
            while (n5 <= n2) {
                DockAction dockAction = dockActionSource.getDockAction(n5);
                boolean bl = FilteredDockActionSource.this.include(dockAction);
                FilteredDockActionSource.this.actions.add(n5, bl);
                if (bl) {
                    ++n4;
                }
                ++n5;
            }
            if (n4 > 0) {
                FilteredDockActionSource.this.fireAdded(n3, n3 + n4 - 1);
            }
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (((Boolean)FilteredDockActionSource.this.actions.get(n4)).booleanValue()) {
                    ++n3;
                }
                ++n4;
            }
            n4 = 0;
            int n5 = n2;
            while (n5 >= n) {
                if (((Boolean)FilteredDockActionSource.this.actions.remove(n5)).booleanValue()) {
                    ++n4;
                }
                --n5;
            }
            if (n4 > 0) {
                FilteredDockActionSource.this.fireRemoved(n3, n3 + n4 - 1);
            }
        }
    }
}

