/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultDockActionSource
extends AbstractDockActionSource {
    private List<DockAction> actions = new ArrayList<DockAction>();
    private LocationHint hint;

    public DefaultDockActionSource(DockAction ... dockActionArray) {
        this(LocationHint.UNKNOWN, dockActionArray);
    }

    public DefaultDockActionSource(LocationHint locationHint, DockAction ... dockActionArray) {
        DockAction[] dockActionArray2 = dockActionArray;
        int n = dockActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockAction dockAction = dockActionArray2[n2];
            this.actions.add(dockAction);
            ++n2;
        }
        this.setHint(locationHint);
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private int current = -1;
            private boolean removed = true;

            @Override
            public boolean hasNext() {
                return this.current + 1 < DefaultDockActionSource.this.actions.size();
            }

            @Override
            public DockAction next() {
                ++this.current;
                this.removed = false;
                return (DockAction)DefaultDockActionSource.this.actions.get(this.current);
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("Next not yet called or remove already called");
                }
                this.removed = true;
                DefaultDockActionSource.this.remove(this.current--);
            }
        };
    }

    public void setHint(LocationHint locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException("Hint must not be null");
        }
        this.hint = locationHint;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public int getDockActionCount() {
        return this.actions.size();
    }

    @Override
    public DockAction getDockAction(int n) {
        return this.actions.get(n);
    }

    public void addSeparator(int n) {
        this.add(n, SeparatorAction.SEPARATOR);
    }

    public void addSeparator() {
        this.add(SeparatorAction.SEPARATOR);
    }

    public void add(DockAction ... dockActionArray) {
        this.add(this.getDockActionCount(), dockActionArray);
    }

    public void add(int n, DockAction ... dockActionArray) {
        int n2 = n;
        DockAction[] dockActionArray2 = dockActionArray;
        int n3 = dockActionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            DockAction dockAction = dockActionArray2[n4];
            this.actions.add(n++, dockAction);
            ++n4;
        }
        this.fireAdded(n2, n - 1);
    }

    @Override
    public int indexOf(DockAction dockAction) {
        return this.actions.indexOf(dockAction);
    }

    public void remove(DockAction dockAction) {
        int n = this.indexOf(dockAction);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        this.remove(n, 1);
    }

    public void removeAll() {
        this.remove(0, this.getDockActionCount());
    }

    public void remove(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Index must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (n + n2 > this.getDockActionCount()) {
            throw new IllegalArgumentException("index + length too great");
        }
        if (n2 > 0) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                this.actions.remove(n + n3);
                --n3;
            }
            this.fireRemoved(n, n + n2 - 1);
        }
    }
}

