/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenu;
import bibliothek.gui.dock.action.popup.ActionPopupMenuFactory;
import bibliothek.gui.dock.action.popup.ActionPopupMenuListener;
import bibliothek.gui.dock.control.PopupController;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public abstract class ActionPopup
extends MouseInputAdapter {
    private boolean suppressable;
    private ActionPopupMenu menu;

    public ActionPopup(boolean bl) {
        this.suppressable = bl;
    }

    public boolean isSuppressable() {
        return this.suppressable;
    }

    public void setSuppressable(boolean bl) {
        this.suppressable = bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        }
    }

    protected abstract boolean isEnabled();

    protected abstract Dockable getDockable();

    protected abstract DockActionSource getActions();

    protected abstract Object getSource();

    protected void popup(MouseEvent mouseEvent) {
        boolean bl;
        if (this.isMenuOpen()) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this.isEnabled() && (bl = this.popup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY()))) {
            mouseEvent.consume();
        }
    }

    protected Point getPopupLocation(Component component, Point point) {
        return point;
    }

    protected ActionPopupMenuFactory getFactory() {
        return this.getDockable().getController().getPopupController().getPopupMenuFactory();
    }

    public boolean popup(Component component, int n, int n2) {
        Point point = this.getPopupLocation(component, new Point(n, n2));
        if (point == null) {
            return false;
        }
        Dockable dockable = this.getDockable();
        if (dockable.getController() == null) {
            return false;
        }
        PopupController popupController = dockable.getController().getPopupController();
        if (!popupController.isAllowOnMove() && dockable.getController().getRelocator().isOnMove()) {
            return false;
        }
        DockActionSource dockActionSource = this.getActions();
        if (!popupController.isAllowEmptyMenu() && dockActionSource.getDockActionCount() == 0) {
            return false;
        }
        if (this.isSuppressable() && dockable.getController().getPopupSuppressor().suppress(dockable, dockActionSource)) {
            return false;
        }
        final ActionPopupMenu actionPopupMenu = this.getFactory().createMenu(component, dockable, dockActionSource, this.getSource());
        if (actionPopupMenu == null) {
            return false;
        }
        this.menu = actionPopupMenu;
        this.menu.addListener(new ActionPopupMenuListener(){

            @Override
            public void closed(ActionPopupMenu actionPopupMenu2) {
                if (actionPopupMenu == actionPopupMenu2) {
                    ActionPopup.this.menu = null;
                }
            }
        });
        this.menu.show(component, point.x, point.y);
        return true;
    }

    public boolean isMenuOpen() {
        return this.menu != null;
    }
}

