/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ButtonContentFilter;
import bibliothek.gui.dock.action.ButtonContentFilterListener;
import bibliothek.gui.dock.action.DockAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractButtonContentFilter
implements ButtonContentFilter {
    private List<ButtonContentFilterListener> listeners = new ArrayList<ButtonContentFilterListener>();
    private Map<DockAction, Map<Dockable, Integer>> count = new HashMap<DockAction, Map<Dockable, Integer>>();

    @Override
    public void addListener(ButtonContentFilterListener buttonContentFilterListener) {
        this.listeners.add(buttonContentFilterListener);
    }

    @Override
    public void removeListener(ButtonContentFilterListener buttonContentFilterListener) {
        this.listeners.remove(buttonContentFilterListener);
    }

    protected void fire(Dockable dockable, DockAction dockAction) {
        ButtonContentFilterListener[] buttonContentFilterListenerArray = this.listeners.toArray(new ButtonContentFilterListener[this.listeners.size()]);
        int n = buttonContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonContentFilterListener buttonContentFilterListener = buttonContentFilterListenerArray[n2];
            buttonContentFilterListener.showTextChanged(this, dockable, dockAction);
            ++n2;
        }
    }

    protected void installed(DockAction dockAction, Dockable dockable) {
    }

    protected void installed(DockAction dockAction) {
    }

    protected void uninstalled(DockAction dockAction, Dockable dockable) {
    }

    protected void uninstalled(DockAction dockAction) {
    }

    @Override
    public void install(Dockable dockable, DockAction dockAction) {
        Integer n;
        Map<Dockable, Integer> map = this.count.get(dockAction);
        if (map == null) {
            map = new HashMap<Dockable, Integer>();
            this.count.put(dockAction, map);
            this.installed(dockAction);
        }
        if ((n = map.get(dockable)) == null) {
            n = 1;
            this.installed(dockAction, dockable);
        } else {
            n = n + 1;
        }
        map.put(dockable, n);
    }

    @Override
    public void uninstall(Dockable dockable, DockAction dockAction) {
        Map<Dockable, Integer> map = this.count.get(dockAction);
        Integer n = map.get(dockable);
        if (n == 1) {
            map.remove(dockable);
            this.uninstalled(dockAction, dockable);
        } else {
            map.put(dockable, n - 1);
        }
        if (map.isEmpty()) {
            this.count.remove(dockAction);
            this.uninstalled(dockAction);
        }
    }
}

