/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.stack.DefaultStackDockComponent;
import bibliothek.gui.dock.station.stack.DndAutoSelectStrategy;
import bibliothek.gui.dock.station.stack.StackDnDAutoSelectSupport;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.TabDropLayer;
import bibliothek.gui.dock.station.stack.tab.TabConfigurations;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ComponentDragOperation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class StackDockStation
extends AbstractDockableStation
implements StackDockComponentParent {
    public static final String TITLE_ID = "stack";
    public static final PropertyKey<StackDockComponentFactory> COMPONENT_FACTORY = new PropertyKey("stack dock component factory");
    public static final PropertyKey<TabPlacement> TAB_PLACEMENT = new PropertyKey<TabPlacement>("stack dock station tab side", new ConstantPropertyFactory<TabPlacement>(TabPlacement.TOP_OF_DOCKABLE), true);
    public static final PropertyKey<TabContentFilter> TAB_CONTENT_FILTER = new PropertyKey("stack dock tab content filter");
    public static final PropertyKey<Boolean> IMMUTABLE_SELECTION_INDEX = new PropertyKey<Boolean>("stack dock immutable selection index", new ConstantPropertyFactory<Boolean>(false), true);
    public static final PropertyKey<TabConfigurations> TAB_CONFIGURATIONS = new PropertyKey<TabConfigurations>("stack dock tab configurations", new ConstantPropertyFactory<TabConfigurations>(TabConfigurations.DEFAULT), true);
    public static final PropertyKey<StackDnDAutoSelectSupport> DND_AUTO_SELECT_SUPPORT = new PropertyKey("stack dock auto select");
    public static final PropertyKey<DndAutoSelectStrategy> DND_AUTO_SELECT_STRATEGY = new PropertyKey<DndAutoSelectStrategy>("stack dock auto select strategy", new ConstantPropertyFactory<DndAutoSelectStrategy>(DndAutoSelectStrategy.DEFAULT), true);
    private DockablePlaceholderList<StationChildHandle> dockables = new DockablePlaceholderList();
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private DockableShowingManager visibility;
    private DefaultStationPaintValue paint;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private Insert insert;
    private ComponentDragOperation dragOperation;
    private Background background;
    private JComponent panel;
    private PanelBackground panelBackground = new PanelBackground();
    private StackDockComponent stackComponent;
    private StackDockComponentRepresentative stackComponentRepresentative;
    private PropertyValue<StackDockComponentFactory> stackComponentFactory;
    private PropertyValue<TabPlacement> tabPlacement;
    private DockTitleVersion title;
    private Listener listener = new Listener();
    private boolean smallMinimumSize = true;
    private boolean updatingTheme = false;
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            StackDockStation.this.dockables.setStrategy(placeholderStrategy2);
        }
    };
    private PropertyValue<TabContentFilter> tabContentFilter = new PropertyValue<TabContentFilter>(TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter tabContentFilter, TabContentFilter tabContentFilter2) {
            if (tabContentFilter != tabContentFilter2) {
                if (tabContentFilter != null) {
                    tabContentFilter.removeListener(StackDockStation.this.tabContentFilterListener);
                    tabContentFilter.uninstall(StackDockStation.this);
                }
                if (tabContentFilter2 != null) {
                    tabContentFilter2.install(StackDockStation.this);
                    tabContentFilter2.addListener(StackDockStation.this.tabContentFilterListener);
                }
                StackDockStation.this.tabContentFilterListener.contentChanged();
            }
        }
    };
    private TabContentFilterListener tabContentFilterListener = new TabContentFilterListener(){

        @Override
        public void contentChanged() {
            int n = StackDockStation.this.getDockableCount();
            int n2 = 0;
            while (n2 < n) {
                StackDockStation.this.updateContent(n2);
                ++n2;
            }
        }

        @Override
        public void contentChanged(StackDockComponent stackDockComponent) {
        }

        @Override
        public void contentChanged(StackDockStation stackDockStation) {
            if (StackDockStation.this == stackDockStation) {
                this.contentChanged();
            }
        }

        @Override
        public void contentChanged(Dockable dockable) {
            int n;
            if (dockable.getDockParent() == StackDockStation.this && (n = StackDockStation.this.indexOf(dockable)) >= 0) {
                StackDockStation.this.updateContent(n);
            }
        }
    };
    private PropertyValue<StackDnDAutoSelectSupport> autoSelectSupport = new PropertyValue<StackDnDAutoSelectSupport>(DND_AUTO_SELECT_SUPPORT){

        @Override
        protected void valueChanged(StackDnDAutoSelectSupport stackDnDAutoSelectSupport, StackDnDAutoSelectSupport stackDnDAutoSelectSupport2) {
            StackDockComponent stackDockComponent = StackDockStation.this.getStackComponent();
            if (stackDockComponent != null) {
                if (stackDnDAutoSelectSupport != null) {
                    stackDnDAutoSelectSupport.uninstall(stackDockComponent);
                }
                if (stackDnDAutoSelectSupport2 != null) {
                    stackDnDAutoSelectSupport2.install(StackDockStation.this, stackDockComponent);
                }
            }
        }
    };
    private VisibleListener visibleListener;
    private Dockable lastSelectedDockable = null;

    public StackDockStation() {
        this(null);
    }

    public StackDockStation(DockTheme dockTheme) {
        super(dockTheme);
        this.init();
    }

    protected StackDockStation(DockTheme dockTheme, boolean bl) {
        super(dockTheme);
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.paint = new DefaultStationPaintValue("dock.paint.stack", this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.stack", this);
        this.visibleListener = new VisibleListener();
        this.visibility = new DockableShowingManager(this.listeners);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory);
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer dockableDisplayer) {
                StackDockStation.this.discard(dockableDisplayer);
            }

            @Override
            public void moveableElementChanged(DockableDisplayer dockableDisplayer) {
            }
        });
        this.background = this.createBackground();
        this.background.setController(this.getController());
        this.panel = this.background.getContentPane();
        this.stackComponentFactory = new PropertyValue<StackDockComponentFactory>(COMPONENT_FACTORY){

            @Override
            protected void valueChanged(StackDockComponentFactory stackDockComponentFactory, StackDockComponentFactory stackDockComponentFactory2) {
                if (stackDockComponentFactory2 == null) {
                    StackDockStation.this.setStackComponent(StackDockStation.this.createStackDockComponent());
                } else {
                    StackDockStation.this.setStackComponent(stackDockComponentFactory2.create(StackDockStation.this));
                }
            }
        };
        this.tabPlacement = new PropertyValue<TabPlacement>(TAB_PLACEMENT){

            @Override
            protected void valueChanged(TabPlacement tabPlacement, TabPlacement tabPlacement2) {
                if (StackDockStation.this.stackComponent != null) {
                    StackDockStation.this.stackComponent.setDockTabPlacement(tabPlacement2);
                }
            }
        };
        this.stackComponent = this.createStackDockComponent();
        this.stackComponent.addStackDockComponentListener(this.visibleListener);
        this.stackComponentRepresentative = new StackDockComponentRepresentative();
        this.stackComponentRepresentative.setComponent(this.stackComponent);
        this.stackComponentRepresentative.setTarget(this);
        this.addDockStationListener(new DockStationAdapter(){

            @Override
            public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                StackDockStation.this.lastSelectedDockable = dockable2;
            }
        });
        this.panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (StackDockStation.this.getDockParent() == null) {
                        StackDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    StackDockStation.this.visibility.fire();
                }
            }
        });
    }

    protected Background createBackground() {
        return new Background();
    }

    protected StackDockComponent createStackDockComponent() {
        return new DefaultStackDockComponent();
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    @Override
    public DockStation getStackDockParent() {
        return this;
    }

    public void setTabPlacement(TabPlacement tabPlacement) {
        this.tabPlacement.setValue(tabPlacement);
    }

    public TabPlacement getTabPlacement() {
        return this.tabPlacement.getValue();
    }

    public void setTabContentFilter(TabContentFilter tabContentFilter) {
        this.tabContentFilter.setValue(tabContentFilter);
    }

    public TabContentFilter getTabContentFilter() {
        return this.tabContentFilter.getValue();
    }

    protected boolean singleTabStackDockComponent() {
        StackDockComponent stackDockComponent = this.getStackComponent();
        if (stackDockComponent == null) {
            return false;
        }
        return stackDockComponent.isSingleTabComponent();
    }

    public void setStackComponent(StackDockComponent stackDockComponent) {
        if (stackDockComponent == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        if (stackDockComponent != this.stackComponent) {
            Object object32;
            int n = -1;
            StackDnDAutoSelectSupport stackDnDAutoSelectSupport = this.autoSelectSupport.getValue();
            if (this.stackComponent != null) {
                this.stackComponent.setController(null);
                object32 = this.stackComponent.getComponent();
                for (MouseInputListener object2 : this.mouseInputListeners) {
                    ((Component)object32).removeMouseListener(object2);
                    ((Component)object32).removeMouseMotionListener(object2);
                }
                n = this.stackComponent.getSelectedIndex();
                this.stackComponent.removeStackDockComponentListener(this.visibleListener);
                this.stackComponent.removeAll();
                if (stackDnDAutoSelectSupport != null) {
                    stackDnDAutoSelectSupport.uninstall(this.stackComponent);
                }
            }
            this.stackComponent = stackDockComponent;
            stackDockComponent.setDockTabPlacement(this.tabPlacement.getValue());
            this.stackComponentRepresentative.setComponent(stackDockComponent);
            if (this.getDockableCount() < 2 && !this.singleTabStackDockComponent()) {
                stackDockComponent.addStackDockComponentListener(this.visibleListener);
            } else {
                this.panel.removeAll();
                for (Object object32 : this.dockables.dockables()) {
                    DockableDisplayer dockableDisplayer = ((StationChildHandle)object32).getDisplayer();
                    int n2 = stackDockComponent.getTabCount();
                    this.insertTab(dockableDisplayer, n2);
                }
                this.panel.add(stackDockComponent.getComponent());
                if (n >= 0 && n < stackDockComponent.getTabCount()) {
                    stackDockComponent.setSelectedIndex(n);
                }
                stackDockComponent.addStackDockComponentListener(this.visibleListener);
            }
            object32 = stackDockComponent.getComponent();
            stackDockComponent.setController(this.getController());
            for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                ((Component)object32).addMouseListener(mouseInputListener);
                ((Component)object32).addMouseMotionListener(mouseInputListener);
            }
            if (stackDnDAutoSelectSupport != null) {
                stackDnDAutoSelectSupport.install(this, this.stackComponent);
            }
            this.updateConfigurableDisplayerHints();
        }
    }

    public StackDockComponent getStackComponent() {
        return this.stackComponent;
    }

    public void setStackComponentFactory(StackDockComponentFactory stackDockComponentFactory) {
        this.stackComponentFactory.setValue(stackDockComponentFactory);
    }

    public StackDockComponentFactory getStackComponentFactory() {
        return this.stackComponentFactory.getOwnValue();
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        try {
            this.updatingTheme = true;
            DockUI.updateTheme(this, new StackDockStationFactory());
        }
        finally {
            this.updatingTheme = false;
        }
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        DockStation dockStation2 = this.getDockParent();
        if (dockStation2 != null) {
            dockStation2.removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            boolean bl;
            for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                stationChildHandle.setTitleRequest(null);
            }
            boolean bl2 = this.getController() == null;
            this.background.setController(dockController);
            this.stackComponentFactory.setProperties(dockController);
            super.setController(dockController);
            this.stackComponent.setController(dockController);
            this.tabPlacement.setProperties(dockController);
            this.placeholderStrategy.setProperties(dockController);
            this.tabContentFilter.setProperties(dockController);
            this.stackComponentRepresentative.setController(dockController);
            this.paint.setController(dockController);
            this.displayerFactory.setController(dockController);
            this.panelBackground.setController(dockController);
            this.autoSelectSupport.setProperties(dockController);
            this.title = dockController != null ? dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE) : null;
            this.displayers.setController(dockController);
            boolean bl3 = bl = dockController == null;
            if (bl2 != bl) {
                if (bl2) {
                    this.dockables.bind();
                } else {
                    this.dockables.unbind();
                }
            }
            for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                stationChildHandle.setTitleRequest(this.title, true);
            }
            this.visibility.fire();
        }
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    @Override
    public boolean isStationVisible() {
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isChildShowing(this);
        }
        return this.panel.isDisplayable();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (this.dockables.dockables().size() == 1 || this.indexOf(dockable) == this.stackComponent.getSelectedIndex());
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return ((StationChildHandle)this.dockables.dockables().get(n)).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        Path path = null;
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2 == null ? dockable : dockable2)) != null) {
            this.dockables.dockables().addPlaceholder(n, path);
        }
        return new StackDockProperty(n, path);
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        int n;
        DockableProperty dockableProperty = asideRequest.getLocation();
        Path path = asideRequest.getPlaceholder();
        if (dockableProperty instanceof StackDockProperty) {
            StackDockProperty stackDockProperty = (StackDockProperty)dockableProperty;
            n = this.dockables.getNextListIndex(stackDockProperty.getIndex(), stackDockProperty.getPlaceholder());
            if (path != null) {
                this.dockables.list().insertPlaceholder(n, path);
            }
        } else {
            n = this.dockables.dockables().size();
            if (path != null) {
                this.dockables.dockables().insertPlaceholder(n, path);
            }
        }
        asideRequest.answer(new StackDockProperty(n, path));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.dockables.dockables().size() == 0) {
            return null;
        }
        if (this.dockables.dockables().size() == 1) {
            return ((StationChildHandle)this.dockables.dockables().get(0)).getDockable();
        }
        int n = this.stackComponent.getSelectedIndex();
        if (n >= 0) {
            return ((StationChildHandle)this.dockables.dockables().get(n)).getDockable();
        }
        return null;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        if (this.dockables.dockables().size() > 1 && dockable != null) {
            this.stackComponent.setSelectedIndex(this.indexOf(dockable));
        }
        this.fireDockableSelected();
    }

    protected void fireDockableSelected() {
        Dockable dockable = this.getFrontDockable();
        if (this.lastSelectedDockable != dockable) {
            this.listeners.fireDockableSelected(this.lastSelectedDockable, dockable);
        }
    }

    @Override
    public int indexOf(Dockable dockable) {
        int n = 0;
        for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
            if (stationChildHandle.getDockable() == dockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            @Override
            public DockableProperty getLocationAt(Path path) {
                int n = StackDockStation.this.dockables.getDockableIndex(path);
                return new StackDockProperty(n, path);
            }
        };
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        try {
            DockablePlaceholderList dockablePlaceholderList = new DockablePlaceholderList(placeholderMap);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = dockablePlaceholderList;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = dockablePlaceholderList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> map) {
        this.dockables.insertAllPlaceholders();
        final PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        return this.dockables.toMap(new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, StationChildHandle stationChildHandle) {
                Path path;
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                Integer n2 = (Integer)map.get(stationChildHandle.getDockable());
                if (n2 == null) {
                    return null;
                }
                convertedPlaceholderListItem.putInt("id", n2);
                convertedPlaceholderListItem.putInt("index", n);
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(stationChildHandle.getDockable())) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }

            @Override
            public StationChildHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                return null;
            }
        });
    }

    public void setPlaceholders(PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            this.dockables.setStrategy(null);
            this.dockables.unbind();
            DockablePlaceholderList<StationChildHandle> dockablePlaceholderList = new DockablePlaceholderList<StationChildHandle>();
            this.dockables = dockablePlaceholderList;
            dockablePlaceholderList.read(placeholderMap, new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){
                private DockHierarchyLock.Token token;
                private int size = 0;

                @Override
                public StationChildHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    Dockable dockable = (Dockable)map.get(n);
                    if (dockable == null) {
                        return null;
                    }
                    DockUtilities.ensureTreeValidity(StackDockStation.this, dockable);
                    this.token = DockHierarchyLock.acquireLinking(StackDockStation.this, dockable);
                    StackDockStation.this.listeners.fireDockableAdding(dockable);
                    dockable.addDockableListener(StackDockStation.this.listener);
                    StationChildHandle stationChildHandle = new StationChildHandle(StackDockStation.this, StackDockStation.this.getDisplayers(), dockable, StackDockStation.this.title);
                    return stationChildHandle;
                }

                @Override
                public void added(StationChildHandle stationChildHandle) {
                    try {
                        Dockable dockable = stationChildHandle.getDockable();
                        dockable.setDockParent(StackDockStation.this);
                        stationChildHandle.updateDisplayer();
                        StackDockStation.this.addToPanel(stationChildHandle, this.size, this.size);
                        ++this.size;
                        StackDockStation.this.listeners.fireDockableAdded(dockable);
                    }
                    finally {
                        this.token.release();
                    }
                }
            });
            if (dockController != null) {
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    public void setSmallMinimumSize(boolean bl) {
        this.smallMinimumSize = bl;
        this.getComponent().invalidate();
    }

    public boolean isSmallMinimumSize() {
        return this.smallMinimumSize;
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this), new TabDropLayer(this)};
    }

    public boolean isOverTabs(int n, int n2) {
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.panel);
        return this.exactTabIndexAt(point.x, point.y) != null;
    }

    public boolean isOverTitle(int n, int n2) {
        DockTitle dockTitle;
        if (this.dockables.dockables().size() == 1 && (dockTitle = ((StationChildHandle)this.dockables.dockables().get(0)).getDisplayer().getTitle()) != null) {
            Component component = dockTitle.getComponent();
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, component);
            return component.getBounds().contains(point);
        }
        return false;
    }

    public StationDropOperation prepareMove(StationDropItem stationDropItem) {
        Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
        SwingUtilities.convertPointFromScreen(point, this.panel);
        Insert insert = this.tabIndexAt(point.x, point.y);
        if (this.validate(insert, stationDropItem.getDockable())) {
            return new StackDropOperation(stationDropItem.getDockable(), insert, true);
        }
        return null;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem stationDropItem) {
        if (stationDropItem.getDockable().getDockParent() == this) {
            return this.prepareMove(stationDropItem);
        }
        if (SwingUtilities.isDescendingFrom(this.getComponent(), stationDropItem.getDockable().getComponent())) {
            return null;
        }
        Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
        SwingUtilities.convertPointFromScreen(point, this.panel);
        Insert insert = this.tabIndexAt(point.x, point.y);
        if (this.validate(insert, stationDropItem.getDockable())) {
            return new StackDropOperation(stationDropItem.getDockable(), insert, false);
        }
        return null;
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        this.dragOperation = new ComponentDragOperation(dockable, this.getComponent()){

            @Override
            protected void destroy() {
                StackDockStation.this.dragOperation = null;
            }
        };
        return this.dragOperation;
    }

    @Override
    public void drop(Dockable dockable) {
        this.drop(dockable, true);
    }

    public void drop(Dockable dockable, boolean bl) {
        Path path = null;
        if (bl) {
            PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
            path = placeholderStrategy == null ? null : placeholderStrategy.getPlaceholderFor(dockable);
        }
        boolean bl2 = false;
        if (path != null) {
            bl2 = this.drop(dockable, new StackDockProperty(this.dockables.dockables().size(), path));
        }
        if (!bl2) {
            this.add(dockable, this.dockables.dockables().size(), null);
        }
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            return this.drop(dockable, (StackDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, StackDockProperty stackDockProperty) {
        Object object;
        DockUtilities.checkLayoutLocked();
        int n = stackDockProperty.getIndex();
        Path path = stackDockProperty.getPlaceholder();
        boolean bl = this.acceptable(dockable);
        DockableProperty dockableProperty = stackDockProperty.getSuccessor();
        boolean bl2 = false;
        if (path != null && dockableProperty != null) {
            DockStation dockStation;
            object = (StationChildHandle)this.dockables.getDockableAt(path);
            if (object != null && (dockStation = ((StationChildHandle)object).getDockable().asDockStation()) != null && dockStation.drop(dockable, dockableProperty)) {
                bl2 = true;
                this.dockables.removeAll(path);
            }
        } else if (path != null && bl && this.dockables.hasPlaceholder(path)) {
            this.add(dockable, 0, path);
            bl2 = true;
        }
        if (!bl2 && this.dockables.dockables().size() == 0 && bl) {
            this.drop(dockable, false);
            bl2 = true;
        }
        if (!bl2) {
            if ((n = Math.min(n, this.dockables.dockables().size())) < this.dockables.dockables().size() && dockableProperty != null && (object = ((StationChildHandle)this.dockables.dockables().get(n)).getDockable().asDockStation()) != null && object.drop(dockable, dockableProperty)) {
                bl2 = true;
            }
            if (!bl2 && bl) {
                this.add(dockable, n);
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean validate(Insert insert, Dockable dockable) {
        return insert != null && this.accept(dockable) && dockable.accept(this) && this.getController().getAcceptance().accept(this, dockable);
    }

    public Insert getInsert() {
        return this.insert;
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            DockUtilities.checkLayoutLocked();
            int n = this.indexOf(dockable);
            if (n < 0) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            int n2 = ((StackDockProperty)dockableProperty).getIndex();
            n2 = Math.min(n2, this.getDockableCount() - 1);
            n2 = Math.max(0, n2);
            this.move(n, n2);
        }
    }

    private void move(int n, int n2) {
        if (n != n2) {
            DockUtilities.checkLayoutLocked();
            this.dockables.dockables().move(n, n2);
            this.stackComponent.moveTab(n, n2);
            this.fireDockablesRepositioned(Math.min(n, n2), Math.max(n, n2));
        }
    }

    protected Insert tabIndexAt(int n, int n2) {
        if (this.dockables.dockables().size() == 0) {
            return new Insert(0, false);
        }
        if (this.dockables.dockables().size() == 1) {
            return new Insert(1, false);
        }
        Insert insert = this.exactTabIndexAt(n, n2);
        if (insert == null) {
            insert = new Insert(this.dockables.dockables().size() - 1, true);
        }
        return insert;
    }

    protected Insert exactTabIndexAt(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this.panel, n, n2, this.stackComponent.getComponent());
        int n3 = this.dockables.dockables().size();
        if (n3 > 1 || this.singleTabStackDockComponent()) {
            int n4 = 0;
            while (n4 < n3) {
                Rectangle rectangle = this.stackComponent.getBoundsAt(n4);
                if (rectangle != null && rectangle.contains(point)) {
                    if (this.tabPlacement.getValue().isHorizontal()) {
                        return new Insert(n4, rectangle.x + rectangle.width / 2 < point.x);
                    }
                    return new Insert(n4, rectangle.y + rectangle.height / 2 < point.y);
                }
                ++n4;
            }
        }
        return null;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("The dockable is not part of this station.");
        }
        this.remove(n);
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    public void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int n = this.indexOf(dockable);
            int n2 = this.dockables.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.dockables.list().get(n2);
            this.remove(n);
            this.add(dockable2, n);
            PlaceholderList.Item item2 = this.dockables.list().get(n2);
            if (bl) {
                item2.setPlaceholderMap(dockable.asDockStation().getPlaceholders());
            } else {
                item2.setPlaceholderMap(item.getPlaceholderMap());
            }
            item2.setPlaceholderSet(item.getPlaceholderSet());
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public void add(Dockable dockable, int n) {
        this.add(dockable, n, null);
    }

    protected void add(Dockable dockable, int n, Path path) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockUtilities.checkLayoutLocked();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            StationChildHandle stationChildHandle = new StationChildHandle(this, this.getDisplayers(), dockable, this.title);
            stationChildHandle.updateDisplayer();
            int n2 = -1;
            if (path != null && this.dockables.getDockableAt(path) == null) {
                n2 = this.dockables.put(path, stationChildHandle);
            } else if (path != null) {
                n = this.dockables.getDockableIndex(path);
            }
            if (n2 == -1) {
                this.dockables.dockables().add(n, stationChildHandle);
            } else {
                n = n2;
            }
            this.addToPanel(stationChildHandle, n, this.dockables.dockables().size() - 1);
            dockable.setDockParent(this);
            dockable.addDockableListener(this.listener);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(n + 1);
            this.fireDockableSelected();
        }
        finally {
            token.release();
        }
    }

    protected void addToPanel(StationChildHandle stationChildHandle, int n, int n2) {
        if (n2 == 0 && !this.singleTabStackDockComponent()) {
            DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
            this.panel.add(dockableDisplayer.getComponent());
        } else {
            Object object;
            int n3 = n;
            int n4 = 0;
            if (n2 == 1 && !this.singleTabStackDockComponent()) {
                this.panel.removeAll();
                object = this.dockables.dockables();
                if (object.get(0) == stationChildHandle) {
                    if (object.size() != 2) {
                        throw new IllegalStateException("handle is stored, size is 1, but number of known dockables is not 2");
                    }
                    stationChildHandle = (StationChildHandle)object.get(1);
                    n = 1;
                }
                DockableDisplayer dockableDisplayer = ((StationChildHandle)object.get(0)).getDisplayer();
                this.insertTab(dockableDisplayer, 0);
                this.panel.add(this.stackComponent.getComponent());
            } else {
                n4 = this.stackComponent.getSelectedIndex();
                if (n <= n4) {
                    ++n4;
                }
            }
            object = stationChildHandle.getDisplayer();
            this.insertTab((DockableDisplayer)object, n);
            if (this.isImmutableSelectedIndex()) {
                this.stackComponent.setSelectedIndex(n4);
            } else {
                this.stackComponent.setSelectedIndex(n3);
            }
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private boolean isImmutableSelectedIndex() {
        DockController dockController = this.getController();
        if (dockController == null) {
            return IMMUTABLE_SELECTION_INDEX.getDefault(null);
        }
        return dockController.getProperties().get(IMMUTABLE_SELECTION_INDEX);
    }

    private void insertTab(DockableDisplayer dockableDisplayer, int n) {
        Dockable dockable = dockableDisplayer.getDockable();
        String string = dockable.getTitleText();
        String string2 = dockable.getTitleToolTip();
        Icon icon = dockable.getTitleIcon();
        TabContentFilter tabContentFilter = this.getTabContentFilter();
        if (tabContentFilter != null) {
            TabContent tabContent = new TabContent(icon, string, string2);
            if ((tabContent = tabContentFilter.filter(tabContent, this, dockable)) == null) {
                string = null;
                string2 = null;
                icon = null;
            } else {
                string = tabContent.getTitle();
                string2 = tabContent.getTooltip();
                icon = tabContent.getIcon();
            }
        }
        this.stackComponent.insertTab(string, icon, dockableDisplayer.getComponent(), dockable, n);
        this.stackComponent.setTooltipAt(n, string2);
    }

    protected void discard(DockableDisplayer dockableDisplayer) {
        Dockable dockable = dockableDisplayer.getDockable();
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("displayer is not a child of this station: " + dockableDisplayer);
        }
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.dockables().get(n);
        stationChildHandle.updateDisplayer();
        dockableDisplayer = stationChildHandle.getDisplayer();
        if (this.dockables.dockables().size() == 1 && this.singleTabStackDockComponent()) {
            this.panel.removeAll();
            this.panel.add(dockableDisplayer.getComponent());
        } else {
            this.stackComponent.setComponentAt(n, dockableDisplayer.getComponent());
        }
    }

    public void remove(int n) {
        if (n < 0 || n >= this.dockables.dockables().size()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        DockUtilities.checkLayoutLocked();
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.dockables().get(n);
        Dockable dockable = stationChildHandle.getDockable();
        boolean bl = false;
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.removeDockableListener(this.listener);
            this.visibleListener.ignoreSelectionChanges = true;
            if (this.dockables.dockables().size() == 1) {
                if (this.singleTabStackDockComponent()) {
                    this.stackComponent.remove(0);
                } else {
                    this.panel.remove(((StationChildHandle)this.dockables.dockables().get(0)).getDisplayer().getComponent());
                }
                this.dockables.remove(0);
                this.panel.repaint();
            } else if (this.dockables.dockables().size() == 2 && !this.singleTabStackDockComponent()) {
                this.panel.remove(this.stackComponent.getComponent());
                this.dockables.remove(n);
                this.stackComponent.removeAll();
                this.panel.add(((StationChildHandle)this.dockables.dockables().get(0)).getDisplayer().getComponent());
            } else {
                bl = n == this.stackComponent.getSelectedIndex();
                this.dockables.remove(n);
                this.stackComponent.remove(n);
            }
            stationChildHandle.destroy();
            dockable.setDockParent(null);
            this.visibleListener.ignoreSelectionChanges = false;
            this.focusAfterRemoving(bl);
            this.panel.revalidate();
            this.listeners.fireDockableRemoved(dockable);
        }
        finally {
            this.visibleListener.ignoreSelectionChanges = false;
            token.release();
        }
        this.fireDockablesRepositioned(n);
        this.fireDockableSelected();
    }

    private void focusAfterRemoving(boolean bl) {
        Dockable dockable;
        DockController dockController;
        if (bl && (dockController = this.getController()) != null && this.dockables.dockables().size() > 1 && (dockable = dockController.getFocusHistory().getNewestOn(this)) != null && dockable.getDockParent() == this) {
            this.stackComponent.setSelectedIndex(this.indexOf(dockable));
            return;
        }
        this.visibleListener.selectionChanged(this.stackComponent);
    }

    @Override
    public Component getComponent() {
        return this.background;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        super.configureDisplayerHints(dockableDisplayerHints);
        this.updateConfigurableDisplayerHints();
    }

    protected void updateConfigurableDisplayerHints() {
        DockableDisplayerHints dockableDisplayerHints = this.getConfigurableDisplayerHints();
        if (dockableDisplayerHints != null) {
            dockableDisplayerHints.setShowBorderHint(!this.getStackComponent().hasBorder());
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.panel.addMouseListener(mouseInputListener);
        this.panel.addMouseMotionListener(mouseInputListener);
        this.mouseInputListeners.add(mouseInputListener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().addMouseListener(mouseInputListener);
            this.stackComponent.getComponent().addMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.panel.removeMouseListener(mouseInputListener);
        this.panel.removeMouseMotionListener(mouseInputListener);
        this.mouseInputListeners.remove(mouseInputListener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().removeMouseListener(mouseInputListener);
            this.stackComponent.getComponent().removeMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public String getFactoryID() {
        return "StackDockStationFactory";
    }

    private void updateContent(int n) {
        if (n >= 0 && (this.getDockableCount() > 1 || this.singleTabStackDockComponent())) {
            Dockable dockable = this.getDockable(n);
            TabContentFilter tabContentFilter = this.getTabContentFilter();
            TabContent tabContent = new TabContent(dockable.getTitleIcon(), dockable.getTitleText(), dockable.getTitleToolTip());
            if (tabContentFilter != null) {
                tabContent = tabContentFilter.filter(tabContent, this, dockable);
            }
            if (tabContent == null) {
                this.stackComponent.setTitleAt(n, null);
                this.stackComponent.setIconAt(n, null);
                this.stackComponent.setTooltipAt(n, null);
            } else {
                this.stackComponent.setTitleAt(n, tabContent.getTitle());
                this.stackComponent.setIconAt(n, tabContent.getIcon());
                this.stackComponent.setTooltipAt(n, tabContent.getTooltip());
            }
        }
    }

    protected void insertionLine(Rectangle rectangle, Rectangle rectangle2, Point point, Point point2, boolean bl) {
        if (this.tabPlacement.getValue().isHorizontal()) {
            if (rectangle != null && rectangle2 != null) {
                int n;
                int n2 = Math.max(rectangle.y, rectangle2.y);
                int n3 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
                if (n3 > n2 && (double)(n = n3 - n2) >= 0.8 * (double)rectangle.height && (double)n >= 0.8 * (double)rectangle2.height) {
                    point.x = (rectangle.x + rectangle.width + rectangle2.x) / 2;
                    point.y = n2;
                    point2.x = point.x;
                    point2.y = n3;
                    return;
                }
            }
            if (bl) {
                point.x = rectangle.x + rectangle.width;
                point.y = rectangle.y;
                point2.x = point.x;
                point2.y = point.y + rectangle.height;
            } else {
                point.x = rectangle2.x;
                point.y = rectangle2.y;
                point2.x = point.x;
                point2.y = point.y + rectangle2.height;
            }
        } else {
            if (rectangle != null && rectangle2 != null) {
                int n;
                int n4 = Math.max(rectangle.x, rectangle2.x);
                int n5 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                if (n5 > n4 && (double)(n = n5 - n4) >= 0.8 * (double)rectangle.width && (double)n >= 0.8 * (double)rectangle2.width) {
                    point.y = (rectangle.y + rectangle.height + rectangle2.y) / 2;
                    point.x = n4;
                    point2.y = point.y;
                    point2.x = n5;
                    return;
                }
            }
            if (bl) {
                point.y = rectangle.y + rectangle.height;
                point.x = rectangle.x;
                point2.y = point.y;
                point2.x = point.x + rectangle.width;
            } else {
                point.y = rectangle2.y;
                point.x = rectangle2.x;
                point2.y = point.y;
                point2.x = point.x + rectangle2.width;
            }
        }
    }

    protected class Background
    extends SecureContainer {
        private BackgroundPanel content = new ConfiguredBackgroundPanel(Transparency.SOLID){

            @Override
            public void setTransparency(Transparency transparency) {
                super.setTransparency(transparency);
                Background.this.setSolid(transparency == Transparency.SOLID);
            }
        };

        public Background() {
            this.content.setBackground(StackDockStation.this.panelBackground);
            this.setBasePane(this.content);
            this.content.setLayout(new GridLayout(1, 1));
        }

        @Override
        public Dimension getMinimumSize() {
            if (StackDockStation.this.isSmallMinimumSize()) {
                return new Dimension(5, 5);
            }
            return super.getMinimumSize();
        }

        @Override
        protected void paintOverlay(Graphics graphics) {
            Cloneable cloneable;
            Rectangle rectangle;
            DefaultStationPaintValue defaultStationPaintValue = StackDockStation.this.getPaint();
            if (StackDockStation.this.insert != null && StackDockStation.this.dockables.dockables().size() > 1) {
                rectangle = null;
                if (StackDockStation.this.insert.tab >= 0 && StackDockStation.this.insert.tab < StackDockStation.this.stackComponent.getTabCount()) {
                    rectangle = StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab);
                }
                if (rectangle != null) {
                    cloneable = new Point();
                    Point point = new Point();
                    if (StackDockStation.this.insert.right) {
                        StackDockStation.this.insertionLine(rectangle, StackDockStation.this.insert.tab + 1 < StackDockStation.this.stackComponent.getTabCount() ? StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab + 1) : null, (Point)cloneable, point, true);
                    } else {
                        StackDockStation.this.insertionLine(StackDockStation.this.insert.tab > 0 ? StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab - 1) : null, rectangle, (Point)cloneable, point, false);
                    }
                    defaultStationPaintValue.drawInsertionLine(graphics, cloneable.x, cloneable.y, point.x, point.y);
                }
            }
            if (StackDockStation.this.insert != null || StackDockStation.this.dragOperation != null && StackDockStation.this.dragOperation.getDockable() != null) {
                rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                cloneable = null;
                if (StackDockStation.this.getDockableCount() < 2) {
                    cloneable = rectangle;
                } else {
                    int n = StackDockStation.this.stackComponent.getSelectedIndex();
                    if (n >= 0) {
                        Component component = ((StationChildHandle)StackDockStation.this.dockables.dockables().get(n)).getDisplayer().getComponent();
                        Point point = new Point(0, 0);
                        point = SwingUtilities.convertPoint(component, point, this);
                        cloneable = new Rectangle(point.x, point.y, component.getWidth(), component.getHeight());
                    }
                }
                if (cloneable != null) {
                    if (StackDockStation.this.insert != null) {
                        defaultStationPaintValue.drawInsertion(graphics, rectangle, (Rectangle)cloneable);
                    } else if (StackDockStation.this.dragOperation != null && StackDockStation.this.dragOperation.getDockable() != null) {
                        defaultStationPaintValue.drawRemoval(graphics, rectangle, (Rectangle)cloneable);
                    }
                }
            }
        }
    }

    public static class Insert {
        private final int tab;
        private final boolean right;

        public Insert(int n, boolean bl) {
            this.tab = n;
            this.right = bl;
        }

        public int getTab() {
            return this.tab;
        }

        public boolean isRight() {
            return this.right;
        }
    }

    private class Listener
    implements DockableListener {
        private Listener() {
        }

        @Override
        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        @Override
        public void titleTextChanged(Dockable dockable, String string, String string2) {
            int n = StackDockStation.this.indexOf(dockable);
            if (n >= 0) {
                StackDockStation.this.updateContent(n);
            }
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            int n = StackDockStation.this.indexOf(dockable);
            if (n >= 0) {
                StackDockStation.this.updateContent(n);
            }
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            int n = StackDockStation.this.indexOf(dockable);
            if (n >= 0) {
                StackDockStation.this.updateContent(n);
            }
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }
    }

    private class PanelBackground
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public PanelBackground() {
            super(StationBackgroundComponent.KIND, "dock.background.station.stack");
        }

        @Override
        public Component getComponent() {
            return StackDockStation.this.getComponent();
        }

        @Override
        public DockStation getStation() {
            return StackDockStation.this;
        }
    }

    protected class StackDropOperation
    implements StationDropOperation {
        private Insert insert;
        private Dockable dropping;
        private boolean move;

        public StackDropOperation(Dockable dockable, Insert insert, boolean bl) {
            this.dropping = dockable;
            this.insert = insert;
            this.move = bl;
        }

        @Override
        public boolean isMove() {
            return this.move;
        }

        @Override
        public void draw() {
            StackDockStation.this.insert = this.insert;
            StackDockStation.this.panel.repaint();
        }

        @Override
        public void destroy(StationDropOperation stationDropOperation) {
            if (StackDockStation.this.insert == this.insert) {
                StackDockStation.this.insert = null;
                StackDockStation.this.panel.repaint();
            }
            this.insert = null;
            this.dropping = null;
        }

        @Override
        public DockStation getTarget() {
            return StackDockStation.this;
        }

        @Override
        public Dockable getItem() {
            return this.dropping;
        }

        @Override
        public void execute() {
            if (this.isMove()) {
                this.move();
            } else {
                this.drop();
            }
        }

        public void move() {
            int n = StackDockStation.this.indexOf(this.dropping);
            if (n >= 0) {
                int n2 = this.insert.tab + (this.insert.right ? 1 : 0);
                if (n2 > n) {
                    --n2;
                }
                StackDockStation.this.move(n, n2);
            }
        }

        public void drop() {
            StackDockStation.this.add(this.dropping, this.insert.tab + (this.insert.right ? 1 : 0), null);
        }

        @Override
        public CombinerTarget getCombination() {
            return null;
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            return null;
        }
    }

    private class VisibleListener
    extends DockStationAdapter
    implements StackDockComponentListener {
        private boolean ignoreSelectionChanges = false;

        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            StackDockStation.this.visibility.fire();
        }

        @Override
        public void selectionChanged(StackDockComponent stackDockComponent) {
            if (!this.ignoreSelectionChanges) {
                DockController dockController = StackDockStation.this.getController();
                if (dockController != null && !StackDockStation.this.updatingTheme) {
                    Dockable dockable = StackDockStation.this.getFrontDockable();
                    if (dockable != null && !dockController.getRelocator().isOnPut()) {
                        dockController.setFocusedDockable(new DefaultFocusRequest(dockable, null, false));
                    }
                    StackDockStation.this.fireDockableSelected();
                }
                StackDockStation.this.visibility.fire();
            }
        }

        @Override
        public void tabChanged(StackDockComponent stackDockComponent, Dockable dockable) {
        }
    }
}

