/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.dockable.DockableStateListenerManager;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockStationIcon;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.NoStationDropOperation;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.split.DefaultSplitDividerStrategy;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.DefaultSplitNodeFactory;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDividerStrategy;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockCombinerSource;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockGrid;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderMapping;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockTreeFactory;
import bibliothek.gui.dock.station.split.SplitDropOperation;
import bibliothek.gui.dock.station.split.SplitFullScreenAction;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeFactory;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitPlaceholderConverter;
import bibliothek.gui.dock.station.split.SplitPlaceholderSet;
import bibliothek.gui.dock.station.split.SplitSpanStrategy;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.SplitTreePathFactory;
import bibliothek.gui.dock.station.split.layer.SideSnapDropLayer;
import bibliothek.gui.dock.station.split.layer.SplitOverrideDropLayer;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ComponentDragOperation;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.gui.dock.themes.StationThemeItemValue;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.util.Path;
import bibliothek.util.container.Single;
import bibliothek.util.container.Tuple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class SplitDockStation
extends SecureContainer
implements Dockable,
DockStation {
    public static final String TITLE_ID = "split";
    public static final PropertyKey<KeyStroke> MAXIMIZE_ACCELERATOR = new PropertyKey("SplitDockStation maximize accelerator");
    public static final PropertyKey<SplitLayoutManager> LAYOUT_MANAGER = new PropertyKey<DefaultSplitLayoutManager>("SplitDockStation layout manager", new ConstantPropertyFactory<DefaultSplitLayoutManager>(new DefaultSplitLayoutManager()), true);
    public static final PropertyKey<SplitDividerStrategy> DIVIDER_STRATEGY = new PropertyKey<SplitDividerStrategy>("SplitDockStation divider strategy", new DynamicPropertyFactory<SplitDividerStrategy>(){

        @Override
        public SplitDividerStrategy getDefault(PropertyKey<SplitDividerStrategy> propertyKey, DockProperties dockProperties) {
            return new DefaultSplitDividerStrategy();
        }

        @Override
        public SplitDividerStrategy getDefault(PropertyKey<SplitDividerStrategy> propertyKey) {
            return null;
        }
    }, true);
    private DockStation parent;
    private VisibleListener visibleListener = new VisibleListener();
    private DockController controller;
    private DockTheme theme;
    private StationCombinerValue combiner;
    private DockTitleVersion title;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockableStateListenerManager dockableStateListeners;
    private DockHierarchyObserver hierarchyObserver;
    private List<SplitDockListener> splitListeners = new ArrayList<SplitDockListener>();
    private DockableShowingManager visibility;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private HierarchyDockActionSource globalSource;
    private DockComponentRootHandler rootHandler;
    protected DockStationListenerManager dockStationListeners = new DockStationListenerManager(this);
    private PropertyValue<String> titleText = new PropertyValue<String>(PropertyKey.DOCK_STATION_TITLE){

        @Override
        protected void valueChanged(String string, String string2) {
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            DockableListener[] dockableListenerArray = SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()]);
            int n = dockableListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockableListener dockableListener = dockableListenerArray[n2];
                dockableListener.titleTextChanged(SplitDockStation.this, string, string2);
                ++n2;
            }
        }
    };
    private DockIcon titleIcon;
    private PropertyValue<String> titleToolTip = new PropertyValue<String>(PropertyKey.DOCK_STATION_TOOLTIP){

        @Override
        protected void valueChanged(String string, String string2) {
            DockableListener[] dockableListenerArray = SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()]);
            int n = dockableListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockableListener dockableListener = dockableListenerArray[n2];
                dockableListener.titleToolTipChanged(SplitDockStation.this, string, string2);
                ++n2;
            }
        }
    };
    private PropertyValue<SplitLayoutManager> layoutManager = new PropertyValue<SplitLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(SplitLayoutManager splitLayoutManager, SplitLayoutManager splitLayoutManager2) {
            if (splitLayoutManager != null) {
                splitLayoutManager.uninstall(SplitDockStation.this);
            }
            if (splitLayoutManager2 != null) {
                splitLayoutManager2.install(SplitDockStation.this);
            }
        }
    };
    private PropertyValue<SplitDividerStrategy> dividerStrategy = new PropertyValue<SplitDividerStrategy>(DIVIDER_STRATEGY){

        @Override
        protected void valueChanged(SplitDividerStrategy splitDividerStrategy, SplitDividerStrategy splitDividerStrategy2) {
            if (splitDividerStrategy != null) {
                splitDividerStrategy.uninstall(SplitDockStation.this);
            }
            if (splitDividerStrategy2 != null && SplitDockStation.this.content != null) {
                splitDividerStrategy2.install(SplitDockStation.this, SplitDockStation.this.getContentPane());
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategyProperty = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            SplitDockStation.this.placeholderStrategy.setStrategy(placeholderStrategy2);
        }
    };
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy disablingStrategy, DisablingStrategy disablingStrategy2) {
            if (disablingStrategy != null) {
                disablingStrategy.removeDisablingStrategyListener(SplitDockStation.this.disablingStrategyListener);
            }
            if (disablingStrategy2 != null) {
                disablingStrategy2.addDisablingStrategyListener(SplitDockStation.this.disablingStrategyListener);
                SplitDockStation.this.setDisabled(disablingStrategy2.isDisabled(SplitDockStation.this));
            } else {
                SplitDockStation.this.setDisabled(false);
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        @Override
        public void changed(DockElement dockElement) {
            if (dockElement == SplitDockStation.this) {
                SplitDockStation.this.setDisabled(((DisablingStrategy)SplitDockStation.this.disablingStrategy.getValue()).isDisabled(dockElement));
            }
        }
    };
    private RootPlaceholderStrategy placeholderStrategy = new RootPlaceholderStrategy(this);
    private boolean expandOnDoubleclick = true;
    private FullScreenListener fullScreenListener = new FullScreenListener();
    private List<StationChildHandle> dockables = new ArrayList<StationChildHandle>();
    private Dockable frontDockable;
    private StationChildHandle fullScreenDockable;
    private ListeningDockAction fullScreenAction;
    private int dividerSize = 4;
    private float sideSnapSize = 0.25f;
    private int borderSideSnapSize = 25;
    private boolean allowSideSnap = true;
    private Access access = new Access();
    private Root root;
    private SplitNodeFactory nodeFactory = new DefaultSplitNodeFactory();
    private SplitPlaceholderSet placeholderSet;
    private int treeLock = 0;
    private PutInfo putInfo;
    private SplitSpanStrategy spanStrategy;
    private ComponentDragOperation dragInfo;
    private DefaultStationPaintValue paint;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private boolean resizingEnabled = true;
    private boolean continousDisplay = false;
    private DockableDisplayerHints hints;
    private Content content;
    private Background background = new Background();
    private boolean disabled = false;
    private Dimension minimumLeafSize = new Dimension(20, 20);

    public SplitDockStation() {
        this(true);
    }

    public SplitDockStation(boolean bl) {
        this.content = new Content();
        this.content.setBackground(this.background);
        this.setBasePane(this.content);
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.placeholderSet = new SplitPlaceholderSet(this.access);
        this.dockableStateListeners = new DockableStateListenerManager(this);
        this.paint = new DefaultStationPaintValue("dock.paint.split", this);
        this.combiner = new StationCombinerValue("dock.combiner.split", this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.split", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory);
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer dockableDisplayer) {
                SplitDockStation.this.discard(dockableDisplayer);
            }

            @Override
            public void moveableElementChanged(DockableDisplayer dockableDisplayer) {
            }
        });
        if (bl) {
            this.fullScreenAction = this.createFullScreenAction();
        }
        this.visibility = new DockableShowingManager(this.dockStationListeners);
        SplitDividerStrategy splitDividerStrategy = this.dividerStrategy.getValue();
        if (splitDividerStrategy != null) {
            splitDividerStrategy.install(this, this.getContentPane());
        }
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
        this.spanStrategy = new SplitSpanStrategy(this);
        this.titleIcon = new DockStationIcon("dockStation.default", this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                DockableListener[] dockableListenerArray = SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()]);
                int n = dockableListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockableListener dockableListener = dockableListenerArray[n2];
                    dockableListener.titleIconChanged(SplitDockStation.this, icon, icon2);
                    ++n2;
                }
            }
        };
        this.addDockStationListener(new DockStationAdapter(){

            @Override
            public void dockableAdded(DockStation dockStation, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }

            @Override
            public void dockableRemoved(DockStation dockStation, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }
        });
        this.placeholderStrategy.addListener(new PlaceholderStrategyListener(){

            @Override
            public void placeholderInvalidated(Set<Path> set) {
                SplitDockStation.this.removePlaceholders(set);
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (SplitDockStation.this.getDockParent() == null) {
                        SplitDockStation.this.dockableStateListeners.checkShowing();
                    }
                    SplitDockStation.this.visibility.fire();
                }
            }
        });
    }

    private DockComponentRootHandler getRootHandler() {
        if (this.rootHandler == null) {
            this.rootHandler = this.createRootHandler();
            this.rootHandler.addRoot(this.getComponent());
        }
        return this.rootHandler;
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    protected final Root root() {
        if (this.root == null) {
            this.root = this.access.createRoot(-1L);
        }
        return this.root;
    }

    @Override
    public String toString() {
        if (this.root == null) {
            return super.toString();
        }
        return this.root.toString();
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getRoot().getMinimumSize();
        if (insets != null) {
            dimension = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getRoot().getPreferredSize();
        if (insets != null) {
            dimension = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return dimension;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme dockTheme;
        DockController dockController = this.getController();
        if (dockController != null && (dockTheme = dockController.getTheme()) != this.theme) {
            this.theme = dockTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new SplitDockStationFactory());
    }

    protected ListeningDockAction createFullScreenAction() {
        return new SplitFullScreenAction(this);
    }

    public void setFullScreenAction(ListeningDockAction listeningDockAction) {
        if (this.fullScreenAction != null) {
            throw new IllegalStateException("The fullScreenAction can only be set once");
        }
        this.fullScreenAction = listeningDockAction;
    }

    public void setExpandOnDoubleclick(boolean bl) {
        this.expandOnDoubleclick = bl;
    }

    public boolean isExpandOnDoubleclick() {
        return this.expandOnDoubleclick;
    }

    public void setResizingEnabled(boolean bl) {
        this.resizingEnabled = bl;
    }

    public boolean isResizingEnabled() {
        return this.resizingEnabled;
    }

    protected void setDisabled(boolean bl) {
        this.disabled = bl;
        if (bl) {
            this.setCursor(null);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.parent != null) {
            this.parent.removeDockStationListener(this.visibleListener);
        }
        this.parent = dockStation;
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.hierarchyObserver.update();
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public void setController(DockController dockController) {
        this.getRootHandler().setController(null);
        super.setController(dockController);
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getDoubleClickController().removeListener(this.fullScreenListener);
            }
            for (StationChildHandle stationChildHandle : this.dockables) {
                stationChildHandle.setTitleRequest(null);
            }
            this.controller = dockController;
            this.getDisplayers().setController(dockController);
            if (this.fullScreenAction != null) {
                this.fullScreenAction.setController(dockController);
            }
            this.titleIcon.setController(dockController);
            this.titleText.setProperties(dockController);
            this.layoutManager.setProperties(dockController);
            this.placeholderStrategyProperty.setProperties(dockController);
            this.paint.setController(dockController);
            this.displayerFactory.setController(dockController);
            this.combiner.setController(dockController);
            this.background.setController(dockController);
            this.dividerStrategy.setProperties(dockController);
            this.disablingStrategy.setProperties(dockController);
            this.spanStrategy.setController(dockController);
            if (dockController != null) {
                this.title = dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE);
                dockController.getDoubleClickController().addListener(this.fullScreenListener);
            } else {
                this.title = null;
            }
            for (StationChildHandle stationChildHandle : this.dockables) {
                stationChildHandle.setTitleRequest(this.title);
            }
            this.getRootHandler().setController(dockController);
            this.hierarchyObserver.controllerChanged(dockController);
            this.visibility.fire();
        }
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public DockComponentConfiguration getComponentConfiguration() {
        return this.getRootHandler().getConfiguration();
    }

    @Override
    public void setComponentConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        this.getRootHandler().setConfiguration(dockComponentConfiguration);
    }

    @Override
    public void addDockableListener(DockableListener dockableListener) {
        this.dockableListeners.add(dockableListener);
    }

    @Override
    public void removeDockableListener(DockableListener dockableListener) {
        this.dockableListeners.remove(dockableListener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.addDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.removeDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return true;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return true;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return false;
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    @Override
    public String getTitleText() {
        String string = this.titleText.getValue();
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setTitleText(String string) {
        this.titleText.setValue(string);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    public void setTitleToolTip(String string) {
        this.titleToolTip.setValue(string);
    }

    @Override
    public Icon getTitleIcon() {
        return (Icon)this.titleIcon.value();
    }

    public void setTitleIcon(Icon icon) {
        this.titleIcon.setValue(icon, true);
    }

    public void resetTitleIcon() {
        this.titleIcon.setValue(null);
    }

    public void setSplitLayoutManager(SplitLayoutManager splitLayoutManager) {
        this.layoutManager.setValue(splitLayoutManager);
    }

    public SplitLayoutManager getSplitLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public SplitLayoutManager getCurrentSplitLayoutManager() {
        return this.layoutManager.getValue();
    }

    public RootPlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategyProperty.setValue(placeholderStrategy);
    }

    public void setSideSnapSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("sideSnapSize must not be less than 0");
        }
        this.sideSnapSize = f;
    }

    public float getSideSnapSize() {
        return this.sideSnapSize;
    }

    public void setBorderSideSnapSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.borderSideSnapSize = n;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    public void setDividerSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("dividerSize must not be less than 0");
        }
        this.dividerSize = n;
        this.doLayout();
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public SplitDividerStrategy getDividerStrategy() {
        return this.dividerStrategy.getValue();
    }

    public void setDividerStrategy(SplitDividerStrategy splitDividerStrategy) {
        this.dividerStrategy.setValue(splitDividerStrategy);
    }

    protected SplitSpanStrategy getSpanStrategy() {
        return this.spanStrategy;
    }

    public void setNodeFactory(SplitNodeFactory splitNodeFactory) {
        if (splitNodeFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.nodeFactory = splitNodeFactory;
    }

    public SplitNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setContinousDisplay(boolean bl) {
        this.continousDisplay = bl;
    }

    public boolean isContinousDisplay() {
        return this.continousDisplay;
    }

    public void setMinimumLeafSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("minimumLeafSize must not be null");
        }
        this.minimumLeafSize = dimension;
        this.revalidate();
    }

    public Dimension getMinimumLeafSize() {
        return this.minimumLeafSize;
    }

    public void setAllowSideSnap(boolean bl) {
        this.allowSideSnap = bl;
    }

    public boolean isAllowSideSnap() {
        return this.allowSideSnap;
    }

    @Override
    public void requestDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void requestDisplayer(DisplayerRequest displayerRequest) {
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        dockTitle.changed(new ActivityDockTitleEvent(this, dockable, bl));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest dockTitleRequest) {
    }

    @Override
    public void requestChildDisplayer(DisplayerRequest displayerRequest) {
    }

    @Override
    public void bind(DockTitle dockTitle) {
        if (this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(dockTitle);
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleBound(this, dockTitle);
            ++n2;
        }
    }

    @Override
    public void unbind(DockTitle dockTitle) {
        if (!this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(dockTitle);
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleUnbound(this, dockTitle);
            ++n2;
        }
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return null;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        this.hints = dockableDisplayerHints;
        this.updateConfigurableDisplayerHints();
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }

    protected void updateConfigurableDisplayerHints() {
        if (this.hints != null) {
            if (this.getDockableCount() == 0) {
                this.hints.setShowBorderHint(Boolean.TRUE);
            } else {
                this.hints.setShowBorderHint(Boolean.FALSE);
            }
        }
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.VERY_RIGHT), new DockAction[0]);
        defaultDockActionSource.add(this.fullScreenAction);
        return defaultDockActionSource;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return null;
        }
        if (dockStation instanceof SplitDockStation) {
            return null;
        }
        dockable = dockStation.asDockable();
        if (dockable == null) {
            return null;
        }
        dockStation = dockable.getDockParent();
        if (dockStation != this) {
            return null;
        }
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(this.fullScreenAction);
        defaultDockActionSource.setHint(new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.VERY_RIGHT));
        return defaultDockActionSource;
    }

    @Override
    public void addDockStationListener(DockStationListener dockStationListener) {
        this.dockStationListeners.addListener(dockStationListener);
    }

    @Override
    public void removeDockStationListener(DockStationListener dockStationListener) {
        this.dockStationListeners.removeListener(dockStationListener);
    }

    @Override
    public void addDockableStateListener(DockableStateListener dockableStateListener) {
        this.dockableStateListeners.addListener(dockableStateListener);
    }

    @Override
    public void removeDockableStateListener(DockableStateListener dockableStateListener) {
        this.dockableStateListeners.removeListener(dockableStateListener);
    }

    public void addSplitDockStationListener(SplitDockListener splitDockListener) {
        this.splitListeners.add(splitDockListener);
    }

    public void removeSplitDockStationListener(SplitDockListener splitDockListener) {
        this.splitListeners.remove(splitDockListener);
    }

    @Override
    public boolean isChildShowing(Dockable dockable) {
        return this.isVisible(dockable);
    }

    @Override
    @Deprecated
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (!this.isFullScreen() || dockable == this.getFullScreen());
    }

    @Override
    public boolean isStationShowing() {
        return this.isStationVisible();
    }

    @Override
    @Deprecated
    public boolean isStationVisible() {
        return this.isDockableVisible();
    }

    @Override
    public boolean isDockableShowing() {
        return this.isDockableVisible();
    }

    @Override
    @Deprecated
    public boolean isDockableVisible() {
        DockController dockController = this.getController();
        if (dockController == null) {
            return false;
        }
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isChildShowing(this);
        }
        return this.isShowing();
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.get(n).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        AbstractDockableProperty abstractDockableProperty = this.getDockablePlaceholderProperty(dockable, dockable2);
        if (abstractDockableProperty == null) {
            abstractDockableProperty = this.getDockablePathProperty(dockable);
        }
        return abstractDockableProperty;
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        Object object;
        Object object2;
        DockableProperty dockableProperty;
        boolean bl = false;
        if (asideRequest.getPlaceholder() != null) {
            this.removePlaceholder(asideRequest.getPlaceholder());
        }
        if ((dockableProperty = asideRequest.getLocation()) instanceof SplitDockPlaceholderProperty) {
            object2 = (SplitDockPlaceholderProperty)dockableProperty;
            object = this.root().getPlaceholderNode(((SplitDockPlaceholderProperty)object2).getPlaceholder());
            if (object != null) {
                ((SplitNode)object).aside(asideRequest);
                bl = true;
            } else {
                dockableProperty = ((SplitDockPlaceholderProperty)object2).getBackup();
            }
        }
        if (dockableProperty instanceof SplitDockPathProperty && !(bl = ((SplitNode)((Tuple)(object = this.getLowestNode((SplitDockPathProperty)(object2 = (SplitDockPathProperty)dockableProperty)))).getB()).aside((SplitDockPathProperty)object2, (Integer)((Single)object).getA(), asideRequest))) {
            dockableProperty = ((SplitDockPathProperty)object2).toLocation();
        }
        if (dockableProperty instanceof SplitDockProperty) {
            object2 = (SplitDockProperty)dockableProperty;
            bl = this.aside((SplitDockProperty)object2, asideRequest);
        }
        if (dockableProperty instanceof SplitDockFullScreenProperty) {
            object2 = this.getFullScreen();
            if (object2 != null) {
                AsideAnswer asideAnswer;
                DockStation dockStation;
                object = this.getRoot().getLeaf((Dockable)object2);
                if (asideRequest.getPlaceholder() != null) {
                    ((SplitNode)object).addPlaceholder(asideRequest.getPlaceholder());
                }
                if ((dockStation = object2.asDockStation()) != null) {
                    asideAnswer = asideRequest.forward(dockStation);
                } else {
                    asideAnswer = asideRequest.forward(this.getCombiner(), ((SplitNode)object).getPlaceholderMap());
                    if (!asideAnswer.isCanceled()) {
                        ((SplitNode)object).setPlaceholderMap(asideAnswer.getLayout());
                    }
                }
                if (asideAnswer.isCanceled()) {
                    return;
                }
            }
            asideRequest.answer(new SplitDockFullScreenProperty());
            return;
        }
        if (bl) {
            if (asideRequest.getPlaceholder() == null) {
                dockableProperty = asideRequest.getLocation();
                if (dockableProperty instanceof SplitDockPlaceholderProperty) {
                    dockableProperty = ((SplitDockPlaceholderProperty)dockableProperty).getBackup();
                }
                dockableProperty = dockableProperty.copy();
                dockableProperty.setSuccessor(null);
                asideRequest.answer(dockableProperty);
            } else {
                object2 = this.getDockablePathProperty(asideRequest.getPlaceholder());
                object = new SplitDockPlaceholderProperty(asideRequest.getPlaceholder(), (SplitDockPathProperty)object2);
                asideRequest.answer((DockableProperty)object);
            }
        }
    }

    public SplitDockPathProperty getDockablePathProperty(final Dockable dockable) {
        return this.root().submit(new SplitTreePathFactory(){

            @Override
            public SplitDockPathProperty leaf(Dockable dockable2, long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                if (dockable2 == dockable) {
                    SplitDockPathProperty splitDockPathProperty = new SplitDockPathProperty();
                    splitDockPathProperty.setLeafId(l);
                    return splitDockPathProperty;
                }
                return null;
            }
        });
    }

    public SplitDockPathProperty getDockablePathProperty(final Path path) {
        return this.root().submit(new SplitTreePathFactory(){

            @Override
            public SplitDockPathProperty leaf(Dockable dockable, long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                return this.placeholder(l, pathArray, placeholderMap);
            }

            @Override
            public SplitDockPathProperty placeholder(long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                if (this.contains(pathArray)) {
                    SplitDockPathProperty splitDockPathProperty = new SplitDockPathProperty();
                    splitDockPathProperty.setLeafId(l);
                    return splitDockPathProperty;
                }
                return null;
            }

            private boolean contains(Path[] pathArray) {
                Path[] pathArray2 = pathArray;
                int n = pathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Path path2 = pathArray2[n2];
                    if (path2.equals(path)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public SplitDockProperty getDockableLocationProperty(Dockable dockable) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        return new SplitDockProperty(leaf.getX(), leaf.getY(), leaf.getWidth(), leaf.getHeight());
    }

    public SplitDockPlaceholderProperty getDockablePlaceholderProperty(Dockable dockable, Dockable dockable2) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        if (leaf == null) {
            throw new IllegalArgumentException("dockable not known to this station");
        }
        Path path = this.getPlaceholderStrategy().getPlaceholderFor(dockable2 == null ? dockable : dockable2);
        if (path == null) {
            return null;
        }
        this.placeholderSet.set((SplitNode)leaf, path, new SplitNode[0]);
        return new SplitDockPlaceholderProperty(path, this.getDockablePathProperty(dockable));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.isFullScreen()) {
            return this.getFullScreen();
        }
        if (this.frontDockable == null && this.dockables.size() > 0) {
            this.frontDockable = this.dockables.get(0).getDockable();
        }
        return this.frontDockable;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable dockable2 = this.getFrontDockable();
        this.frontDockable = dockable;
        if (this.isFullScreen() && dockable != null) {
            this.setFullScreen(dockable);
        }
        if (dockable2 != dockable) {
            this.access.dockableSelected(dockable2);
        }
    }

    public boolean isFullScreen() {
        return this.fullScreenDockable != null;
    }

    public Dockable getFullScreen() {
        return this.fullScreenDockable == null ? null : this.fullScreenDockable.getDockable();
    }

    public boolean hasFullScreenAction() {
        return this.fullScreenAction != null;
    }

    public void setFullScreen(Dockable dockable) {
        try {
            this.access.arm();
            dockable = this.layoutManager.getValue().willMakeFullscreen(this, dockable);
            Dockable dockable2 = this.getFullScreen();
            if (dockable2 != dockable) {
                if (dockable != null) {
                    this.access.repositioned.add(dockable);
                    Leaf leaf = this.getRoot().getLeaf(dockable);
                    if (leaf == null) {
                        throw new IllegalArgumentException("Dockable not child of this station");
                    }
                    this.fullScreenDockable = leaf.getDockableHandle();
                    this.updateVisibility();
                } else {
                    this.fullScreenDockable = null;
                    this.updateVisibility();
                }
                if (dockable2 != null) {
                    this.access.repositioned.add(dockable2);
                }
                this.revalidate();
                this.fireFullScreenChanged(dockable2, this.getFullScreen());
                this.visibility.fire();
            }
        }
        finally {
            this.access.fire();
        }
    }

    protected void updateVisibility() {
        StationChildHandle stationChildHandle = this.fullScreenDockable;
        if (stationChildHandle == null) {
            for (StationChildHandle stationChildHandle2 : this.dockables) {
                stationChildHandle2.getDisplayer().getComponent().setVisible(true);
            }
        } else {
            for (StationChildHandle stationChildHandle3 : this.dockables) {
                stationChildHandle3.getDisplayer().getComponent().setVisible(stationChildHandle3 == stationChildHandle);
            }
        }
    }

    public void setNextFullScreen() {
        if (this.dockables.size() > 0) {
            if (this.fullScreenDockable == null) {
                this.setFullScreen(this.getDockable(0));
            } else {
                int n = this.indexOfDockable(this.fullScreenDockable.getDockable());
                ++n;
                this.setFullScreen(this.getDockable(n %= this.getDockableCount()));
            }
        }
    }

    @Override
    public boolean accept(Dockable dockable) {
        return true;
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new SplitDockPlaceholderMapping(this);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.createPlaceholderConverter().getPlaceholders();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        this.createPlaceholderConverter().setPlaceholders(placeholderMap);
    }

    protected SplitPlaceholderConverter createPlaceholderConverter() {
        return new SplitPlaceholderConverter(this);
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this), new SplitOverrideDropLayer(this), new SideSnapDropLayer(this)};
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem stationDropItem) {
        boolean bl;
        PutInfo putInfo = null;
        boolean bl2 = bl = stationDropItem.getDockable().getDockParent() == this;
        if (bl) {
            putInfo = this.layoutManager.getValue().prepareMove(this, stationDropItem);
            if (putInfo != null) {
                if (putInfo.getNode() == null) {
                    return new NoStationDropOperation(this, stationDropItem.getDockable());
                }
                this.prepareCombine(putInfo, bl, stationDropItem);
            }
        } else {
            putInfo = SwingUtilities.isDescendingFrom(this.getComponent(), stationDropItem.getDockable().getComponent()) ? null : this.layoutManager.getValue().prepareDrop(this, stationDropItem);
            if (putInfo != null) {
                this.prepareCombine(putInfo, bl, stationDropItem);
            }
        }
        if (putInfo == null) {
            return null;
        }
        return new SplitDropOperation(this.access, putInfo, stationDropItem, bl);
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        this.dragInfo = new ComponentDragOperation(dockable, this){

            @Override
            protected void destroy() {
                SplitDockStation.this.dragInfo = null;
            }
        };
        return this.dragInfo;
    }

    public PutInfo getDropInfo() {
        return this.putInfo;
    }

    protected void setDropInfo(PutInfo putInfo) {
        this.putInfo = putInfo;
        this.setPut(putInfo);
        this.repaint();
    }

    protected void setPut(PutInfo putInfo) {
        this.spanStrategy.setPut(putInfo);
    }

    protected void unsetDropInfo() {
        this.putInfo = null;
        this.unsetPut();
        this.repaint();
    }

    protected void unsetPut() {
        this.spanStrategy.unsetPut();
    }

    private void prepareCombine(PutInfo putInfo, boolean bl, StationDropItem stationDropItem) {
        if (putInfo.getCombinerSource() == null && putInfo.getCombinerTarget() == null && putInfo.getNode() instanceof Leaf) {
            DockController dockController;
            Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
            SwingUtilities.convertPointFromScreen(point, this.getComponent());
            SplitDockCombinerSource splitDockCombinerSource = new SplitDockCombinerSource(putInfo, this, point);
            Enforcement enforcement = putInfo.getPut() == PutInfo.Put.CENTER ? Enforcement.EXPECTED : (putInfo.getPut() == PutInfo.Put.TITLE ? Enforcement.HARD : Enforcement.WHISHED);
            CombinerTarget combinerTarget = this.getCombiner().prepare(splitDockCombinerSource, enforcement);
            if (combinerTarget == null && putInfo.isCombining() && putInfo.getDockable().asDockStation() != null && (dockController = this.getController()) != null) {
                Merger merger = dockController.getRelocator().getMerger();
                combinerTarget = this.getCombiner().prepare(splitDockCombinerSource, Enforcement.HARD);
                putInfo.setCombination(splitDockCombinerSource, combinerTarget);
                if (!merger.canMerge(new SplitDropOperation(this.access, putInfo, stationDropItem, bl), this, putInfo.getDockable().asDockStation())) {
                    putInfo.setCombination(null, null);
                }
            }
            putInfo.setCombination(splitDockCombinerSource, combinerTarget);
        }
    }

    @Override
    public void drop(Dockable dockable) {
        this.addDockable(dockable, null);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof SplitDockProperty) {
            return this.drop(dockable, (SplitDockProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockPathProperty) {
            return this.drop(dockable, (SplitDockPathProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockPlaceholderProperty) {
            return this.drop(dockable, (SplitDockPlaceholderProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockFullScreenProperty) {
            return this.drop(dockable, (SplitDockFullScreenProperty)dockableProperty);
        }
        return false;
    }

    private void move(PutInfo putInfo, StationDropItem stationDropItem) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            Root root = this.access.getOwner().getRoot();
            Leaf leaf = root.getLeaf(putInfo.getDockable());
            SplitNode splitNode = putInfo.getNode();
            if (leaf.getParent() == splitNode) {
                while (splitNode != null) {
                    if (splitNode == root) {
                        return;
                    }
                    Node node = (Node)splitNode;
                    SplitNode splitNode2 = node.getLeft() == leaf ? node.getRight() : node.getLeft();
                    if (splitNode2.isVisible()) {
                        putInfo.setNode(splitNode2);
                        break;
                    }
                    splitNode = splitNode.getParent();
                }
            }
            putInfo.setLeaf(leaf);
            if (putInfo.getPut() == PutInfo.Put.CENTER) {
                leaf.placehold(false);
            } else {
                leaf.delete(true);
            }
            this.drop(DockHierarchyLock.acquireFake(), putInfo, stationDropItem);
        }
        finally {
            this.access.fire();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drop(DockHierarchyLock.Token var1_1, PutInfo var2_2, StationDropItem var3_3) {
        try {
            var4_4 = var1_1 == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (var2_2.getNode() == null) {
                if (var4_4) {
                    DockUtilities.ensureTreeValidity(this, var2_2.getDockable());
                    var1_1 = DockHierarchyLock.acquireLinking(this, var2_2.getDockable());
                }
                try {
                    if (var4_4) {
                        this.dockStationListeners.fireDockableAdding(var2_2.getDockable());
                    }
                    this.addDockable(var2_2.getDockable(), var1_1);
                    if (!var4_4) ** GOTO lbl44
                    this.dockStationListeners.fireDockableAdded(var2_2.getDockable());
                }
                finally {
                    if (var4_4) {
                        var1_1.release();
                    }
                }
            } else {
                var5_6 = false;
                if (var2_2.getCombinerTarget() != null) {
                    if (var2_2.getNode() instanceof Leaf) {
                        if (var2_2.getLeaf() != null) {
                            if (var4_4) {
                                var1_1 = DockHierarchyLock.acquireUnlinking(this, var2_2.getLeaf().getDockable());
                            }
                            try {
                                var2_2.getLeaf().setDockable(null, var1_1);
                                var2_2.setLeaf(null);
                            }
                            finally {
                                if (var4_4) {
                                    var1_1.release();
                                }
                            }
                        }
                        if (this.dropOver((Leaf)var2_2.getNode(), var2_2.getDockable(), var2_2.getCombinerSource(), var2_2.getCombinerTarget())) {
                            var5_6 = true;
                        }
                    } else {
                        var2_2.setPut(PutInfo.Put.TOP);
                    }
                }
                if (!var5_6) {
                    this.updateBounds();
                    this.layoutManager.getValue().calculateDivider(this, var2_2, this.root().getLeaf(var2_2.getDockable()), var3_3);
                    this.dropAside(var2_2.getNode(), var2_2.getPut(), var2_2.getDockable(), var2_2.getLeaf(), var2_2.getDivider(), var1_1);
                }
            }
lbl44:
            // 5 sources

            this.revalidate();
        }
        finally {
            this.access.fire();
        }
    }

    public boolean drop(Dockable dockable, SplitDockProperty splitDockProperty) {
        return this.drop(dockable, splitDockProperty, this.root());
    }

    private boolean drop(Dockable dockable, SplitDockProperty splitDockProperty, SplitNode splitNode) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (this.getDockableCount() == 0) {
                if (!DockUtilities.acceptable(this, dockable)) {
                    return false;
                }
                this.drop(dockable);
                return true;
            }
            this.updateBounds();
            DropInfo dropInfo = this.getDropInfo(splitDockProperty, dockable, splitNode);
            if (dropInfo.bestLeaf != null) {
                DockStation dockStation = dropInfo.bestLeaf.getDockable().asDockStation();
                DockableProperty dockableProperty = splitDockProperty.getSuccessor();
                if (dockStation != null && dockableProperty != null && dockStation.drop(dockable, dockableProperty)) {
                    this.validate();
                    return true;
                }
                if (dropInfo.bestLeafIntersection > 0.75) {
                    if (dockStation != null && DockUtilities.acceptable(dockStation, dockable)) {
                        dockStation.drop(dockable);
                        this.validate();
                        return true;
                    }
                    boolean bl = this.dropOver(dropInfo.bestLeaf, dockable, splitDockProperty.getSuccessor(), null, null);
                    this.validate();
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            if (dropInfo.bestNode != null) {
                if (!DockUtilities.acceptable(this, dockable)) {
                    return false;
                }
                double d = dropInfo.getDivider(splitDockProperty);
                boolean bl = this.dropAside(dropInfo.bestNode, dropInfo.bestNodePut, dockable, null, d, null);
                return bl;
            }
            this.repaint();
            return false;
        }
        finally {
            this.access.fire();
        }
    }

    private boolean aside(SplitDockProperty splitDockProperty, AsideRequest asideRequest) {
        if (asideRequest.getPlaceholder() == null) {
            return false;
        }
        DropInfo dropInfo = this.getDropInfo(splitDockProperty, null, this.getRoot());
        if (dropInfo.bestLeaf != null && splitDockProperty.getSuccessor() != null && dropInfo.bestLeafIntersection > 0.75) {
            AsideAnswer asideAnswer;
            DockStation dockStation = dropInfo.bestLeaf.getDockable().asDockStation();
            if (dockStation != null) {
                asideAnswer = asideRequest.forward(dockStation);
            } else {
                PlaceholderMap placeholderMap = dropInfo.bestLeaf.getPlaceholderMap();
                asideAnswer = asideRequest.forward(this.getCombiner(), placeholderMap);
                if (!asideAnswer.isCanceled()) {
                    dropInfo.bestLeaf.setPlaceholderMap(asideAnswer.getLayout());
                }
            }
            return !asideAnswer.isCanceled();
        }
        if (dropInfo.bestNode != null) {
            double d = dropInfo.getDivider(splitDockProperty);
            Placeholder placeholder = new Placeholder(this.access, -1L);
            placeholder.setPlaceholders(new Path[]{asideRequest.getPlaceholder()});
            this.createAside(dropInfo.bestNode, dropInfo.bestNodePut, placeholder, d);
            AsideAnswer asideAnswer = asideRequest.forward(this.getCombiner(), placeholder.getPlaceholderMap());
            if (!asideAnswer.isCanceled()) {
                dropInfo.bestLeaf.setPlaceholderMap(asideAnswer.getLayout());
            }
            return !asideAnswer.isCanceled();
        }
        return false;
    }

    protected DropInfo getDropInfo(final SplitDockProperty splitDockProperty, final Dockable dockable, SplitNode splitNode) {
        final DropInfo dropInfo = new DropInfo();
        splitNode.visit(new SplitNodeVisitor(){

            @Override
            public void handleLeaf(Leaf leaf) {
                double d = leaf.intersection(splitDockProperty);
                if (d > dropInfo.bestLeafIntersection) {
                    dropInfo.bestLeafIntersection = d;
                    dropInfo.bestLeaf = leaf;
                }
                this.handleNeighbour(leaf);
            }

            @Override
            public void handleNode(Node node) {
                if (node.isVisible()) {
                    this.handleNeighbour(node);
                }
            }

            @Override
            public void handleRoot(Root root) {
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
            }

            private void handleNeighbour(SplitNode splitNode) {
                if (dockable == null || DockUtilities.acceptable(SplitDockStation.this, dockable)) {
                    double d;
                    double d2;
                    double d3;
                    double d4 = splitNode.getX();
                    double d5 = splitNode.getY();
                    double d6 = splitNode.getWidth();
                    double d7 = splitNode.getHeight();
                    double d8 = Math.abs(d4 - splitDockProperty.getX());
                    double d9 = Math.abs(d4 + d6 - splitDockProperty.getX() - splitDockProperty.getWidth());
                    double d10 = Math.abs(d5 - splitDockProperty.getY());
                    double d11 = Math.abs(d5 + d7 - splitDockProperty.getY() - splitDockProperty.getHeight());
                    double d12 = d8 + d9 + d10 + d11;
                    d12 -= Math.max(Math.max(d8, d9), Math.max(d10, d11));
                    double d13 = splitDockProperty.getX() + splitDockProperty.getWidth() / 2.0;
                    PutInfo.Put put = splitNode.relativeSidePut(d13, d3 = splitDockProperty.getY() + splitDockProperty.getHeight() / 2.0);
                    if (put == PutInfo.Put.TOP) {
                        d2 = d4 + 0.5 * d6;
                        d = d5 + 0.25 * d7;
                    } else if (put == PutInfo.Put.BOTTOM) {
                        d2 = d4 + 0.5 * d6;
                        d = d5 + 0.75 * d7;
                    } else if (put == PutInfo.Put.LEFT) {
                        d2 = d4 + 0.25 * d6;
                        d = d5 + 0.5 * d7;
                    } else {
                        d2 = d4 + 0.5 * d6;
                        d = d5 + 0.75 * d7;
                    }
                    double d14 = Math.pow((d13 - d2) * (d13 - d2) + (d3 - d) * (d3 - d), 0.25);
                    d12 *= d14;
                    if (d12 < dropInfo.bestNodeIntersection) {
                        dropInfo.bestNodeIntersection = d12;
                        dropInfo.bestNode = splitNode;
                        dropInfo.bestNodePut = put;
                    }
                }
            }
        });
        return dropInfo;
    }

    public boolean drop(Dockable dockable, SplitDockPathProperty splitDockPathProperty) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            Tuple<Integer, SplitNode> tuple = this.getLowestNode(splitDockPathProperty);
            int n = (Integer)tuple.getA();
            SplitNode splitNode = tuple.getB();
            this.updateBounds();
            boolean bl = splitNode.insert(splitDockPathProperty, n, dockable);
            if (bl) {
                this.revalidate();
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.access.fire();
        }
    }

    protected Tuple<Integer, SplitNode> getLowestNode(SplitDockPathProperty splitDockPathProperty) {
        SplitNode splitNode = null;
        int n = 0;
        long l = splitDockPathProperty.getLeafId();
        if (l != -1L && (splitNode = this.getNode(l)) != null) {
            n = splitDockPathProperty.size();
        }
        if (splitNode == null) {
            n = splitDockPathProperty.size() - 1;
            while (n >= 0) {
                SplitDockPathProperty.Node node = splitDockPathProperty.getNode(n);
                long l2 = node.getId();
                if (l2 != -1L && (splitNode = this.getNode(l2)) != null) break;
                --n;
            }
        }
        if (splitNode == null || n < 0) {
            splitNode = this.root();
            n = 0;
        }
        return new Tuple<Integer, SplitNode>(n, splitNode);
    }

    public boolean drop(Dockable dockable, SplitDockPlaceholderProperty splitDockPlaceholderProperty) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            this.validate();
            boolean bl = this.root().insert(splitDockPlaceholderProperty, dockable);
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    public boolean drop(Dockable dockable, SplitDockFullScreenProperty splitDockFullScreenProperty) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            DockableProperty dockableProperty = splitDockFullScreenProperty.getSuccessor();
            if (dockable.getDockParent() == this) {
                this.setFullScreen(dockable);
                return true;
            }
            Dockable dockable2 = this.getFullScreen();
            if (dockable2 == null) {
                return false;
            }
            DockStation dockStation = dockable2.asDockStation();
            if (dockStation != null) {
                return dockableProperty != null && dockStation.drop(dockable, dockableProperty);
                {
                }
            }
            Leaf leaf = this.getRoot().getLeaf(dockable2);
            this.setFullScreen(null);
            if (!this.dropOver(leaf, dockable, dockableProperty, null, null)) {
                return false;
            }
            Dockable dockable3 = dockable;
            while (dockable != null && dockable != this) {
                dockable3 = dockable;
                DockStation dockStation2 = dockable.getDockParent();
                Dockable dockable4 = dockable = dockStation2 == null ? null : dockStation2.asDockable();
            }
            if (dockable3 != null) {
                this.setFullScreen(dockable3);
            }
            return true;
        }
        finally {
            this.access.fire();
        }
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, CombinerSource combinerSource, CombinerTarget combinerTarget) {
        return this.dropOver(leaf, dockable, null, combinerSource, combinerTarget);
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, DockableProperty dockableProperty, CombinerSource combinerSource, CombinerTarget combinerTarget) {
        if (!DockUtilities.acceptable(this, leaf.getDockable(), dockable)) {
            return false;
        }
        try {
            Object object;
            Object object2;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            DockUtilities.ensureTreeValidity(this, dockable);
            if (combinerSource == null || combinerTarget == null) {
                object2 = new PutInfo(leaf, PutInfo.Put.TITLE, dockable, true);
                combinerSource = new SplitDockCombinerSource((PutInfo)object2, this, null);
                combinerTarget = this.combiner.prepare(combinerSource, Enforcement.HARD);
            }
            if (leaf.getDockable() != null) {
                object2 = leaf.getDockable();
                object = DockHierarchyLock.acquireUnlinking(this, (Dockable)object2);
                try {
                    this.dockStationListeners.fireDockableRemoving((Dockable)object2);
                    leaf.setDockable(null, (DockHierarchyLock.Token)object);
                    this.dockStationListeners.fireDockableRemoved((Dockable)object2);
                }
                finally {
                    ((DockHierarchyLock.Token)object).release();
                }
            }
            object2 = this.combiner.combine(combinerSource, combinerTarget);
            leaf.setPlaceholderMap(null);
            if (dockableProperty != null && (object = object2.asDockStation()) != null && dockable.getDockParent() == object && (combinerSource.getPlaceholders() == null || this.getPlaceholderStrategy().getPlaceholderFor(dockable) == null)) {
                object.move(dockable, dockableProperty);
            }
            object = DockHierarchyLock.acquireLinking(this, (Dockable)object2);
            try {
                this.dockStationListeners.fireDockableAdding((Dockable)object2);
                leaf.setDockable((Dockable)object2, (DockHierarchyLock.Token)object);
                this.dockStationListeners.fireDockableAdded((Dockable)object2);
            }
            finally {
                ((DockHierarchyLock.Token)object).release();
            }
            this.revalidate();
            this.repaint();
            return true;
        }
        finally {
            this.access.fire();
        }
    }

    protected boolean dropAside(SplitNode splitNode, PutInfo.Put put, Dockable dockable, Leaf leaf, double d, DockHierarchyLock.Token token) {
        if (!DockUtilities.acceptable(this, dockable)) {
            return false;
        }
        try {
            boolean bl = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (bl) {
                DockUtilities.ensureTreeValidity(this, dockable);
                token = DockHierarchyLock.acquireLinking(this, dockable);
            }
            try {
                if (bl) {
                    this.dockStationListeners.fireDockableAdding(dockable);
                }
                boolean bl2 = false;
                if (leaf == null) {
                    leaf = this.access.createLeaf(-1L);
                    bl2 = true;
                }
                this.createAside(splitNode, put, leaf, d);
                if (bl2) {
                    leaf.setDockable(dockable, token);
                }
                if (bl) {
                    this.dockStationListeners.fireDockableAdded(dockable);
                }
                this.revalidate();
                this.repaint();
            }
            finally {
                if (bl) {
                    token.release();
                }
            }
        }
        finally {
            this.access.fire();
        }
        return true;
    }

    private void createAside(SplitNode splitNode, PutInfo.Put put, SplitNode splitNode2, double d) {
        SplitNode splitNode3 = splitNode.getParent();
        Node node = null;
        this.updateBounds();
        int n = splitNode3.getChildLocation(splitNode);
        node = this.access.createNode(-1L);
        if (put == PutInfo.Put.TOP) {
            node.setLeft(splitNode2);
            node.setRight(splitNode);
            node.setOrientation(Orientation.VERTICAL);
        } else if (put == PutInfo.Put.BOTTOM) {
            node.setLeft(splitNode);
            node.setRight(splitNode2);
            node.setOrientation(Orientation.VERTICAL);
        } else if (put == PutInfo.Put.LEFT) {
            node.setLeft(splitNode2);
            node.setRight(splitNode);
            node.setOrientation(Orientation.HORIZONTAL);
        } else {
            node.setLeft(splitNode);
            node.setRight(splitNode2);
            node.setOrientation(Orientation.HORIZONTAL);
        }
        node.setDivider(d);
        splitNode3.setChild(node, n);
        this.invalidate();
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
    }

    public void dropGrid(SplitDockGrid splitDockGrid) {
        this.dropTree(splitDockGrid.toTree());
    }

    public void dropTree(SplitDockTree<Dockable> splitDockTree) {
        this.dropTree(splitDockTree, true);
    }

    public void dropTree(SplitDockTree<Dockable> splitDockTree, boolean bl) {
        if (splitDockTree == null) {
            throw new IllegalArgumentException("Tree must not be null");
        }
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        try {
            Object object;
            this.access.arm();
            ++this.treeLock;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            this.setFullScreen(null);
            this.removeAllDockables();
            Dockable[] dockableArray = splitDockTree.getDockables();
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = dockableArray[n2];
                DockUtilities.ensureTreeValidity(this, (Dockable)object);
                ++n2;
            }
            object = splitDockTree.getRoot();
            if (object != null) {
                HashMap<Leaf, Dockable> hashMap = new HashMap<Leaf, Dockable>();
                this.root().evolve((SplitDockTree.Key)object, bl, hashMap);
                for (Map.Entry entry : hashMap.entrySet()) {
                    ((Leaf)entry.getKey()).setDockable((Dockable)entry.getValue(), null);
                }
                this.updateBounds();
            }
        }
        finally {
            --this.treeLock;
            if (dockController != null) {
                dockController.meltLayout();
            }
            this.access.fire();
        }
    }

    public DockableSplitDockTree createTree() {
        DockableSplitDockTree dockableSplitDockTree = new DockableSplitDockTree();
        this.createTree(new SplitDockTreeFactory(dockableSplitDockTree));
        return dockableSplitDockTree;
    }

    public void createTree(SplitDockTreeFactory splitDockTreeFactory) {
        this.root().submit(splitDockTreeFactory);
    }

    public <N> N visit(SplitTreeFactory<N> splitTreeFactory) {
        return this.root().submit(splitTreeFactory);
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.removeDockable(dockable);
    }

    protected void fireFullScreenChanged(Dockable dockable, Dockable dockable2) {
        SplitDockListener[] splitDockListenerArray = this.splitListeners.toArray(new SplitDockListener[this.splitListeners.size()]);
        int n = splitDockListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SplitDockListener splitDockListener = splitDockListenerArray[n2];
            splitDockListener.fullScreenDockableChanged(this, dockable, dockable2);
            ++n2;
        }
    }

    protected void fireTitleExchanged(DockTitle dockTitle) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener dockableListener = dockableListenerArray[n2];
            dockableListener.titleExchanged(this, dockTitle);
            ++n2;
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] dockTitleArray;
        DockTitle[] dockTitleArray2 = dockTitleArray = this.listBoundTitles();
        int n = dockTitleArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitle dockTitle = dockTitleArray2[n2];
            this.fireTitleExchanged(dockTitle);
            ++n2;
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public StationCombinerValue getCombiner() {
        return this.combiner;
    }

    @Override
    protected void paintOverlay(Graphics graphics) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.putInfo != null && !this.putInfo.willHaveNoEffect()) {
            object4 = this.getPaint();
            if (this.putInfo.getNode() == null) {
                object3 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                ((DefaultStationPaintValue)object4).drawInsertion(graphics, (Rectangle)object3, (Rectangle)object3);
            } else {
                object3 = this.putInfo.getCombinerTarget();
                if (object3 == null) {
                    object2 = this.putInfo.getNode();
                    if (((SplitNode)object2).getParent() == this.getRoot()) {
                        object2 = this.getRoot();
                    }
                    object = ((SplitNode)object2).getBounds();
                    if (this.putInfo.getPut() == PutInfo.Put.LEFT) {
                        ((Rectangle)object).width = (int)((double)((Rectangle)object).width * this.putInfo.getDivider() + 0.5);
                    } else if (this.putInfo.getPut() == PutInfo.Put.RIGHT) {
                        int n = ((Rectangle)object).width;
                        ((Rectangle)object).width = (int)((double)((Rectangle)object).width * (1.0 - this.putInfo.getDivider()) + 0.5);
                        ((Rectangle)object).x += n - ((Rectangle)object).width;
                    } else if (this.putInfo.getPut() == PutInfo.Put.TOP) {
                        ((Rectangle)object).height = (int)((double)((Rectangle)object).height * this.putInfo.getDivider() + 0.5);
                    } else if (this.putInfo.getPut() == PutInfo.Put.BOTTOM) {
                        int n = ((Rectangle)object).height;
                        ((Rectangle)object).height = (int)((double)((Rectangle)object).height * (1.0 - this.putInfo.getDivider()) + 0.5);
                        ((Rectangle)object).y += n - ((Rectangle)object).height;
                    }
                    ((DefaultStationPaintValue)object4).drawInsertion(graphics, this.putInfo.getNode().getBounds(), (Rectangle)object);
                } else {
                    object2 = this.putInfo.getNode().getBounds();
                    object = (StationPaint)((StationThemeItemValue)object4).get();
                    if (object != null) {
                        object3.paint(graphics, this.getComponent(), (StationPaint)object, (Rectangle)object2, (Rectangle)object2);
                    }
                }
            }
        }
        if ((object4 = this.dividerStrategy.getValue()) != null) {
            object4.paint(this, graphics);
        }
        if (this.dragInfo != null && this.dragInfo.getDockable() != null) {
            object3 = this.getRoot().getLeaf(this.dragInfo.getDockable());
            object2 = (StationPaint)this.paint.get();
            if (object2 != null && object3 != null) {
                object = ((SplitNode)object3).getBounds();
                object2.drawRemoval(graphics, this, (Rectangle)object, (Rectangle)object);
            }
        }
    }

    public void addDockable(Dockable dockable) {
        this.addDockable(dockable, null);
    }

    private void addDockable(Dockable dockable, DockHierarchyLock.Token token) {
        try {
            boolean bl = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (bl) {
                DockUtilities.ensureTreeValidity(this, dockable);
                token = DockHierarchyLock.acquireLinking(this, dockable);
            }
            try {
                if (bl) {
                    this.dockStationListeners.fireDockableAdding(dockable);
                }
                Leaf leaf = this.access.createLeaf(-1L);
                Root root = this.root();
                if (root.getChild() == null) {
                    root.setChild(leaf);
                } else {
                    SplitNode splitNode = root.getChild();
                    root.setChild(null);
                    Node node = this.access.createNode(-1L);
                    node.setLeft(leaf);
                    node.setRight(splitNode);
                    root.setChild(node);
                }
                leaf.setDockable(dockable, token);
                if (bl) {
                    this.dockStationListeners.fireDockableAdded(dockable);
                }
                this.revalidate();
            }
            finally {
                if (bl) {
                    token.release();
                }
            }
        }
        finally {
            this.access.fire();
        }
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    private void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (dockable == null) {
                throw new NullPointerException("previous must not be null");
            }
            if (dockable2 == null) {
                throw new NullPointerException("next must not be null");
            }
            if (dockable != dockable2) {
                Leaf leaf = this.root().getLeaf(dockable);
                if (leaf == null) {
                    throw new IllegalArgumentException("Previous is not child of this station");
                }
                DockUtilities.ensureTreeValidity(this, dockable2);
                boolean bl2 = this.isFullScreen() && this.getFullScreen() == dockable;
                leaf.setDockable(dockable2, null, true, bl);
                if (bl2) {
                    this.setFullScreen(dockable2);
                }
                this.revalidate();
                this.repaint();
            }
        }
        finally {
            this.access.fire();
        }
    }

    private void addHandle(StationChildHandle stationChildHandle, DockHierarchyLock.Token token) {
        boolean bl;
        Dockable dockable = stationChildHandle.getDockable();
        DockUtilities.ensureTreeValidity(this, dockable);
        boolean bl2 = bl = token == null;
        if (bl) {
            token = DockHierarchyLock.acquireLinking(this, dockable);
        }
        try {
            if (bl) {
                this.dockStationListeners.fireDockableAdding(dockable);
            }
            this.dockables.add(stationChildHandle);
            dockable.setDockParent(this);
            stationChildHandle.updateDisplayer();
            DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
            this.getContentPane().add(dockableDisplayer.getComponent());
            dockableDisplayer.getComponent().setVisible(!this.isFullScreen());
            if (bl) {
                this.dockStationListeners.fireDockableAdded(dockable);
            }
        }
        finally {
            if (bl) {
                token.release();
            }
        }
    }

    protected void discard(DockableDisplayer dockableDisplayer) {
        int n = this.indexOfDockable(dockableDisplayer.getDockable());
        if (n < 0) {
            throw new IllegalArgumentException("displayer unknown to this station: " + dockableDisplayer);
        }
        Dockable dockable = dockableDisplayer.getDockable();
        boolean bl = dockableDisplayer.getComponent().isVisible();
        Leaf leaf = this.root().getLeaf(dockable);
        this.getContentPane().remove(dockableDisplayer.getComponent());
        StationChildHandle stationChildHandle = leaf.getDockableHandle();
        stationChildHandle.updateDisplayer();
        dockableDisplayer = stationChildHandle.getDisplayer();
        this.getContentPane().add(dockableDisplayer.getComponent());
        dockableDisplayer.getComponent().setVisible(bl);
        this.revalidate();
    }

    public int indexOfDockable(Dockable dockable) {
        int n = 0;
        int n2 = this.dockables.size();
        while (n < n2) {
            if (this.dockables.get(n).getDockable() == dockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void removeAllDockables() {
        DockController dockController = this.getController();
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int n = this.getDockableCount() - 1;
            while (n >= 0) {
                this.removeDisplayer(n, null);
                --n;
            }
            this.root().setChild(null);
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
            this.access.fire();
        }
    }

    public void removeDockable(Dockable dockable) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            Leaf leaf = this.root().getLeaf(dockable);
            if (leaf != null) {
                leaf.setDockable(null, null, true, dockable.asDockStation() != null);
                leaf.placehold(true);
            }
        }
        finally {
            this.access.fire();
        }
    }

    public void removePlaceholder(Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        this.removePlaceholders(hashSet);
    }

    public void removePlaceholders(final Set<Path> set) {
        if (set.isEmpty()) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        this.root().visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
                this.handle(root);
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(placeholder);
            }

            @Override
            public void handleNode(Node node) {
                this.handle(node);
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                this.handle(leaf);
            }

            private void handle(SplitNode splitNode) {
                splitNode.removePlaceholders(set);
                if (!splitNode.isOfUse()) {
                    arrayList.add(splitNode);
                }
            }
        });
        for (SplitNode splitNode : arrayList) {
            splitNode.delete(true);
        }
    }

    private void removeHandle(StationChildHandle stationChildHandle, DockHierarchyLock.Token token) {
        int n = this.dockables.indexOf(stationChildHandle);
        if (n >= 0) {
            this.removeDisplayer(n, token);
        }
    }

    private void removeDisplayer(int n, DockHierarchyLock.Token token) {
        boolean bl;
        StationChildHandle stationChildHandle = this.dockables.get(n);
        if (stationChildHandle == this.fullScreenDockable) {
            this.setNextFullScreen();
            if (stationChildHandle == this.fullScreenDockable) {
                this.setFullScreen(null);
            }
        }
        Dockable dockable = stationChildHandle.getDockable();
        boolean bl2 = bl = token == null;
        if (bl) {
            token = DockHierarchyLock.acquireUnlinking(this, dockable);
        }
        try {
            if (bl) {
                this.dockStationListeners.fireDockableRemoving(dockable);
            }
            this.dockables.remove(n);
            DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
            dockableDisplayer.getComponent().setVisible(true);
            this.getContentPane().remove(dockableDisplayer.getComponent());
            stationChildHandle.destroy();
            if (dockable == this.frontDockable) {
                this.setFrontDockable(null);
            }
            dockable.setDockParent(null);
            if (bl) {
                this.dockStationListeners.fireDockableRemoved(dockable);
            }
        }
        finally {
            if (bl) {
                token.release();
            }
        }
    }

    public Root getRoot() {
        return this.root();
    }

    public SplitNode getNode(long l) {
        if (this.root == null) {
            return null;
        }
        class Visitor
        implements SplitNodeVisitor {
            private SplitNode result;
            private final /* synthetic */ long val$id;

            Visitor(long l) {
                this.val$id = l;
            }

            @Override
            public void handleRoot(Root root) {
                if (root.getId() == this.val$id) {
                    this.result = root;
                }
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                if (leaf.getId() == this.val$id) {
                    this.result = leaf;
                }
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                if (placeholder.getId() == this.val$id) {
                    this.result = placeholder;
                }
            }

            @Override
            public void handleNode(Node node) {
                if (node.getId() == this.val$id) {
                    this.result = node;
                }
            }
        }
        Visitor visitor = new Visitor(l);
        this.getRoot().visit(visitor);
        return visitor.result;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockStationFactory";
    }

    public void updateBounds() {
        Insets insets = this.getContentPane().getInsets();
        double d = this.getWidth() - insets.left - insets.right;
        double d2 = this.getHeight() - insets.top - insets.bottom;
        SplitLayoutManager splitLayoutManager = this.layoutManager.getValue();
        if (d <= 0.0 || d2 <= 0.0) {
            splitLayoutManager.updateBounds(this.root(), 0.0, 0.0, 0.0, 0.0);
        } else {
            splitLayoutManager.updateBounds(this.root(), (double)insets.left / d, (double)insets.top / d2, d, d2);
        }
    }

    protected Access getAccess() {
        return this.access;
    }

    protected class Access
    implements SplitDockAccess {
        private long lastUniqueId = -1L;
        private int repositionedArm = 0;
        private Set<Dockable> repositioned = new HashSet<Dockable>();
        private Dockable dockableSelected = null;

        protected Access() {
        }

        @Override
        public StationChildHandle getFullScreenDockable() {
            return SplitDockStation.this.fullScreenDockable;
        }

        @Override
        public DockTitleVersion getTitleVersion() {
            return SplitDockStation.this.title;
        }

        @Override
        public SplitDockStation getOwner() {
            return SplitDockStation.this;
        }

        @Override
        public double validateDivider(double d, Node node) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validateDivider(SplitDockStation.this, d, node);
        }

        @Override
        public StationChildHandle newHandle(Dockable dockable) {
            return new StationChildHandle(SplitDockStation.this, SplitDockStation.this.getDisplayers(), dockable, SplitDockStation.this.title);
        }

        @Override
        public void addHandle(StationChildHandle stationChildHandle, DockHierarchyLock.Token token) {
            SplitDockStation.this.addHandle(stationChildHandle, token);
        }

        @Override
        public void removeHandle(StationChildHandle stationChildHandle, DockHierarchyLock.Token token) {
            SplitDockStation.this.removeHandle(stationChildHandle, token);
        }

        @Override
        public boolean drop(Dockable dockable, SplitDockProperty splitDockProperty, SplitNode splitNode) {
            return SplitDockStation.this.drop(dockable, splitDockProperty, splitNode);
        }

        @Override
        public PutInfo validatePutInfo(PutInfo putInfo) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validatePutInfo(SplitDockStation.this, putInfo);
        }

        @Override
        public void repositioned(SplitNode splitNode) {
            this.arm();
            try {
                splitNode.visit(new SplitNodeVisitor(){

                    @Override
                    public void handleRoot(Root root) {
                    }

                    @Override
                    public void handlePlaceholder(Placeholder placeholder) {
                    }

                    @Override
                    public void handleNode(Node node) {
                    }

                    @Override
                    public void handleLeaf(Leaf leaf) {
                        Dockable dockable = leaf.getDockable();
                        if (dockable != null) {
                            Access.this.repositioned.add(dockable);
                        }
                    }
                });
            }
            finally {
                this.fire();
            }
        }

        public boolean isArmed() {
            return this.repositionedArm > 0;
        }

        public void dockableSelected(Dockable dockable) {
            this.arm();
            if (this.dockableSelected == null) {
                this.dockableSelected = dockable;
            }
            this.fire();
        }

        public void arm() {
            ++this.repositionedArm;
        }

        public void fire() {
            --this.repositionedArm;
            if (this.repositionedArm == 0) {
                ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
                for (Dockable dockable : this.repositioned) {
                    if (dockable.getDockParent() != SplitDockStation.this) continue;
                    arrayList.add(dockable);
                }
                this.repositioned.clear();
                if (arrayList.size() > 0) {
                    SplitDockStation.this.dockStationListeners.fireDockablesRepositioned(arrayList.toArray(new Dockable[arrayList.size()]));
                }
                if (this.dockableSelected != null) {
                    Dockable dockable;
                    dockable = SplitDockStation.this.getFrontDockable();
                    if (this.dockableSelected != dockable) {
                        SplitDockStation.this.dockStationListeners.fireDockableSelected(this.dockableSelected, dockable);
                    }
                    this.dockableSelected = null;
                }
            }
        }

        @Override
        public long uniqueID() {
            long l = System.currentTimeMillis();
            if (l <= this.lastUniqueId) {
                ++this.lastUniqueId;
                l = this.lastUniqueId + 1L;
            }
            while (SplitDockStation.this.getNode(l) != null) {
                ++l;
            }
            this.lastUniqueId = l;
            return l;
        }

        @Override
        public boolean isTreeAutoCleanupEnabled() {
            return SplitDockStation.this.treeLock == 0;
        }

        @Override
        public SplitPlaceholderSet getPlaceholderSet() {
            return SplitDockStation.this.placeholderSet;
        }

        @Override
        public SplitSpanStrategy getSpanStrategy() {
            return SplitDockStation.this.spanStrategy;
        }

        @Override
        public Leaf createLeaf(long l) {
            return SplitDockStation.this.nodeFactory.createLeaf(this, l);
        }

        @Override
        public Node createNode(long l) {
            return SplitDockStation.this.nodeFactory.createNode(this, l);
        }

        @Override
        public Placeholder createPlaceholder(long l) {
            return SplitDockStation.this.nodeFactory.createPlaceholder(this, l);
        }

        public Root createRoot(long l) {
            return SplitDockStation.this.nodeFactory.createRoot(this, l);
        }

        @Override
        public void setDropInfo(PutInfo putInfo) {
            SplitDockStation.this.setDropInfo(putInfo);
        }

        @Override
        public void unsetDropInfo() {
            SplitDockStation.this.unsetDropInfo();
        }

        @Override
        public void drop(DockHierarchyLock.Token token, PutInfo putInfo, StationDropItem stationDropItem) {
            SplitDockStation.this.drop(token, putInfo, stationDropItem);
        }

        @Override
        public void move(PutInfo putInfo, StationDropItem stationDropItem) {
            SplitDockStation.this.move(putInfo, stationDropItem);
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.split");
        }

        @Override
        public Component getComponent() {
            return SplitDockStation.this.getComponent();
        }

        @Override
        public DockStation getStation() {
            return SplitDockStation.this;
        }
    }

    private class Content
    extends ConfiguredBackgroundPanel {
        public Content() {
            super(Transparency.DEFAULT);
        }

        @Override
        public void doLayout() {
            SplitDockStation.this.updateBounds();
            Insets insets = this.getInsets();
            if (SplitDockStation.this.fullScreenDockable != null) {
                SplitDockStation.this.fullScreenDockable.getDisplayer().getComponent().setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.bottom - insets.top);
            }
        }

        @Override
        public void setTransparency(Transparency transparency) {
            super.setTransparency(transparency);
            SplitDockStation.this.setSolid(transparency == Transparency.SOLID);
        }
    }

    private static class DropInfo {
        public Leaf bestLeaf;
        public double bestLeafIntersection;
        public SplitNode bestNode;
        public double bestNodeIntersection = Double.POSITIVE_INFINITY;
        public PutInfo.Put bestNodePut;

        private DropInfo() {
        }

        public double getDivider(SplitDockProperty splitDockProperty) {
            double d = 0.5;
            if (this.bestNodePut == PutInfo.Put.LEFT) {
                d = splitDockProperty.getWidth() / this.bestNode.getWidth();
            } else if (this.bestNodePut == PutInfo.Put.RIGHT) {
                d = 1.0 - splitDockProperty.getWidth() / this.bestNode.getWidth();
            } else if (this.bestNodePut == PutInfo.Put.TOP) {
                d = splitDockProperty.getHeight() / this.bestNode.getHeight();
            } else if (this.bestNodePut == PutInfo.Put.BOTTOM) {
                d = 1.0 - splitDockProperty.getHeight() / this.bestNode.getHeight();
            }
            return Math.max(0.0, Math.min(1.0, d));
        }
    }

    private class FullScreenListener
    implements DoubleClickListener {
        private FullScreenListener() {
        }

        @Override
        public DockElement getTreeLocation() {
            return SplitDockStation.this;
        }

        @Override
        public boolean process(Dockable dockable, MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || !SplitDockStation.this.isExpandOnDoubleclick()) {
                return false;
            }
            if (dockable == SplitDockStation.this) {
                return false;
            }
            if ((dockable = this.unwrap(dockable)) != null) {
                if (SplitDockStation.this.isFullScreen()) {
                    if (SplitDockStation.this.getFullScreen() == dockable) {
                        SplitDockStation.this.setFullScreen(null);
                        mouseEvent.consume();
                    }
                } else {
                    SplitDockStation.this.setFullScreen(dockable);
                    mouseEvent.consume();
                }
                return true;
            }
            return false;
        }

        private Dockable unwrap(Dockable dockable) {
            while (dockable.getDockParent() != SplitDockStation.this) {
                DockStation dockStation = dockable.getDockParent();
                if (dockStation == null) {
                    return null;
                }
                dockable = dockStation.asDockable();
                if (dockable != null) continue;
                return null;
            }
            return dockable;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            SplitDockStation.this.visibility.fire();
        }
    }
}

