/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.DefaultFlapLayoutManager;
import bibliothek.gui.dock.station.flap.DefaultFlapWindowFactory;
import bibliothek.gui.dock.station.flap.FlapDockHoldToggle;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.flap.FlapDockStationSource;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import bibliothek.gui.dock.station.flap.FlapLayoutManagerListener;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindowFactory;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentFilter;
import bibliothek.gui.dock.station.flap.button.DefaultButtonContentFilter;
import bibliothek.gui.dock.station.flap.layer.FlapOverrideDropLayer;
import bibliothek.gui.dock.station.flap.layer.FlapSideDropLayer;
import bibliothek.gui.dock.station.flap.layer.WindowDropLayer;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerSourceWrapper;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.gui.dock.themes.basic.BasicButtonTitleFactory;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class FlapDockStation
extends AbstractDockableStation {
    public static final String WINDOW_TITLE_ID = "flap window";
    public static final String BUTTON_TITLE_ID = "flap button";
    public static final PropertyKey<FlapLayoutManager> LAYOUT_MANAGER = new PropertyKey<FlapLayoutManager>("flap dock station layout manager", new DynamicPropertyFactory<FlapLayoutManager>(){

        @Override
        public FlapLayoutManager getDefault(PropertyKey<FlapLayoutManager> propertyKey, DockProperties dockProperties) {
            return new DefaultFlapLayoutManager();
        }
    }, true);
    public static final PropertyKey<ButtonContent> BUTTON_CONTENT = new PropertyKey<ButtonContent>("flap dock station button content", new ConstantPropertyFactory<ButtonContent>(ButtonContent.THEME_DEPENDENT), true);
    public static final PropertyKey<ButtonContentFilter> BUTTON_CONTENT_FILTER = new PropertyKey<DefaultButtonContentFilter>("flap dock station button content connector", new ConstantPropertyFactory<DefaultButtonContentFilter>(new DefaultButtonContentFilter()), true);
    public static final PropertyKey<Dimension> MINIMUM_SIZE = new PropertyKey<Dimension>("flap dock station empty size", new ConstantPropertyFactory<Dimension>(new Dimension(0, 0)), true);
    public static final PropertyKey<FlapWindowFactory> WINDOW_FACTORY = new PropertyKey<DefaultFlapWindowFactory>("flap dock station window factory", new ConstantPropertyFactory<DefaultFlapWindowFactory>(new DefaultFlapWindowFactory()), true);
    private FlapLayoutManagerListener layoutManagerListener = new FlapLayoutManagerListener(){

        @Override
        public void holdSwitchableChanged(FlapLayoutManager flapLayoutManager, FlapDockStation flapDockStation, Dockable dockable) {
            if (flapDockStation == null || flapDockStation == FlapDockStation.this) {
                FlapDockStation.this.updateIsHoldSwitchable(dockable);
            }
        }
    };
    private PropertyValue<FlapLayoutManager> layoutManager = new PropertyValue<FlapLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(FlapLayoutManager flapLayoutManager, FlapLayoutManager flapLayoutManager2) {
            if (flapLayoutManager != null) {
                flapLayoutManager.removeListener(FlapDockStation.this.layoutManagerListener);
                flapLayoutManager.uninstall(FlapDockStation.this);
            }
            if (flapLayoutManager2 != null) {
                flapLayoutManager2.addListener(FlapDockStation.this.layoutManagerListener);
                flapLayoutManager2.install(FlapDockStation.this);
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            FlapDockStation.this.handles.setStrategy(placeholderStrategy2);
        }
    };
    private PropertyValue<ButtonContent> buttonContent = new PropertyValue<ButtonContent>(BUTTON_CONTENT){

        @Override
        protected void valueChanged(ButtonContent buttonContent, ButtonContent buttonContent2) {
            if (buttonContent != buttonContent2) {
                FlapDockStation.this.recreateTitles();
            }
        }
    };
    private PropertyValue<Dimension> minimumSize = new PropertyValue<Dimension>(MINIMUM_SIZE){

        @Override
        protected void valueChanged(Dimension dimension, Dimension dimension2) {
            FlapDockStation.this.buttonPane.revalidate();
        }
    };
    private PropertyValue<FlapWindowFactory> windowFactory = new PropertyValue<FlapWindowFactory>(WINDOW_FACTORY){

        @Override
        protected void valueChanged(FlapWindowFactory flapWindowFactory, FlapWindowFactory flapWindowFactory2) {
            if (flapWindowFactory != null) {
                flapWindowFactory.uninstall(FlapDockStation.this);
            }
            if (flapWindowFactory2 != null) {
                flapWindowFactory2.install(FlapDockStation.this);
            }
            FlapDockStation.this.updateWindow(FlapDockStation.this.getFrontDockable(), true);
        }
    };
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy disablingStrategy, DisablingStrategy disablingStrategy2) {
            if (disablingStrategy != null) {
                disablingStrategy.removeDisablingStrategyListener(FlapDockStation.this.disablingStrategyListener);
            }
            if (disablingStrategy2 != null) {
                disablingStrategy2.addDisablingStrategyListener(FlapDockStation.this.disablingStrategyListener);
                if (disablingStrategy2.isDisabled(FlapDockStation.this)) {
                    FlapDockStation.this.setFrontDockable(null);
                }
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        @Override
        public void changed(DockElement dockElement) {
            if (dockElement == FlapDockStation.this && ((DisablingStrategy)FlapDockStation.this.disablingStrategy.getValue()).isDisabled(dockElement)) {
                FlapDockStation.this.setFrontDockable(null);
            }
        }
    };
    private Direction direction = Direction.SOUTH;
    private boolean autoDirection = true;
    private FlapWindow window;
    private int windowBorder = 3;
    private int windowMinSize = 25;
    private int defaultWindowSize = 400;
    private Dockable oldFrontDockable;
    private DockablePlaceholderList<DockableHandle> handles = new DockablePlaceholderList();
    private Listener dockableListener = new Listener();
    private ButtonPane buttonPane;
    private DockTitleVersion buttonVersion;
    private DockTitleVersion titleVersion;
    private DefaultStationPaintValue paint;
    private StationCombinerValue combiner;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private FlapDropInfo dropInfo;
    private StationDragOperation dragInfo;
    private ControllerListener controllerListener = new ControllerListener();
    private boolean smallButtons = true;
    private ListeningDockAction holdAction;
    private VisibleListener visibleListener = new VisibleListener();
    private boolean lastShowing = false;
    private List<FlapDockListener> flapDockListeners = new ArrayList<FlapDockListener>();
    private DockableShowingManager showingManager;
    private Background background = new Background();
    private int borderSideSnapSize = 15;

    public FlapDockStation() {
        this.init();
    }

    protected FlapDockStation(boolean bl) {
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.showingManager = new DockableShowingManager(this.listeners);
        this.buttonPane = this.createButtonPane();
        this.buttonPane.setBackground(this.background);
        this.buttonPane.setController(this.getController());
        this.setDirection(Direction.SOUTH);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.flap", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory);
        this.paint = new DefaultStationPaintValue("dock.paint.flap", this);
        this.combiner = new StationCombinerValue("dock.combiner.flap", this);
        this.buttonPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.buttonPane.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                if (FlapDockStation.this.autoDirection) {
                    FlapDockStation.this.selfSetDirection();
                } else {
                    FlapDockStation.this.updateWindowBounds();
                }
            }
        });
        this.buttonPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (FlapDockStation.this.getDockParent() == null) {
                        FlapDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    FlapDockStation.this.checkShowing();
                }
            }
        });
        this.holdAction = this.createHoldAction();
    }

    protected ButtonPane createButtonPane() {
        return new ButtonPane(this);
    }

    protected ListeningDockAction createHoldAction() {
        return new FlapDockHoldToggle(this);
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                if (FlapDockStation.this.buttonPane.getBasePane() == component) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE_CHILDREN;
                }
                if (FlapDockStation.this.displayers.isDisplayerComponent(component)) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.getDockParent() != null) {
            this.getDockParent().removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            Object object2;
            boolean bl;
            boolean bl2 = bl = this.getController() != null;
            if (bl) {
                this.handles.unbind();
                this.getController().removeDockableFocusListener(this.controllerListener);
                this.getController().getFocusController().removeVetoListener(this.controllerListener);
                this.oldFrontDockable = this.getFrontDockable();
                this.setFrontDockable(null);
                for (Object object2 : this.handles.dockables()) {
                    if (object2 == null) continue;
                    ((DockableHandle)object2).setTitle(null);
                }
                if (this.window != null) {
                    this.window.setDockTitle(null);
                }
                this.titleVersion = null;
                this.buttonVersion = null;
            }
            super.setController(dockController);
            this.placeholderStrategy.setProperties(dockController);
            this.displayers.setController(dockController);
            this.paint.setController(dockController);
            this.displayerFactory.setController(dockController);
            this.combiner.setController(dockController);
            this.background.setController(dockController);
            if (this.window != null) {
                this.window.setController(dockController);
            }
            this.disablingStrategy.setProperties(dockController);
            this.buttonPane.setController(dockController);
            object2 = this.layoutManager.getValue();
            this.layoutManager.setProperties(dockController);
            FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
            if (object2 == flapLayoutManager) {
                if (dockController == null) {
                    if (object2 != null) {
                        object2.uninstall(this);
                    }
                } else if (flapLayoutManager != null) {
                    flapLayoutManager.install(this);
                }
            }
            this.buttonContent.setProperties(dockController);
            this.minimumSize.setProperties(dockController);
            if (this.holdAction != null) {
                this.holdAction.setController(dockController);
            }
            if (dockController != null) {
                this.handles.bind();
                this.titleVersion = dockController.getDockTitleManager().getVersion(WINDOW_TITLE_ID, ControllerTitleFactory.INSTANCE);
                this.buttonVersion = dockController.getDockTitleManager().getVersion(BUTTON_TITLE_ID, BasicButtonTitleFactory.FACTORY);
                for (DockableHandle dockableHandle : this.handles.dockables()) {
                    if (dockableHandle == null) continue;
                    dockableHandle.setTitle(this.buttonVersion);
                }
                if (this.window != null) {
                    this.window.setDockTitle(this.titleVersion);
                }
                dockController.addDockableFocusListener(this.controllerListener);
                dockController.getFocusController().addVetoListener(this.controllerListener);
                if (this.isStationShowing()) {
                    this.setFrontDockable(this.oldFrontDockable);
                }
            }
            this.windowFactory.setProperties(dockController);
            this.buttonPane.setProperties(dockController);
            this.buttonPane.resetTitles();
            this.showingManager.fire();
        }
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new FlapDockStationFactory());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this.direction = direction;
        DockTitle.Orientation orientation = this.orientation(direction);
        for (DockableHandle dockableHandle : this.handles.dockables()) {
            DockTitle dockTitle = dockableHandle.getTitle();
            if (dockTitle == null) continue;
            dockTitle.setOrientation(orientation);
        }
        this.buttonPane.resetTitles();
        this.updateWindowBounds();
        this.buttonPane.revalidate();
    }

    protected DockTitle.Orientation orientation(Direction direction) {
        switch (direction) {
            case NORTH: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case SOUTH: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case EAST: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case WEST: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    protected void updateWindowBounds() {
        if (this.window != null) {
            this.window.updateBounds();
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize.getValue();
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumSize.setValue(dimension);
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public StationCombinerValue getCombiner() {
        return this.combiner;
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public Rectangle getExpansionBounds() {
        Component component = this.getComponent();
        return new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public boolean isAutoDirection() {
        return this.autoDirection;
    }

    public void setAutoDirection(boolean bl) {
        this.autoDirection = bl;
        if (bl) {
            this.selfSetDirection();
        }
    }

    public void selfSetDirection() {
        Component component = this.getComponent();
        Point point = new Point(component.getWidth() / 2, component.getHeight() / 2);
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Direction direction = component.getWidth() > component.getHeight() ? (point.y < dimension.height / 2 ? Direction.SOUTH : Direction.NORTH) : (point.x < dimension.width / 2 ? Direction.EAST : Direction.WEST);
        if (direction != this.direction) {
            this.setDirection(direction);
        } else {
            this.updateWindowBounds();
        }
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.window == null) {
            return null;
        }
        return this.window.getDockable();
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        DockTitle dockTitle;
        int n;
        int n2;
        DockTitle[] dockTitleArray;
        boolean bl;
        DockTitle[] dockTitleArray2;
        Dockable dockable2 = this.getFrontDockable();
        if (dockable2 == dockable) {
            return;
        }
        this.updateWindow(dockable, false);
        if (this.getController() != null && dockable2 != null) {
            dockTitleArray2 = dockable2.listBoundTitles();
            bl = this.getController().isFocused(dockable2);
            dockTitleArray = dockTitleArray2;
            n2 = dockTitleArray2.length;
            n = 0;
            while (n < n2) {
                dockTitle = dockTitleArray[n];
                this.changed(dockable2, dockTitle, bl);
                ++n;
            }
        }
        if (this.window != null) {
            if (this.window.getDockable() == null) {
                this.window.setWindowVisible(false);
            } else {
                this.window.repaint();
            }
        }
        if (this.getController() != null && dockable != null) {
            dockTitleArray2 = dockable.listBoundTitles();
            bl = this.getController().isFocused(dockable);
            dockTitleArray = dockTitleArray2;
            n2 = dockTitleArray2.length;
            n = 0;
            while (n < n2) {
                dockTitle = dockTitleArray[n];
                this.changed(dockable, dockTitle, bl);
                ++n;
            }
        }
        this.showingManager.fire();
        this.listeners.fireDockableSelected(dockable2, dockable);
    }

    private void updateWindow(Dockable dockable, boolean bl) {
        if (dockable == null) {
            if (this.window != null) {
                this.window.setDockable(null);
                if (bl) {
                    this.setFlapWindow(null);
                }
            }
        } else {
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (this.window == null || bl || !this.windowFactory.getValue().isValid(this.window, this)) {
                FlapWindow flapWindow;
                if (this.window != null) {
                    this.window.setDockable(null);
                }
                if ((flapWindow = this.createFlapWindow(this.buttonPane)) != null) {
                    this.setFlapWindow(flapWindow);
                }
            }
            if (this.window != null && window != null) {
                this.window.setDockable(dockable);
                if (window.isVisible()) {
                    this.window.setWindowVisible(true);
                }
                this.updateWindowBounds();
            }
        }
    }

    protected FlapWindow createFlapWindow(ButtonPane buttonPane) {
        FlapWindow flapWindow = this.windowFactory.getValue().create(this, buttonPane);
        if (flapWindow != null) {
            flapWindow.setDockTitle(this.titleVersion);
        }
        return flapWindow;
    }

    public boolean isHold(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager == null) {
            return false;
        }
        return flapLayoutManager.isHold(this, dockable);
    }

    public void setHold(Dockable dockable, boolean bl) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            boolean bl2 = flapLayoutManager.isHold(this, dockable);
            flapLayoutManager.setHold(this, dockable, bl);
            bl = flapLayoutManager.isHold(this, dockable);
            if (bl2 != bl) {
                this.updateHold(dockable);
            }
        }
    }

    public void updateHold(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            boolean bl = flapLayoutManager.isHold(this, dockable);
            this.fireHoldChanged(dockable, bl);
            if (!bl && this.getController() != null && this.getFrontDockable() == dockable && !this.getController().isFocused(dockable)) {
                this.setFrontDockable(null);
            }
        }
    }

    public boolean isSmallButtons() {
        return this.smallButtons;
    }

    public void setSmallButtons(boolean bl) {
        this.smallButtons = bl;
    }

    public DockTitleVersion getTitleVersion() {
        return this.titleVersion;
    }

    public DockTitleVersion getButtonVersion() {
        return this.buttonVersion;
    }

    public int getWindowBorder() {
        return this.windowBorder;
    }

    public void setWindowBorder(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Border must not be less than 0");
        }
        this.windowBorder = n;
        this.updateWindowBounds();
    }

    public int getWindowMinSize() {
        return this.windowMinSize;
    }

    public void setWindowMinSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Min size must not be smaller than 0");
        }
        this.windowMinSize = n;
        this.updateWindowBounds();
    }

    public int getWindowSize(Dockable dockable) {
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager == null) {
            return 0;
        }
        return flapLayoutManager.getSize(this, dockable);
    }

    public void setWindowSize(Dockable dockable, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Size must at least be 0");
        }
        FlapLayoutManager flapLayoutManager = this.layoutManager.getValue();
        if (flapLayoutManager != null) {
            flapLayoutManager.setSize(this, dockable, n);
            this.updateWindowSize(dockable);
        }
    }

    public void updateWindowSize(Dockable dockable) {
        if (this.getFrontDockable() == dockable) {
            this.updateWindowBounds();
        }
    }

    public void setDefaultWindowSize(int n) {
        this.defaultWindowSize = n;
    }

    public int getDefaultWindowSize() {
        return this.defaultWindowSize;
    }

    public void setFlapLayoutManager(FlapLayoutManager flapLayoutManager) {
        this.layoutManager.setValue(flapLayoutManager);
    }

    public FlapLayoutManager getFlapLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public FlapLayoutManager getCurrentFlapLayoutManager() {
        return this.layoutManager.getValue();
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    public void addFlapDockStationListener(FlapDockListener flapDockListener) {
        this.flapDockListeners.add(flapDockListener);
    }

    public void removeFlapDockStationListener(FlapDockListener flapDockListener) {
        this.flapDockListeners.remove(flapDockListener);
    }

    protected void fireHoldChanged(Dockable dockable, boolean bl) {
        FlapDockListener[] flapDockListenerArray = this.flapDockListeners.toArray(new FlapDockListener[this.flapDockListeners.size()]);
        int n = flapDockListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlapDockListener flapDockListener = flapDockListenerArray[n2];
            flapDockListener.holdChanged(this, dockable, bl);
            ++n2;
        }
    }

    @Override
    public DockActionSource getDirectActionOffers(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n < 0) {
            return null;
        }
        DockableHandle dockableHandle = (DockableHandle)this.handles.dockables().get(n);
        return dockableHandle.getActions();
    }

    private void updateIsHoldSwitchable(Dockable dockable) {
        if (dockable == null) {
            for (DockableHandle dockableHandle : this.handles.dockables()) {
                dockableHandle.getActions().updateHoldSwitchable();
            }
        } else {
            int n = this.indexOf(dockable);
            if (n >= 0) {
                DockableHandle dockableHandle = (DockableHandle)this.handles.dockables().get(n);
                dockableHandle.getActions().updateHoldSwitchable();
            }
        }
    }

    @Override
    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        ActivityDockTitleEvent activityDockTitleEvent = new ActivityDockTitleEvent(this, dockable, bl);
        activityDockTitleEvent.setPreferred(dockable == this.getFrontDockable());
        dockTitle.changed(activityDockTitleEvent);
    }

    private void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        if (this.window != null) {
            this.window.setDropInfo(flapDropInfo);
        }
        if (this.buttonPane != null) {
            this.buttonPane.setDropInfo(flapDropInfo);
        }
    }

    private void setFlapWindow(FlapWindow flapWindow) {
        if (this.window != null) {
            this.getRootHandler().removeRoot(flapWindow.getComponent());
            this.window.setController(null);
            this.window.destroy();
        }
        this.window = flapWindow;
        if (flapWindow != null) {
            flapWindow.setController(this.getController());
            flapWindow.setDropInfo(this.dropInfo);
            this.getRootHandler().removeRoot(flapWindow.getComponent());
        }
    }

    public boolean isFlapWindow(FlapWindow flapWindow) {
        return this.window == flapWindow;
    }

    public FlapWindow getFlapWindow() {
        return this.window;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.handles.toMap();
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.handles){

            @Override
            public DockableProperty getLocationAt(Path path) {
                int n = FlapDockStation.this.handles.getDockableIndex(path);
                return new FlapDockProperty(n, false, -1, path);
            }
        };
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("only allowed if there are not children present");
        }
        try {
            DockablePlaceholderList dockablePlaceholderList = new DockablePlaceholderList(placeholderMap);
            if (this.getController() != null) {
                this.handles.setStrategy(null);
                this.handles.unbind();
                this.handles = dockablePlaceholderList;
                this.handles.bind();
                this.handles.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.handles = dockablePlaceholderList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> map) {
        final PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        return this.handles.toMap(new PlaceholderListItemAdapter<Dockable, DockableHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, DockableHandle dockableHandle) {
                Path path;
                Integer n2 = (Integer)map.get(dockableHandle.getDockable());
                if (n2 == null) {
                    return null;
                }
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", n2);
                convertedPlaceholderListItem.putInt("index", n);
                convertedPlaceholderListItem.putBoolean("hold", FlapDockStation.this.isHold(dockableHandle.getDockable()));
                convertedPlaceholderListItem.putInt("size", FlapDockStation.this.getWindowSize(dockableHandle.getDockable()));
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockableHandle.getDockable())) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    public void setPlaceholders(PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
                this.handles.setStrategy(null);
                this.handles.unbind();
            }
            this.handles = new DockablePlaceholderList();
            this.handles.read(placeholderMap, new PlaceholderListItemAdapter<Dockable, DockableHandle>(){
                private DockHierarchyLock.Token token;

                @Override
                public DockableHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    Dockable dockable = (Dockable)map.get(n);
                    if (dockable != null) {
                        DockUtilities.ensureTreeValidity(FlapDockStation.this, dockable);
                        this.token = DockHierarchyLock.acquireLinking(FlapDockStation.this, dockable);
                        boolean bl = convertedPlaceholderListItem.getBoolean("hold");
                        int n2 = convertedPlaceholderListItem.getInt("size");
                        FlapDockStation.this.listeners.fireDockableAdding(dockable);
                        DockableHandle dockableHandle = FlapDockStation.this.link(dockable);
                        FlapDockStation.this.setHold(dockable, bl);
                        FlapDockStation.this.setWindowSize(dockable, n2);
                        return dockableHandle;
                    }
                    return null;
                }

                @Override
                public void added(DockableHandle dockableHandle) {
                    try {
                        dockableHandle.getDockable().setDockParent(FlapDockStation.this);
                        FlapDockStation.this.listeners.fireDockableAdded(dockableHandle.getDockable());
                    }
                    finally {
                        this.token.releaseNoCheck();
                    }
                }
            });
            if (this.getController() != null) {
                this.handles.bind();
                this.handles.setStrategy(this.getPlaceholderStrategy());
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
        this.buttonPane.resetTitles();
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        if (this.getDockableCount() == 0) {
            return new DockStationDropLayer[]{new DefaultDropLayer(this), new FlapOverrideDropLayer(this), new WindowDropLayer(this), new FlapSideDropLayer(this)};
        }
        return new DockStationDropLayer[]{new DefaultDropLayer(this), new FlapOverrideDropLayer(this), new WindowDropLayer(this)};
    }

    public void setBorderSideSnapSize(int n) {
        this.borderSideSnapSize = n;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        if (this.dragInfo != null) {
            this.dragInfo.canceled();
        }
        if (this.window != null && this.window.getDockable() == dockable) {
            this.window.setRemoval(true);
            this.dragInfo = new StationDragOperation(){

                @Override
                public void succeeded() {
                    FlapDockStation.this.window.setRemoval(false);
                    FlapDockStation.this.dragInfo = null;
                }

                @Override
                public void canceled() {
                    FlapDockStation.this.window.setRemoval(false);
                    FlapDockStation.this.dragInfo = null;
                }
            };
        }
        return this.dragInfo;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem stationDropItem) {
        Object object;
        Object object2;
        boolean bl;
        int n = stationDropItem.getMouseX();
        int n2 = stationDropItem.getMouseY();
        Dockable dockable = stationDropItem.getDockable();
        boolean bl2 = bl = dockable.getDockParent() == this;
        if (SwingUtilities.isDescendingFrom(this.getComponent(), dockable.getComponent())) {
            return null;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.buttonPane);
        FlapDropInfo flapDropInfo = null;
        MultiDockAcceptance multiDockAcceptance = this.getController().getAcceptance();
        if (this.window != null && this.window.isWindowVisible() && (object2 = this.window.getDockTitle()) != null) {
            boolean bl3;
            object = object2.getComponent();
            Point point2 = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point2, (Component)object);
            Dockable dockable2 = this.window.getDockable();
            boolean bl4 = bl3 = ((Component)object).contains(point2) && this.acceptable(dockable2, dockable);
            if (bl3) {
                flapDropInfo = this.prepareCombine(dockable, this.window, new Point(n, n2), bl3, Enforcement.HARD);
            }
        }
        if (this.window != null && this.window.isWindowVisible() && flapDropInfo == null) {
            boolean bl5;
            object2 = new Point(n, n2);
            object = this.window.getDockable();
            boolean bl6 = bl5 = this.window.containsScreenPoint((Point)object2) && this.acceptable((Dockable)object, dockable);
            if (bl5) {
                flapDropInfo = this.prepareCombine(dockable, this.window, (Point)object2, false, Enforcement.HARD);
            }
        }
        if (flapDropInfo != null && dockable == this.getFrontDockable()) {
            return null;
        }
        if (flapDropInfo == null && dockable.accept(this) && this.accept(dockable) && multiDockAcceptance.accept(this, dockable)) {
            flapDropInfo = new FlapDropInfo(this, dockable){

                @Override
                public Point getMousePosition() {
                    return null;
                }

                @Override
                public Dockable getOld() {
                    return null;
                }

                @Override
                public DockableDisplayer getOldDisplayer() {
                    return null;
                }

                @Override
                public PlaceholderMap getPlaceholders() {
                    return null;
                }

                @Override
                public Dimension getSize() {
                    return null;
                }

                @Override
                public boolean isMouseOverTitle() {
                    return false;
                }
            };
            flapDropInfo.setIndex(this.buttonPane.indexAt(point.x, point.y));
        }
        if (flapDropInfo == null) {
            return null;
        }
        return new FlapDropOperation(flapDropInfo, bl);
    }

    private FlapDropInfo prepareCombine(Dockable dockable, FlapWindow flapWindow, final Point point, final boolean bl, Enforcement enforcement) {
        DockableDisplayer dockableDisplayer;
        final Dockable dockable2 = flapWindow.getDockable();
        FlapDropInfo flapDropInfo = new FlapDropInfo(this, dockable, dockableDisplayer = flapWindow.getDisplayer()){
            private final /* synthetic */ DockableDisplayer val$displayer;
            {
                this.val$displayer = dockableDisplayer;
                super(flapDockStation2, dockable);
            }

            @Override
            public boolean isMouseOverTitle() {
                return bl;
            }

            @Override
            public Dimension getSize() {
                return dockable2.getComponent().getSize();
            }

            @Override
            public PlaceholderMap getPlaceholders() {
                for (PlaceholderList.Item item : FlapDockStation.this.handles.list()) {
                    DockableHandle dockableHandle = (DockableHandle)item.getDockable();
                    if (dockableHandle == null || dockableHandle.getDockable() != dockable2) continue;
                    return item.getPlaceholderMap();
                }
                return null;
            }

            @Override
            public Point getMousePosition() {
                Point point2 = new Point(point);
                SwingUtilities.convertPointFromScreen(point2, this.getOld().getComponent());
                return point2;
            }

            @Override
            public Dockable getOld() {
                return dockable2;
            }

            @Override
            public DockableDisplayer getOldDisplayer() {
                return this.val$displayer;
            }
        };
        CombinerTarget combinerTarget = this.combiner.prepare(flapDropInfo, enforcement);
        if (combinerTarget == null) {
            return null;
        }
        flapDropInfo.setCombineTarget(combinerTarget);
        return flapDropInfo;
    }

    @Override
    public void drop(Dockable dockable) {
        this.add(dockable);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            return this.drop(dockable, (FlapDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, FlapDockProperty flapDockProperty) {
        Object object;
        DockUtilities.checkLayoutLocked();
        boolean bl = false;
        Path path = flapDockProperty.getPlaceholder();
        DockableProperty dockableProperty = flapDockProperty.getSuccessor();
        int n = flapDockProperty.getIndex();
        boolean bl2 = this.acceptable(dockable);
        if (path != null && dockableProperty != null && (object = (DockableHandle)this.handles.getDockableAt(path)) != null) {
            Dockable dockable2 = ((DockableHandle)object).getDockable();
            DockStation dockStation = dockable2.asDockStation();
            if (dockStation != null) {
                if (dockStation.drop(dockable, dockableProperty)) {
                    bl = true;
                    this.handles.removeAll(path);
                }
            } else {
                bl = this.combine(((DockableHandle)object).getDockable(), dockable, dockableProperty);
            }
        }
        if (path != null && !bl) {
            int n2 = this.handles.getListIndex(path);
            if (n2 >= 0) {
                this.add(dockable, flapDockProperty.getIndex(), n2);
                this.setHold(dockable, flapDockProperty.isHolding());
                int n3 = flapDockProperty.getSize();
                if (n3 >= this.getWindowMinSize()) {
                    this.setWindowSize(dockable, n3);
                }
                bl = true;
            } else {
                n = this.handles.getDockableIndex(path);
                if (n == -1) {
                    n = flapDockProperty.getIndex();
                }
            }
        }
        if (!bl && n >= this.getDockableCount() && bl2) {
            this.add(dockable);
            this.setHold(dockable, flapDockProperty.isHolding());
            int n4 = flapDockProperty.getSize();
            if (n4 >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, n4);
            }
            bl = true;
        }
        if (!bl && dockableProperty != null) {
            object = this.getDockable(n).asDockStation();
            if (object != null) {
                if (object.drop(dockable, dockableProperty)) {
                    bl = true;
                }
            } else {
                bl = this.combine(this.getDockable(n), dockable, dockableProperty);
            }
        }
        if (!bl && bl2) {
            this.add(dockable, n);
            this.setHold(dockable, flapDockProperty.isHolding());
            int n5 = flapDockProperty.getSize();
            if (n5 >= this.getWindowMinSize()) {
                this.setWindowSize(dockable, n5);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        boolean bl = this.isHold(dockable);
        int n2 = this.getWindowSize(dockable);
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        Path path = null;
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2 == null ? dockable : dockable2)) != null) {
            this.handles.dockables().addPlaceholder(n, path);
        }
        return new FlapDockProperty(n, bl, n2, path);
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        DockableProperty dockableProperty = asideRequest.getLocation();
        if (dockableProperty instanceof FlapDockProperty) {
            FlapDockProperty flapDockProperty = (FlapDockProperty)dockableProperty;
            PlaceholderList.Item item = this.getItem(flapDockProperty);
            if (item != null) {
                this.delegate().combine(item, this.getCombiner(), asideRequest);
            }
            FlapDockProperty flapDockProperty2 = flapDockProperty.copy();
            flapDockProperty2.setSuccessor(null);
            flapDockProperty2.setPlaceholder(asideRequest.getPlaceholder());
            asideRequest.answer(flapDockProperty2);
        }
    }

    private PlaceholderList.Item getItem(FlapDockProperty flapDockProperty) {
        PlaceholderList.Item item;
        Path path = flapDockProperty.getPlaceholder();
        if (path != null && (item = this.handles.getItem(path)) != null) {
            return item;
        }
        if (flapDockProperty.getIndex() >= 0 && flapDockProperty.getIndex() < this.handles.dockables().size()) {
            int n = this.handles.levelToBase(flapDockProperty.getIndex(), PlaceholderList.Level.DOCKABLE);
            return this.handles.list().get(n);
        }
        return null;
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        DockUtilities.checkLayoutLocked();
        if (dockableProperty instanceof FlapDockProperty) {
            int n = this.indexOf(dockable);
            if (n < 0) {
                throw new IllegalArgumentException("dockable is not child of this station");
            }
            int n2 = ((FlapDockProperty)dockableProperty).getIndex();
            n2 = Math.min(n2, this.handles.dockables().size() - 1);
            if ((n2 = Math.max(0, n2)) != n) {
                this.handles.dockables().move(n, n2);
                this.buttonPane.resetTitles();
                this.fireDockablesRepositioned(Math.min(n, n2), Math.max(n, n2));
            }
        }
    }

    public boolean isOverButtons(int n, int n2) {
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.buttonPane);
        return this.buttonPane.contains(point);
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        this.remove(dockable);
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public Component getComponent() {
        return this.buttonPane;
    }

    @Override
    public int getDockableCount() {
        return this.handles.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return ((DockableHandle)this.handles.dockables().get(n)).getDockable();
    }

    public DockTitle getButton(int n) {
        return ((DockableHandle)this.handles.dockables().get(n)).getTitle();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationShowing() && this.getFrontDockable() == dockable;
    }

    protected void recreateTitles() {
        for (DockableHandle dockableHandle : this.handles.dockables()) {
            dockableHandle.setTitle(this.buttonVersion);
        }
    }

    public void remove(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        DockUtilities.checkLayoutLocked();
        Dockable dockable = this.getDockable(n);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        if (this.oldFrontDockable == dockable) {
            this.oldFrontDockable = null;
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            DockableHandle dockableHandle = (DockableHandle)this.handles.dockables().get(n);
            this.handles.remove(n);
            dockableHandle.setTitle(null);
            dockable.removeDockableListener(this.dockableListener);
            this.buttonPane.resetTitles();
            this.listeners.fireDockableRemoved(dockable);
        }
        finally {
            token.release();
        }
        this.fireDockablesRepositioned(n);
    }

    public void add(Dockable dockable) {
        this.add(dockable, this.getDockableCount());
    }

    public void add(Dockable dockable, int n) {
        this.add(dockable, n, -1);
    }

    private void add(Dockable dockable, int n, int n2) {
        DockUtilities.checkLayoutLocked();
        DockUtilities.ensureTreeValidity(this, dockable);
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            DockableHandle dockableHandle = this.link(dockable);
            if (n2 == -1 || this.handles.list().get(n2).getDockable() != null) {
                this.handles.dockables().add(n, dockableHandle);
            } else if (this.handles.list().get(n2).getDockable() == null) {
                this.handles.list().get(n2).setDockable(dockableHandle);
            }
            dockable.setDockParent(this);
            this.buttonPane.resetTitles();
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(n + 1);
            if (this.getController().isFocused(dockable)) {
                this.setFrontDockable(dockable);
            }
        }
        finally {
            token.release();
        }
    }

    private DockableHandle link(Dockable dockable) {
        DockableHandle dockableHandle = this.createHandle(dockable);
        dockableHandle.setTitle(this.buttonVersion);
        dockable.addDockableListener(this.dockableListener);
        return dockableHandle;
    }

    protected DockableHandle createHandle(Dockable dockable) {
        return new DockableHandle(dockable);
    }

    protected DockableHandle getHandle(Dockable dockable) {
        int n = this.indexOf(dockable);
        if (n < 0) {
            return null;
        }
        return (DockableHandle)this.handles.dockables().get(n);
    }

    public boolean combine(Dockable dockable, Dockable dockable2) {
        return this.combine(dockable, dockable2, null);
    }

    public boolean combine(final Dockable dockable, Dockable dockable2, DockableProperty dockableProperty) {
        DockUtilities.checkLayoutLocked();
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("Child must be a child of this station");
        }
        int n2 = this.handles.levelToBase(n, PlaceholderList.Level.DOCKABLE);
        PlaceholderList.Item item = this.handles.list().get(n2);
        final PlaceholderMap placeholderMap = item.getPlaceholderMap();
        FlapDropInfo flapDropInfo = new FlapDropInfo(this, dockable2){

            @Override
            public boolean isMouseOverTitle() {
                return true;
            }

            @Override
            public Dimension getSize() {
                return null;
            }

            @Override
            public PlaceholderMap getPlaceholders() {
                return placeholderMap;
            }

            @Override
            public Dockable getOld() {
                return dockable;
            }

            @Override
            public DockableDisplayer getOldDisplayer() {
                return null;
            }

            @Override
            public Point getMousePosition() {
                return null;
            }
        };
        CombinerTarget combinerTarget = this.combiner.prepare(flapDropInfo, Enforcement.HARD);
        return this.combine(flapDropInfo, combinerTarget, dockableProperty);
    }

    private boolean combine(CombinerSource combinerSource, CombinerTarget combinerTarget, DockableProperty dockableProperty) {
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        Dockable dockable = combinerSource.getOld();
        Dockable dockable2 = combinerSource.getNew();
        DockUtilities.ensureTreeValidity(this, dockable2);
        try {
            Object object;
            int n;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n = this.indexOf(dockable)) < 0) {
                throw new IllegalArgumentException("old dockable must be a child of this station");
            }
            if (dockable2.getDockParent() != null) {
                dockable2.getDockParent().drag(dockable2);
            }
            boolean bl = this.isHold(dockable);
            int n2 = this.handles.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.handles.list().get(n2);
            final PlaceholderMap placeholderMap = item.getPlaceholderMap();
            item.setPlaceholderMap(null);
            this.remove(n);
            int n3 = this.indexOf(dockable2);
            if (n3 >= 0) {
                this.remove(n3);
                if (n3 < n) {
                    --n;
                }
            }
            n = Math.min(n, this.getDockableCount());
            Dockable dockable3 = this.combiner.combine(new CombinerSourceWrapper(combinerSource){

                @Override
                public PlaceholderMap getPlaceholders() {
                    return placeholderMap;
                }
            }, combinerTarget);
            if (dockableProperty != null && (object = dockable3.asDockStation()) != null && dockable2.getDockParent() == object) {
                object.move(dockable2, dockableProperty);
            }
            this.add(dockable3, n);
            n2 = this.handles.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            object = this.handles.list().get(n2);
            ((PlaceholderList.Item)object).setPlaceholderSet(((PlaceholderList.Item)object).getPlaceholderSet());
            this.setHold(dockable3, bl);
            return true;
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    private void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        try {
            int n;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            if ((n = this.indexOf(dockable)) < 0) {
                throw new IllegalArgumentException("Child must be a child of this station");
            }
            boolean bl2 = this.isHold(dockable);
            boolean bl3 = this.getFrontDockable() == dockable;
            int n2 = this.handles.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.handles.list().get(n2);
            this.remove(n);
            this.handles.list().remove(item);
            this.add(dockable2, n);
            PlaceholderList.Item item2 = this.handles.list().get(n2);
            if (bl) {
                item2.setPlaceholderMap(dockable.asDockStation().getPlaceholders());
            } else {
                item2.setPlaceholderMap(item.getPlaceholderMap());
            }
            item2.setPlaceholderSet(item.getPlaceholderSet());
            this.setHold(dockable2, bl2);
            if (bl3) {
                this.setFrontDockable(dockable2);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public int indexOf(Dockable dockable) {
        PlaceholderList.Filter filter = this.handles.dockables();
        int n = 0;
        for (DockableHandle dockableHandle : filter) {
            if (dockableHandle.getDockable() == dockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void checkShowing() {
        boolean bl = this.isDockableShowing();
        if (bl != this.lastShowing) {
            this.lastShowing = bl;
            if (bl) {
                if (this.oldFrontDockable != null) {
                    this.setFrontDockable(this.oldFrontDockable);
                }
            } else {
                this.oldFrontDockable = this.getFrontDockable();
                this.setFrontDockable(null);
                if (!this.isHold(this.oldFrontDockable)) {
                    this.oldFrontDockable = null;
                }
            }
            this.showingManager.fire();
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.flap");
        }

        @Override
        public DockStation getStation() {
            return FlapDockStation.this;
        }

        @Override
        public Component getComponent() {
            return FlapDockStation.this.getComponent();
        }
    }

    private class ButtonListener
    extends MouseInputAdapter {
        private Dockable dockable;

        public ButtonListener(Dockable dockable) {
            this.dockable = dockable;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dockable.getDockParent() == FlapDockStation.this) {
                boolean bl;
                DisablingStrategy disablingStrategy = (DisablingStrategy)FlapDockStation.this.disablingStrategy.getValue();
                boolean bl2 = bl = disablingStrategy == null || !disablingStrategy.isDisabled(this.dockable) && !disablingStrategy.isDisabled(FlapDockStation.this);
                if (bl && mouseEvent.getButton() == 1 && (mouseEvent.getModifiersEx() & 0x1C00) == 0) {
                    int n = FlapDockStation.this.indexOf(this.dockable);
                    if (n < 0) {
                        return;
                    }
                    DockableHandle dockableHandle = (DockableHandle)FlapDockStation.this.handles.dockables().get(n);
                    DockTitle dockTitle = dockableHandle.getTitle();
                    if (FlapDockStation.this.getFrontDockable() == this.dockable && dockTitle.isActive()) {
                        FlapDockStation.this.getController().setFocusedDockable(new DefaultFocusRequest(FlapDockStation.this, null, true));
                        FlapDockStation.this.setFrontDockable(null);
                    } else {
                        FlapDockStation.this.getController().setFocusedDockable(new DefaultFocusRequest(this.dockable, null, true));
                    }
                }
            }
        }
    }

    private class ControllerListener
    implements FocusVetoListener,
    DockableFocusListener {
        private ControllerListener() {
        }

        @Override
        public FocusVetoListener.FocusVeto vetoFocus(FocusController focusController, Dockable dockable) {
            return FocusVetoListener.FocusVeto.NONE;
        }

        @Override
        public FocusVetoListener.FocusVeto vetoFocus(FocusController focusController, DockTitle dockTitle) {
            for (DockableHandle dockableHandle : FlapDockStation.this.handles.dockables()) {
                if (dockableHandle.getTitle() != dockTitle) continue;
                return FocusVetoListener.FocusVeto.VETO_NO_CONSUME;
            }
            return FocusVetoListener.FocusVeto.NONE;
        }

        @Override
        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            Dockable dockable = FlapDockStation.this.getFrontDockable();
            if (FlapDockStation.this.isStationShowing()) {
                if (dockable == null || dockable != null && FlapDockStation.this.isHold(dockable)) {
                    return;
                }
                DockController dockController = dockableFocusEvent.getController();
                Dockable dockable2 = dockableFocusEvent.getNewFocusOwner();
                if (dockController.isFocused(FlapDockStation.this)) {
                    return;
                }
                if (dockable2 == null || !DockUtilities.isAncestor(FlapDockStation.this, dockable2)) {
                    FlapDockStation.this.setFrontDockable(null);
                }
            }
        }
    }

    public static enum Direction {
        NORTH,
        WEST,
        SOUTH,
        EAST;

    }

    protected class DockableHandle
    implements PlaceholderListItem<Dockable> {
        private Dockable dockable;
        private DockTitleRequest title;
        private ButtonListener buttonListener;
        private FlapDockStationSource actions;

        public DockableHandle(Dockable dockable) {
            this(dockable, false);
        }

        public DockableHandle(Dockable dockable, boolean bl) {
            this.dockable = dockable;
            this.buttonListener = new ButtonListener(dockable);
            if (FlapDockStation.this.holdAction != null || bl) {
                this.actions = new FlapDockStationSource(FlapDockStation.this, dockable, (DockAction)FlapDockStation.this.holdAction);
                this.actions.updateHoldSwitchable();
            }
        }

        public FlapDockStationSource getActions() {
            return this.actions;
        }

        public void resetHoldAction() {
            if (this.actions != null) {
                this.actions.setHoldAction(FlapDockStation.this.holdAction);
            }
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        @Override
        public Dockable asDockable() {
            return this.getDockable();
        }

        public DockTitle getTitle() {
            if (this.title == null) {
                return null;
            }
            return (DockTitle)this.title.getAnswer();
        }

        public void setTitle(DockTitleVersion dockTitleVersion) {
            if (this.title != null) {
                DockTitle dockTitle = (DockTitle)this.title.getAnswer();
                if (dockTitle != null) {
                    dockTitle.removeMouseInputListener(this.buttonListener);
                    this.dockable.unbind(dockTitle);
                    FlapDockStation.this.buttonPane.resetTitles();
                }
                this.title.uninstall();
                this.title = null;
            }
            if (dockTitleVersion != null) {
                this.title = new DockTitleRequest(FlapDockStation.this, this.dockable, dockTitleVersion){

                    @Override
                    protected void answer(DockTitle dockTitle, DockTitle dockTitle2) {
                        if (dockTitle != null) {
                            dockTitle.removeMouseInputListener(DockableHandle.this.buttonListener);
                            DockableHandle.this.dockable.unbind(dockTitle);
                        }
                        if (dockTitle2 != null) {
                            dockTitle2.addMouseInputListener(DockableHandle.this.buttonListener);
                            dockTitle2.setOrientation(FlapDockStation.this.orientation(FlapDockStation.this.direction));
                            DockableHandle.this.dockable.bind(dockTitle2);
                        }
                        FlapDockStation.this.buttonPane.resetTitles();
                    }
                };
                this.title.install();
                this.title.request();
            }
        }
    }

    protected class FlapDropOperation
    implements StationDropOperation {
        private FlapDropInfo dropInfo;
        private boolean move;

        public FlapDropOperation(FlapDropInfo flapDropInfo, boolean bl) {
            if (flapDropInfo == null) {
                throw new IllegalArgumentException("dropInfo must not be null");
            }
            this.dropInfo = flapDropInfo;
            this.move = bl;
        }

        @Override
        public boolean isMove() {
            return this.move;
        }

        @Override
        public void draw() {
            FlapDockStation.this.setDropInfo(this.dropInfo);
        }

        @Override
        public void destroy(StationDropOperation stationDropOperation) {
            if (!(FlapDockStation.this.dropInfo != this.dropInfo || stationDropOperation != null && stationDropOperation instanceof FlapDropOperation && stationDropOperation.getTarget() == this.getTarget())) {
                FlapDockStation.this.setDropInfo(null);
            }
        }

        @Override
        public Dockable getItem() {
            return this.dropInfo.getDockable();
        }

        @Override
        public DockStation getTarget() {
            return FlapDockStation.this;
        }

        @Override
        public CombinerTarget getCombination() {
            return this.dropInfo.getCombineTarget();
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            CombinerTarget combinerTarget = this.getCombination();
            if (combinerTarget == null) {
                return null;
            }
            return combinerTarget.getDisplayerCombination();
        }

        @Override
        public void execute() {
            if (this.isMove()) {
                this.move();
            } else {
                this.drop();
            }
        }

        public void move() {
            if (this.dropInfo.getCombineTarget() != null) {
                FlapDockStation.this.remove(this.dropInfo.getDockable());
                FlapDockStation.this.combine(this.dropInfo, this.dropInfo.getCombineTarget(), null);
            } else {
                int n = FlapDockStation.this.indexOf(this.dropInfo.getDockable());
                if (n < this.dropInfo.getIndex()) {
                    this.dropInfo.setIndex(this.dropInfo.getIndex() - 1);
                }
                FlapDockStation.this.handles.dockables().move(n, this.dropInfo.getIndex());
                FlapDockStation.this.buttonPane.resetTitles();
                FlapDockStation.this.fireDockablesRepositioned(Math.min(n, this.dropInfo.getIndex()), Math.max(n, this.dropInfo.getIndex()));
            }
        }

        public void drop() {
            if (this.dropInfo.getCombineTarget() != null) {
                FlapDockStation.this.combine(this.dropInfo, this.dropInfo.getCombineTarget(), null);
            } else {
                FlapDockStation.this.add(this.dropInfo.getDockable(), this.dropInfo.getIndex());
            }
        }
    }

    private class Listener
    extends DockableAdapter {
        private Listener() {
        }

        @Override
        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            int n = FlapDockStation.this.indexOf(dockable);
            if (n < 0) {
                return;
            }
            DockableHandle dockableHandle = (DockableHandle)FlapDockStation.this.handles.dockables().get(n);
            if (dockableHandle.getTitle() == dockTitle) {
                dockableHandle.setTitle(FlapDockStation.this.buttonVersion);
            }
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            if (dockable == FlapDockStation.this) {
                FlapDockStation.this.checkShowing();
            }
        }
    }
}

